export enum SettingsPath {
  ProfilePage = 'profile',
  TwoFactorAuthenticationStrategyConfig = 'profile/two-factor-authentication/:twoFactorAuthenticationStrategy',
  Experience = 'experience',
  Accounts = 'accounts',
  NewAccount = 'accounts/new',
  AccountsConfiguration = 'accounts/configuration/:connectedAccountId',
  AccountsCalendars = 'accounts/calendars',
  AccountsEmails = 'accounts/emails',
  NewImapSmtpCaldavConnection = 'accounts/new-imap-smtp-caldav-connection',
  EditImapSmtpCaldavConnection = 'accounts/edit-imap-smtp-caldav-connection/:connectedAccountId',
  Billing = 'billing',
  Objects = 'objects',
  ObjectOverview = 'objects/overview',
  ObjectDetail = 'objects/:objectNamePlural',
  ObjectNewFieldSelect = 'objects/:objectNamePlural/new-field/select',
  ObjectNewFieldConfigure = 'objects/:objectNamePlural/new-field/configure',
  ObjectFieldEdit = 'objects/:objectNamePlural/:fieldName',
  NewObject = 'objects/new',
  WorkspaceMembersPage = 'members',
  WorkspaceMemberPage = 'members/:workspaceMemberId',
  Workspace = 'general',
  Domains = 'domains',
  Domain = 'domains/domain',
  PublicDomain = 'domains/public-domain',
  NewApprovedAccessDomain = 'domains/approved-access-domain/new',
  NewEmailingDomain = 'domains/emailing-domain/new',
  EmailingDomainDetail = 'domains/emailing-domain/:domainId',
  Updates = 'updates',
  AI = 'ai',
  AIPrompts = 'ai/prompts',
  AINewAgent = 'ai/new-agent',
  AIAgentDetail = 'ai/agents/:agentId',
  AIAgentTurnDetail = 'ai/agents/:agentId/turns/:turnId',
  AINewSkill = 'ai/new-skill',
  AISkillDetail = 'ai/skills/:skillId',
  Applications = 'applications',
  ApplicationDetail = 'applications/:applicationId',
  ApplicationLogicFunctionDetail = 'applications/:applicationId/logicFunctions/:logicFunctionId',
  AvailableApplicationDetail = 'applications/available/:availableApplicationId',
  LogicFunctions = 'functions',
  NewLogicFunction = 'functions/new',
  LogicFunctionDetail = 'functions/:logicFunctionId',
  ApiWebhooks = 'api-webhooks',
  RestPlayground = 'playground/rest/:schema',
  GraphQLPlayground = 'playground/graphql/:schema',
  NewApiKey = 'api-webhooks/apis/new',
  ApiKeyDetail = 'api-webhooks/apis/:apiKeyId',
  NewWebhook = 'api-webhooks/webhooks/new',
  WebhookDetail = 'api-webhooks/webhooks/:webhookId',
  Integrations = 'integrations',
  Security = 'security',
  NewSSOIdentityProvider = 'security/sso/new',
  EventLogs = 'security/event-logs',

  AdminPanel = 'admin-panel',
  AdminPanelHealthStatus = 'admin-panel#health-status',
  AdminPanelIndicatorHealthStatus = 'admin-panel/health-status/:indicatorId',
  AdminPanelQueueDetail = 'admin-panel/health-status/queue/:queueName',
  AdminPanelConfigVariableDetails = 'admin-panel/config-variables/:variableName',

  Roles = 'roles',
  RoleCreate = 'roles/create',
  RoleDetail = 'roles/:roleId',
  RoleObjectLevel = 'roles/:roleId/object/:objectMetadataId',
  RoleAddObjectLevel = 'roles/:roleId/add-object-permission',
}
