import { type CurrencyCode } from '@/constants/CurrencyCode';

export const CURRENCY_CODE_LABELS: Record<CurrencyCode, { label: string }> = {
  AED: { label: 'UAE dirham' },
  AFN: { label: 'Afghan afghani' },
  ALL: { label: 'Albanian lek' },
  AMD: { label: 'Armenian dram' },
  ANG: { label: 'Netherlands Antillean guilder' },
  AOA: { label: 'Angolan kwanza' },
  ARS: { label: 'Argentine peso' },
  AUD: { label: 'Australian dollar' },
  AWG: { label: 'Aruban florin' },
  AZN: { label: 'Azerbaijani manat' },
  BAM: { label: 'Bosnia and Herzegovina mark' },
  BBD: { label: 'Barbados dollar' },
  BDT: { label: 'Bangladeshi taka' },
  BGN: { label: 'Bulgarian lev' },
  BHD: { label: 'Bahraini dinar' },
  BIF: { label: 'Burundian franc' },
  BMD: { label: 'Bermudian dollar' },
  BND: { label: 'Brunei dollar' },
  BOB: { label: 'Boliviano' },
  BRL: { label: 'Brazilian real' },
  BSD: { label: 'Bahamian dollar' },
  BTN: { label: 'Bhutanese ngultrum' },
  BWP: { label: 'Botswana pula' },
  BYN: { label: 'Belarusian ruble' },
  BZD: { label: 'Belize dollar' },
  CAD: { label: 'Canadian dollar' },
  CDF: { label: 'Congolese franc' },
  CHF: { label: 'Swiss franc' },
  CLP: { label: 'Chilean peso' },
  CNY: { label: 'Chinese yuan' },
  COP: { label: 'Colombian peso' },
  CRC: { label: 'Costa Rican colon' },
  CUP: { label: 'Cuban peso' },
  CVE: { label: 'Cape Verdean escudo' },
  CZK: { label: 'Czech koruna' },
  DJF: { label: 'Djiboutian franc' },
  DKK: { label: 'Danish krone' },
  DOP: { label: 'Dominican peso' },
  DZD: { label: 'Algerian Dinar' },
  EGP: { label: 'Egyptian pound' },
  ERN: { label: 'Eritrean nakfa' },
  ETB: { label: 'Ethiopian birr' },
  EUR: { label: 'Euro' },
  FJD: { label: 'Fiji dollar' },
  FKP: { label: 'Falkland Islands pound' },
  GBP: { label: 'British pound' },
  GEL: { label: 'Georgian lari' },
  GHS: { label: 'Ghanaian cedi' },
  GIP: { label: 'Gibraltar pound' },
  GMD: { label: 'Gambian dalasi' },
  GNF: { label: 'Guinean franc' },
  GTQ: { label: 'Guatemalan quetzal' },
  GYD: { label: 'Guyanese dollar' },
  HKD: { label: 'Hong Kong dollar' },
  HNL: { label: 'Honduran lempira' },
  HTG: { label: 'Haitian gourde' },
  HUF: { label: 'Hungarian forint' },
  IDR: { label: 'Indonesian rupiah' },
  ILS: { label: 'Israeli shekel' },
  INR: { label: 'Indian rupee' },
  IQD: { label: 'Iraqi dinar' },
  IRR: { label: 'Iranian rial' },
  ISK: { label: 'Icelandic króna' },
  JMD: { label: 'Jamaican dollar' },
  JOD: { label: 'Jordanian dinar' },
  JPY: { label: 'Japanese yen' },
  KES: { label: 'Kenyan shilling' },
  KGS: { label: 'Kyrgyzstani som' },
  KHR: { label: 'Cambodian riel' },
  KMF: { label: 'Comoro franc' },
  KPW: { label: 'North Korean won' },
  KRW: { label: 'South Korean won' },
  KWD: { label: 'Kuwaiti dinar' },
  KYD: { label: 'Cayman Islands dollar' },
  KZT: { label: 'Kazakhstani tenge' },
  LAK: { label: 'Lao kip' },
  LBP: { label: 'Lebanese pound' },
  LKR: { label: 'Sri Lankan rupee' },
  LRD: { label: 'Liberian dollar' },
  LSL: { label: 'Lesotho loti' },
  LYD: { label: 'Libyan dinar' },
  MAD: { label: 'Moroccan dirham' },
  MDL: { label: 'Moldovan leu' },
  MGA: { label: 'Malagasy ariary' },
  MKD: { label: 'Macedonian denar' },
  MMK: { label: 'Myanmar kyat' },
  MNT: { label: 'Mongolian tögrög' },
  MOP: { label: 'Macanese pataca' },
  MRU: { label: 'Mauritanian ouguiya' },
  MUR: { label: 'Mauritian rupee' },
  MVR: { label: 'Maldivian rufiyaa' },
  MWK: { label: 'Malawian kwacha' },
  MXN: { label: 'Mexican peso' },
  MYR: { label: 'Malaysian ringgit' },
  MZN: { label: 'Mozambican metical' },
  NAD: { label: 'Namibian dollar' },
  NGN: { label: 'Nigerian naira' },
  NIO: { label: 'Nicaraguan córdoba' },
  NOK: { label: 'Norwegian krone' },
  NPR: { label: 'Nepalese rupee' },
  NZD: { label: 'New Zealand dollar' },
  OMR: { label: 'Omani rial' },
  PAB: { label: 'Panamanian balboa' },
  PEN: { label: 'Peruvian sol' },
  PGK: { label: 'Papua New Guinean kina' },
  PHP: { label: 'Philippine peso' },
  PKR: { label: 'Pakistani rupee' },
  PLN: { label: 'Polish złoty' },
  PYG: { label: 'Paraguayan guaraní' },
  QAR: { label: 'Qatari riyal' },
  RON: { label: 'Romanian leu' },
  RSD: { label: 'Serbian dinar' },
  RUB: { label: 'Russian ruble' },
  RWF: { label: 'Rwandan franc' },
  SAR: { label: 'Saudi riyal' },
  SBD: { label: 'Solomon Islands dollar' },
  SCR: { label: 'Seychelles rupee' },
  SDG: { label: 'Sudanese pound' },
  SEK: { label: 'Swedish krona' },
  SGD: { label: 'Singapore dollar' },
  SHP: { label: 'Saint Helena pound' },
  SLE: { label: 'Sierra Leonean leone' },
  SOS: { label: 'Somalian shilling' },
  SRD: { label: 'Surinamese dollar' },
  SSP: { label: 'South Sudanese pound' },
  STN: { label: 'São Tomé and Príncipe dobra' },
  SVC: { label: 'Salvadoran colón' },
  SYP: { label: 'Syrian pound' },
  SZL: { label: 'Swazi lilangeni' },
  THB: { label: 'Thai Baht' },
  TJS: { label: 'Tajikistani somoni' },
  TMT: { label: 'Turkmenistan manat' },
  TND: { label: 'Tunisian dinar' },
  TOP: { label: 'Tongan paʻanga' },
  TRY: { label: 'Turkish lira' },
  TTD: { label: 'Trinidad and Tobago dollar' },
  TWD: { label: 'Taiwanese dollar' },
  TZS: { label: 'Tanzanian shilling' },
  UAH: { label: 'Ukrainian hryvnia' },
  UGX: { label: 'Ugandan shilling' },
  USD: { label: 'United States dollar' },
  UYU: { label: 'Uruguayan peso' },
  UZS: { label: 'Uzbekistani sum' },
  VES: { label: 'Venezuelan bolívar' },
  VND: { label: 'Vietnamese đồng' },
  VUV: { label: 'Vanuatu vatu' },
  WST: { label: 'Samoan tala' },
  XOF: { label: 'West African CFA franc' },
  XCD: { label: 'East Caribbean dollar' },
  YER: { label: 'Yemeni rial' },
  ZAR: { label: 'South African rand' },
  ZMW: { label: 'Zambian kwacha' },
  ZWG: { label: 'Zimbabwe Gold' },
};
