import { type FieldMetadataTypesToTestForFilterInputValidation } from 'test/integration/graphql/suites/inputs-validation/types/field-metadata-type-to-test';
import { joinColumnNameForManyToOneMorphRelationField1 } from 'test/integration/graphql/suites/inputs-validation/utils/setup-test-objects-with-all-field-types.util';
import { FieldMetadataType } from 'twenty-shared/types';

import { type CompositeFieldMetadataType } from 'src/engine/metadata-modules/field-metadata/types/composite-field-metadata-type.type';

export const failingFilterInputByFieldMetadataType: {
  [K in Exclude<
    FieldMetadataTypesToTestForFilterInputValidation,
    CompositeFieldMetadataType
  >]: {
    gqlFilterInput: any;
    restFilterInput: any;
    gqlErrorMessage: string;
    restErrorMessage: string;
  }[];
} = {
  [FieldMetadataType.RELATION]: [
    {
      gqlFilterInput: {
        manyToOneRelationField: {
          eq: '6dd71a46-68fe-4420-82b3-0d5b00ad2642',
        },
      },
      gqlErrorMessage: 'is not defined by type',
      restFilterInput:
        'manyToOneRelationField[eq]:"6dd71a46-68fe-4420-82b3-0d5b00ad2642"',
      restErrorMessage: 'Data validation error',
    },
    {
      gqlFilterInput: {
        manyToOneRelationFieldId: {
          eq: 'invalid-uuid',
        },
      },
      gqlErrorMessage: 'Invalid UUID',
      restFilterInput: 'manyToOneRelationFieldId[eq]:"invalid-uuid"',
      restErrorMessage: 'invalid input syntax for type uuid',
    },
    {
      gqlFilterInput: {
        oneToManyRelationField: {
          eq: '6dd71a46-68fe-4420-82b3-0d5b00ad2642',
        },
      },
      gqlErrorMessage: 'is not defined by type',
      restFilterInput:
        'oneToManyRelationFieldId[eq]:"6dd71a46-68fe-4420-82b3-0d5b00ad2642"',
      restErrorMessage:
        'Field metadata not found for field: oneToManyRelationFieldId',
    },
    // {
    //   gqlFilterInput: {
    //     oneToManyRelationFieldId: {
    //       eq: 'invalid-uuid',
    //     },
    //   },
    //   restFilterInput: 'oneToManyRelationFieldId[eq]:"invalid-uuid"',
    //   gqlErrorMessage: 'is not defined by type',
    //   restErrorMessage: "'oneToManyRelationFieldId' does not exist",
    // },
  ],
  [FieldMetadataType.MORPH_RELATION]: [
    {
      gqlFilterInput: {
        [joinColumnNameForManyToOneMorphRelationField1]: { eq: 'invalid-uuid' },
      },
      gqlErrorMessage: 'Invalid UUID',
      restFilterInput: `${joinColumnNameForManyToOneMorphRelationField1}[eq]:"invalid-uuid"`,
      restErrorMessage: 'invalid input syntax for type uuid',
    },
    {
      gqlFilterInput: {
        [joinColumnNameForManyToOneMorphRelationField1.replace('Id', '')]: {
          eq: '6dd71a46-68fe-4420-82b3-0d5b00ad2642',
        },
      },
      gqlErrorMessage: 'is not defined by type',
      restFilterInput: `${[joinColumnNameForManyToOneMorphRelationField1.replace('Id', '')]}[eq]:"6dd71a46-68fe-4420-82b3-0d5b00ad2642"`,
      restErrorMessage: `Data validation error`,
    },
  ],
  [FieldMetadataType.UUID]: [
    {
      gqlFilterInput: { uuidField: { eq: 'invalid-uuid' } },
      gqlErrorMessage: 'Invalid UUID',
      restFilterInput: 'uuidField[eq]:"invalid-uuid"',
      restErrorMessage: 'invalid input syntax for type uuid',
    },
    {
      gqlFilterInput: { uuidField: { eq: undefined } },
      gqlErrorMessage:
        'undefined is not iterable (cannot read property Symbol(Symbol.iterator))',
      restFilterInput: 'uuidField[eq]:"undefined"',
      restErrorMessage: 'invalid input syntax for type uuid',
    },
    {
      gqlFilterInput: { uuidField: { eq: 2 } },
      gqlErrorMessage: 'UUID must be a string',
      restFilterInput: 'uuidField[eq]:2',
      restErrorMessage: 'invalid input syntax for type uuid',
    },
    {
      gqlFilterInput: { uuidField: { eq: {} } },
      gqlErrorMessage: 'UUID must be a string',
      restFilterInput: 'uuidField[eq]:"{}"',
      restErrorMessage: 'invalid input syntax for type uuid',
    },
    {
      gqlFilterInput: { uuidField: { eq: [] } },
      gqlErrorMessage: 'UUID must be a string',
      restFilterInput: 'uuidField[eq]:"[]"',
      restErrorMessage: 'invalid input syntax for type uuid',
    },
    {
      gqlFilterInput: { uuidField: { eq: true } },
      gqlErrorMessage: 'UUID must be a string',
      restFilterInput: 'uuidField[eq]:"true"',
      restErrorMessage: 'invalid input syntax for type uuid',
    },
    {
      gqlFilterInput: { uuidField: { eq: '2025-01-01' } },
      gqlErrorMessage: 'Invalid UUID',
      restFilterInput: 'uuidField[eq]:"2025-01-01"',
      restErrorMessage: 'invalid input syntax for type uuid',
    },
  ],
  [FieldMetadataType.TEXT]: [
    {
      gqlFilterInput: {
        textField: { regex: 'test' },
      },
      gqlErrorMessage: 'Operator "regex" is not supported',
      restFilterInput: 'textField[regex]:test',
      restErrorMessage: 'comparator regex not in',
    },
    {
      gqlFilterInput: {
        textField: { iregex: 'test' },
      },
      gqlErrorMessage: 'Operator "iregex" is not supported',
      restFilterInput: 'textField[iregex]:test',
      restErrorMessage: 'comparator iregex not in',
    },
  ],
  [FieldMetadataType.DATE_TIME]: [
    {
      gqlFilterInput: { dateTimeField: { eq: 'not-a-date-time' } },
      gqlErrorMessage: 'Data validation error.',
      restFilterInput: 'dateTimeField[eq]:"not-a-date-time"',
      restErrorMessage: 'Data validation error.',
    },
    {
      gqlFilterInput: { dateTimeField: { eq: {} } },
      gqlErrorMessage: 'Data validation error.',
      restFilterInput: 'dateTimeField[eq]:"{}"',
      restErrorMessage: 'Data validation error.',
    },
    {
      gqlFilterInput: { dateTimeField: { eq: [] } },
      gqlErrorMessage: 'Data validation error.',
      restFilterInput: 'dateTimeField[eq]:"[]"',
      restErrorMessage: 'Data validation error.',
    },
    // TODO - fix this, should throw an error
    // {
    //   gqlFilterInput: { dateTimeField: { eq: true } },
    //   gqlErrorMessage:
    //     'invalid input syntax for type timestamp with time zone: "0NaN-NaN-NaNTNaN:NaN:NaN.NaN+NaN:NaN"',
    // },
  ],
  [FieldMetadataType.DATE]: [
    {
      gqlFilterInput: { dateField: { eq: 'not-a-date' } },
      gqlErrorMessage: 'Data validation error',
      restFilterInput: 'dateField[eq]:"{}"',
      restErrorMessage: 'Data validation error',
    },
    {
      gqlFilterInput: { dateField: { eq: {} } },
      gqlErrorMessage: 'Data validation error',
      restFilterInput: 'dateField[eq]:"{}"',
      restErrorMessage: 'Data validation error',
    },
    {
      gqlFilterInput: { dateField: { eq: [] } },
      gqlErrorMessage: 'Data validation error',
      restFilterInput: 'dateField[eq]:"[]"',
      restErrorMessage: 'Data validation error',
    },
  ],
  [FieldMetadataType.BOOLEAN]: [
    {
      gqlFilterInput: { booleanField: { eq: 'not-a-boolean' } },
      gqlErrorMessage:
        'Boolean cannot represent a non boolean value: "not-a-boolean"',
      restFilterInput: 'booleanField[eq]:"not-a-boolean"',
      restErrorMessage: 'invalid input syntax for type boolean',
    },
    {
      gqlFilterInput: { booleanField: { eq: [] } },
      gqlErrorMessage: 'Boolean cannot represent a non boolean value: []',
      restFilterInput: 'booleanField[eq]:"[]"',
      restErrorMessage: 'invalid input syntax for type boolean',
    },
    {
      gqlFilterInput: { booleanField: { eq: 2 } },
      gqlErrorMessage: 'Boolean cannot represent a non boolean value: 2',
      restFilterInput: 'booleanField[eq]:2',
      restErrorMessage: 'invalid input syntax for type boolean',
    },
  ],
  [FieldMetadataType.NUMBER]: [
    // {
    //   gqlFilterInput: { numberField: { eq: 'not-a-number' } },
    //   gqlErrorMessage:
    //     'Float cannot represent non numeric value: "not-a-number"',
    //   // TODO - fix this, should throw an error
    //   // restFilterInput: 'numberField[eq]:"not-a-number"',
    //   // restErrorMessage: 'invalid input syntax for type float',
    // },
    // {
    //   gqlFilterInput: { numberField: { eq: {} } },
    //   gqlErrorMessage: 'Float cannot represent non numeric value: {}',
    //   // TODO - fix this, should throw an error
    //   // restFilterInput: 'numberField[eq]:"{}"',
    //   // restErrorMessage: 'invalid input syntax for type float',
    // },
    // {
    //   gqlFilterInput: { numberField: { eq: [] } },
    //   gqlErrorMessage: 'Float cannot represent non numeric value: []',
    //   // TODO - fix this, should throw an error
    //   // restFilterInput: 'numberField[eq]:"[]"',
    //   // restErrorMessage: 'invalid input syntax for type float',
    // },
    // {
    //   gqlFilterInput: { numberField: { eq: true } },
    //   gqlErrorMessage: 'Float cannot represent non numeric value: true',
    //   // TODO - fix this, should throw an error
    //   // restFilterInput: 'numberField[eq]:"true"',
    //   // restErrorMessage: 'invalid input syntax for type float',
    // },
    // TODO - ensure it should throw
    // {
    //   gqlFilterInput: { numberField: { eq: null } },
    //   gqlErrorMessage: 'Float cannot represent non numeric value: null',
    // },
  ],
  [FieldMetadataType.RATING]: [
    {
      gqlFilterInput: { ratingField: { eq: 'not-a-rating' } },
      gqlErrorMessage: 'Value "not-a-rating" does not exist in ',
      restFilterInput: 'ratingField[eq]:"not-a-rating"',
      restErrorMessage: 'invalid input value for enum',
    },
    {
      gqlFilterInput: { ratingField: { eq: {} } },
      gqlErrorMessage: 'cannot represent non-string value: {}.',
      restFilterInput: 'ratingField[eq]:"{}"',
      restErrorMessage: 'invalid input value for enum',
    },
    {
      gqlFilterInput: { ratingField: { eq: [] } },
      gqlErrorMessage: 'cannot represent non-string value: [].',
      restFilterInput: 'ratingField[eq]:"[]"',
      restErrorMessage: 'invalid input value for enum',
    },
    {
      gqlFilterInput: { ratingField: { eq: true } },
      gqlErrorMessage: 'cannot represent non-string value: true.',
      restFilterInput: 'ratingField[eq]:"true"',
      restErrorMessage: 'invalid input value for enum',
    },
    {
      gqlFilterInput: { ratingField: { eq: 2 } },
      gqlErrorMessage: 'cannot represent non-string value: 2.',
      restFilterInput: 'ratingField[eq]:2',
      restErrorMessage: 'invalid input value for enum',
    },
    // TODO - ensure it should throw
    // {
    //   gqlFilterInput: { ratingField: { eq: null } },
    //   gqlErrorMessage: 'cannot represent non-string value: null.',
    // },
  ],
  [FieldMetadataType.SELECT]: [
    {
      gqlFilterInput: { selectField: { eq: 'not-a-select' } },
      gqlErrorMessage: 'Value "not-a-select" does not exist in',
      restFilterInput: 'selectField[eq]:"not-a-select"',
      restErrorMessage: "not available in 'selectField'",
    },
    {
      gqlFilterInput: { selectField: { eq: {} } },
      gqlErrorMessage: 'cannot represent non-string value: {}.',
      restFilterInput: 'selectField[eq]:"{}"',
      restErrorMessage: "not available in 'selectField'",
    },
    {
      gqlFilterInput: { selectField: { eq: [] } },
      gqlErrorMessage: 'cannot represent non-string value: [].',
      restFilterInput: 'selectField[eq]:"[]"',
      restErrorMessage: "not available in 'selectField'",
    },
    {
      gqlFilterInput: { selectField: { eq: true } },
      gqlErrorMessage: 'cannot represent non-string value: true.',
      restFilterInput: 'selectField[eq]:"true"',
      restErrorMessage: "not available in 'selectField'",
    },
    // TODO - ensure it should throw
    // {
    //   gqlFilterInput: { selectField: { eq: null } },
    //   gqlErrorMessage: 'cannot represent non-string value: null.',
    // },
  ],
  [FieldMetadataType.MULTI_SELECT]: [
    {
      gqlFilterInput: { multiSelectField: { eq: 'not-a-multi-select' } },
      gqlErrorMessage: 'Value "not-a-multi-select" does not exist ',
      restFilterInput: 'multiSelectField[eq]:"not-a-multi-select"',
      restErrorMessage: 'malformed array literal',
    },
    // TODO - fix this, should throw
    // {
    //   gqlFilterInput: { multiSelectField: { eq: {} } },
    //   gqlErrorMessage: 'cannot represent non-string value: {}.',
    //   restFilterInput: 'multiSelectField[eq]:"{}"',
    //   restErrorMessage: "not available in 'multiSelectField'",
    // },
    {
      gqlFilterInput: { multiSelectField: { eq: [] } },
      gqlErrorMessage: 'cannot represent non-string value: [].',
      restFilterInput: 'multiSelectField[eq]:"[]"',
      restErrorMessage: 'malformed array literal',
    },
    {
      gqlFilterInput: { multiSelectField: { eq: true } },
      gqlErrorMessage: 'cannot represent non-string value: true.',
      restFilterInput: 'multiSelectField[eq]:"true"',
      restErrorMessage: 'malformed array literal',
    },
    {
      gqlFilterInput: { multiSelectField: { eq: 2 } },
      gqlErrorMessage: 'cannot represent non-string value: 2.',
      restFilterInput: 'multiSelectField[eq]:2',
      restErrorMessage: 'malformed array literal',
    },
    // TODO - ensure it should throw
    // {
    //   gqlFilterInput: { multiSelectField: { eq: null } },
    //   gqlErrorMessage: 'cannot represent non-string value: null.',
    // },
  ],
  [FieldMetadataType.RAW_JSON]: [
    // {
    //   gqlFilterInput: { rawJsonField: { like: {} } },
    //   gqlErrorMessage: 'cannot represent a non string value',
    //   // TODO - fix this ?  for rest
    //   // restFilterInput: 'rawJsonField[like]:"{}"',
    //   // restErrorMessage: 'cannot represent a non string value',
    // },
    // {
    //   gqlFilterInput: { rawJsonField: { like: [] } },
    //   gqlErrorMessage: 'cannot represent a non string value',
    //   // TODO - fix this ?  for rest
    //   // restFilterInput: 'rawJsonField[like]:"[]"',
    //   // restErrorMessage: 'cannot represent a non string value',
    // },
    // {
    //   gqlFilterInput: { rawJsonField: { like: true } },
    //   gqlErrorMessage: 'cannot represent a non string value',
    //   // TODO - fix this ?  for rest
    //   // restFilterInput: 'rawJsonField[like]:"true"',
    //   // restErrorMessage: 'cannot represent a non string value',
    // },
    // {
    //   gqlFilterInput: { rawJsonField: { like: 2 } },
    //   gqlErrorMessage: 'cannot represent a non string value',
    //   // TODO - fix this ?  for rest
    //   // restFilterInput: 'rawJsonField[like]:2',
    //   // restErrorMessage: 'cannot represent a non string value',
    // },
    // TODO - ensure it should throw
    // {
    //   gqlFilterInput: { rawJsonField: { like: null } },
    //   gqlErrorMessage: 'cannot represent non-string value: null.',
    // },
  ],
  [FieldMetadataType.ARRAY]: [
    {
      gqlFilterInput: { arrayField: { containsIlike: {} } },
      gqlErrorMessage: 'cannot represent a non string value',
      restFilterInput: 'arrayField[containsAny]:"{}"',
      restErrorMessage: 'array value expected',
    },
    {
      gqlFilterInput: { arrayField: { containsIlike: [] } },
      gqlErrorMessage: 'cannot represent a non string value',
      restFilterInput: 'arrayField[containsAny]:"[]"',
      restErrorMessage: 'array value expected',
    },
    {
      gqlFilterInput: { arrayField: { containsIlike: true } },
      gqlErrorMessage: 'cannot represent a non string value',
      restFilterInput: 'arrayField[containsAny]:"true"',
      restErrorMessage: 'array value expected',
    },
    {
      gqlFilterInput: { arrayField: { containsIlike: 2 } },
      gqlErrorMessage: 'cannot represent a non string value',
      restFilterInput: 'arrayField[containsAny]:2',
      restErrorMessage: 'array value expected',
    },
  ],
  [FieldMetadataType.FILES]: [
    {
      gqlFilterInput: { filesField: { containsIlike: {} } },
      gqlErrorMessage: 'is not defined by type',
      restFilterInput: 'filesField[containsAny]:"{}"',
      restErrorMessage: 'array value expected',
    },
    {
      gqlFilterInput: { filesField: { containsIlike: [] } },
      gqlErrorMessage: 'is not defined by type',
      restFilterInput: 'filesField[containsAny]:"[]"',
      restErrorMessage: 'array value expected',
    },
    {
      gqlFilterInput: { filesField: { containsIlike: true } },
      gqlErrorMessage: 'is not defined by type',
      restFilterInput: 'filesField[containsAny]:"true"',
      restErrorMessage: 'array value expected',
    },
    {
      gqlFilterInput: { filesField: { containsIlike: 2 } },
      gqlErrorMessage: 'is not defined by type',
      restFilterInput: 'filesField[containsAny]:2',
      restErrorMessage: 'array value expected',
    },
  ],
};
