import { BaseWorkspaceEntity } from 'src/engine/twenty-orm/base.workspace-entity';
import { type CustomWorkspaceEntity } from 'src/engine/twenty-orm/custom.workspace-entity';
import { type EntityRelation } from 'src/engine/workspace-manager/workspace-migration/types/entity-relation.interface';
import { type CompanyWorkspaceEntity } from 'src/modules/company/standard-objects/company.workspace-entity';
import { type DashboardWorkspaceEntity } from 'src/modules/dashboard/standard-objects/dashboard.workspace-entity';
import { type FavoriteFolderWorkspaceEntity } from 'src/modules/favorite-folder/standard-objects/favorite-folder.workspace-entity';
import { type NoteWorkspaceEntity } from 'src/modules/note/standard-objects/note.workspace-entity';
import { type OpportunityWorkspaceEntity } from 'src/modules/opportunity/standard-objects/opportunity.workspace-entity';
import { type PersonWorkspaceEntity } from 'src/modules/person/standard-objects/person.workspace-entity';
import { type TaskWorkspaceEntity } from 'src/modules/task/standard-objects/task.workspace-entity';
import { type WorkflowRunWorkspaceEntity } from 'src/modules/workflow/common/standard-objects/workflow-run.workspace-entity';
import { type WorkflowVersionWorkspaceEntity } from 'src/modules/workflow/common/standard-objects/workflow-version.workspace-entity';
import { type WorkflowWorkspaceEntity } from 'src/modules/workflow/common/standard-objects/workflow.workspace-entity';
import { type WorkspaceMemberWorkspaceEntity } from 'src/modules/workspace-member/standard-objects/workspace-member.workspace-entity';

export class FavoriteWorkspaceEntity extends BaseWorkspaceEntity {
  position: number;
  forWorkspaceMember: EntityRelation<WorkspaceMemberWorkspaceEntity>;
  forWorkspaceMemberId: string;
  person: EntityRelation<PersonWorkspaceEntity> | null;
  personId: string;
  company: EntityRelation<CompanyWorkspaceEntity> | null;
  companyId: string;
  favoriteFolder: EntityRelation<FavoriteFolderWorkspaceEntity> | null;
  favoriteFolderId: string;
  opportunity: EntityRelation<OpportunityWorkspaceEntity> | null;
  opportunityId: string;
  workflow: EntityRelation<WorkflowWorkspaceEntity> | null;
  workflowId: string;
  workflowVersion: EntityRelation<WorkflowVersionWorkspaceEntity> | null;
  workflowVersionId: string;
  workflowRun: EntityRelation<WorkflowRunWorkspaceEntity> | null;
  workflowRunId: string;
  task: EntityRelation<TaskWorkspaceEntity> | null;
  taskId: string;
  note: EntityRelation<NoteWorkspaceEntity> | null;
  noteId: string;
  dashboard: EntityRelation<DashboardWorkspaceEntity> | null;
  dashboardId: string;
  viewId: string;
  custom: EntityRelation<CustomWorkspaceEntity>;
}
