import {
  type FieldMetadataComplexOption,
  type FieldMetadataDefaultOption,
  type FieldMetadataDefaultValue,
  type FieldMetadataSettings,
  type FieldMetadataType,
} from 'twenty-shared/types';
import { STANDARD_OBJECTS } from 'twenty-shared/metadata';

import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';
import { type AllStandardObjectFieldName } from 'src/engine/workspace-manager/twenty-standard-application/types/all-standard-object-field-name.type';
import { type AllStandardObjectName } from 'src/engine/workspace-manager/twenty-standard-application/types/all-standard-object-name.type';
import { type StandardBuilderArgs } from 'src/engine/workspace-manager/twenty-standard-application/types/metadata-standard-buillder-args.type';

type WithRequiredId<T> = T & { id: string };

export type CreateStandardFieldArgs<
  O extends AllStandardObjectName,
  T extends FieldMetadataType,
> = StandardBuilderArgs<'fieldMetadata'> & {
  objectName: O;
  context: {
    fieldName: AllStandardObjectFieldName<O>;
    type: T;
    label: string;
    description: string;
    icon: string;
    isSystem?: boolean;
    isNullable?: boolean;
    isUnique?: boolean;
    isUIReadOnly?: boolean;
    defaultValue?: FieldMetadataDefaultValue<T>;
    settings?: FieldMetadataSettings<T>;
    options?:
      | WithRequiredId<FieldMetadataDefaultOption>[]
      | WithRequiredId<FieldMetadataComplexOption>[]
      | null;
  };
};

export const createStandardFieldFlatMetadata = <
  O extends AllStandardObjectName,
  T extends FieldMetadataType,
>({
  objectName,
  workspaceId,
  context: {
    fieldName,
    type,
    label,
    description,
    icon,
    isSystem = false,
    isNullable = true,
    isUnique = false,
    isUIReadOnly = false,
    defaultValue,
    settings,
    options: fieldOptions = null,
  },
  standardObjectMetadataRelatedEntityIds,
  twentyStandardApplicationId,
  now,
}: CreateStandardFieldArgs<O, T>): FlatFieldMetadata => {
  const objectFields = STANDARD_OBJECTS[objectName].fields;
  const fieldDefinition = objectFields[fieldName as keyof typeof objectFields];
  const fieldIds = standardObjectMetadataRelatedEntityIds[objectName].fields;

  const name = fieldName.toString();

  return {
    id: fieldIds[fieldName].id,
    universalIdentifier: fieldDefinition.universalIdentifier,
    applicationId: twentyStandardApplicationId,
    workspaceId,
    objectMetadataId: standardObjectMetadataRelatedEntityIds[objectName].id,
    type,
    name,
    label,
    description,
    icon,
    isCustom: false,
    isActive: true,
    isSystem,
    isNullable,
    isUnique,
    isUIReadOnly,
    isLabelSyncedWithName: false,
    standardOverrides: null,
    defaultValue: defaultValue ?? null,
    settings: settings ?? null,
    options: fieldOptions ?? null,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    morphId: null,
    viewFieldIds: [],
    viewFilterIds: [],
    kanbanAggregateOperationViewIds: [],
    calendarViewIds: [],
    mainGroupByFieldMetadataViewIds: [],
    createdAt: now,
    updatedAt: now,
    applicationUniversalIdentifier: twentyStandardApplicationId,
    objectMetadataUniversalIdentifier:
      STANDARD_OBJECTS[objectName].universalIdentifier,
    relationTargetObjectMetadataUniversalIdentifier: null,
    relationTargetFieldMetadataUniversalIdentifier: null,
    viewFilterUniversalIdentifiers: [],
    viewFieldUniversalIdentifiers: [],
    kanbanAggregateOperationViewUniversalIdentifiers: [],
    calendarViewUniversalIdentifiers: [],
    mainGroupByFieldMetadataViewUniversalIdentifiers: [],
    universalSettings: settings ?? null,
  };
};
