import {
  DateDisplayFormat,
  FieldMetadataType,
  RelationOnDeleteAction,
  RelationType,
} from 'twenty-shared/types';

import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';
import { type AllStandardObjectFieldName } from 'src/engine/workspace-manager/twenty-standard-application/types/all-standard-object-field-name.type';
import {
  type CreateStandardFieldArgs,
  createStandardFieldFlatMetadata,
} from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-field-flat-metadata.util';
import { createStandardRelationFieldFlatMetadata } from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-relation-field-flat-metadata.util';
import { getTsVectorColumnExpressionFromFields } from 'src/engine/workspace-manager/utils/get-ts-vector-column-expression.util';
import {
  MessageChannelType,
  SEARCH_FIELDS_FOR_MESSAGE_CHANNEL,
} from 'src/modules/messaging/common/standard-objects/message-channel.workspace-entity';

export const buildMessageChannelStandardFlatFieldMetadatas = ({
  now,
  objectName,
  workspaceId,
  standardObjectMetadataRelatedEntityIds,
  dependencyFlatEntityMaps,
  twentyStandardApplicationId,
}: Omit<
  CreateStandardFieldArgs<'messageChannel', FieldMetadataType>,
  'context'
>): Record<
  AllStandardObjectFieldName<'messageChannel'>,
  FlatFieldMetadata
> => ({
  id: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'id',
      type: FieldMetadataType.UUID,
      label: 'Id',
      description: 'Id',
      icon: 'Icon123',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'uuid',
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  createdAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'createdAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Creation date',
      description: 'Creation date',
      icon: 'IconCalendar',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'now',
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  updatedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'updatedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Last update',
      description: 'Last time the record was changed',
      icon: 'IconCalendarClock',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'now',
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  deletedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'deletedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Deleted at',
      description: 'Date when the record was deleted',
      icon: 'IconCalendarMinus',
      isSystem: true,
      isNullable: true,
      isUIReadOnly: true,
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  createdBy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'createdBy',
      type: FieldMetadataType.ACTOR,
      label: 'Created by',
      description: 'The creator of the record',
      icon: 'IconCreativeCommonsSa',
      isSystem: true,
      isUIReadOnly: true,
      isNullable: false,
      defaultValue: {
        source: "'MANUAL'",
        name: "'System'",
        workspaceMemberId: null,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  updatedBy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'updatedBy',
      type: FieldMetadataType.ACTOR,
      label: 'Updated by',
      description: 'The workspace member who last updated the record',
      icon: 'IconUserCircle',
      isSystem: true,
      isUIReadOnly: true,
      isNullable: false,
      defaultValue: {
        source: "'MANUAL'",
        name: "'System'",
        workspaceMemberId: null,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  position: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'position',
      type: FieldMetadataType.POSITION,
      label: 'Position',
      description: 'Message Channel record position',
      icon: 'IconHierarchy2',
      isSystem: true,
      isNullable: false,
      defaultValue: 0,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  searchVector: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'searchVector',
      type: FieldMetadataType.TS_VECTOR,
      label: 'Search vector',
      description: 'Field used for full-text search',
      icon: 'IconUser',
      isSystem: true,
      isNullable: true,
      settings: {
        generatedType: 'STORED',
        asExpression: getTsVectorColumnExpressionFromFields(
          SEARCH_FIELDS_FOR_MESSAGE_CHANNEL,
        ),
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  visibility: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'visibility',
      type: FieldMetadataType.SELECT,
      label: 'Visibility',
      description: 'Visibility',
      icon: 'IconEyeglass',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'SHARE_EVERYTHING'",
      options: [
        {
          id: '20202020-4548-4830-b3f8-221fd082ebc0',
          value: 'METADATA',
          label: 'Metadata',
          position: 0,
          color: 'green',
        },
        {
          id: '20202020-6a42-40a8-b81e-28b7e591c598',
          value: 'SUBJECT',
          label: 'Subject',
          position: 1,
          color: 'blue',
        },
        {
          id: '20202020-d520-4cba-8832-5bca315b64f3',
          value: 'SHARE_EVERYTHING',
          label: 'Share Everything',
          position: 2,
          color: 'orange',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  handle: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'handle',
      type: FieldMetadataType.TEXT,
      label: 'Handle',
      description: 'Handle',
      icon: 'IconAt',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  type: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'type',
      type: FieldMetadataType.SELECT,
      label: 'Type',
      description: 'Channel Type',
      icon: 'IconMessage',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: `'${MessageChannelType.EMAIL}'`,
      options: [
        {
          id: '20202020-1628-4bc0-aae1-1a46c648cf90',
          value: MessageChannelType.EMAIL,
          label: 'Email',
          position: 0,
          color: 'green',
        },
        {
          id: '20202020-fb11-4da3-80fd-b291cda8deb1',
          value: MessageChannelType.SMS,
          label: 'SMS',
          position: 1,
          color: 'blue',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  isContactAutoCreationEnabled: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'isContactAutoCreationEnabled',
      type: FieldMetadataType.BOOLEAN,
      label: 'Is Contact Auto Creation Enabled',
      description: 'Is Contact Auto Creation Enabled',
      icon: 'IconUserCircle',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  contactAutoCreationPolicy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'contactAutoCreationPolicy',
      type: FieldMetadataType.SELECT,
      label: 'Contact auto creation policy',
      description:
        'Automatically create People records when receiving or sending emails',
      icon: 'IconUserCircle',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'SENT'",
      options: [
        {
          id: '20202020-1923-4ffd-907d-be8cc37ecee5',
          value: 'SENT_AND_RECEIVED',
          label: 'Sent and Received',
          position: 0,
          color: 'green',
        },
        {
          id: '20202020-8f6a-44d8-bdbb-90cf8b919467',
          value: 'SENT',
          label: 'Sent',
          position: 1,
          color: 'blue',
        },
        {
          id: '20202020-b43e-4bc4-840e-d903a69e2ffc',
          value: 'NONE',
          label: 'None',
          position: 2,
          color: 'red',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  messageFolderImportPolicy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'messageFolderImportPolicy',
      type: FieldMetadataType.SELECT,
      label: 'Message folder import policy',
      description: 'Message folder import policy',
      icon: 'IconFolder',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'ALL_FOLDERS'",
      options: [
        {
          id: '20202020-140d-4326-978c-83ca0e9a4d8f',
          value: 'ALL_FOLDERS',
          label: 'All folders',
          position: 0,
          color: 'green',
        },
        {
          id: '20202020-513a-4b91-9033-5b74b404e2cb',
          value: 'SELECTED_FOLDERS',
          label: 'Selected folders',
          position: 1,
          color: 'blue',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  excludeNonProfessionalEmails: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'excludeNonProfessionalEmails',
      type: FieldMetadataType.BOOLEAN,
      label: 'Exclude non professional emails',
      description: 'Exclude non professional emails',
      icon: 'IconBriefcase',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  excludeGroupEmails: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'excludeGroupEmails',
      type: FieldMetadataType.BOOLEAN,
      label: 'Exclude group emails',
      description: 'Exclude group emails',
      icon: 'IconUsersGroup',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  pendingGroupEmailsAction: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'pendingGroupEmailsAction',
      type: FieldMetadataType.SELECT,
      label: 'Pending group emails action',
      description: 'Pending action for group emails',
      icon: 'IconUsersGroup',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'NONE'",
      options: [
        {
          id: '20202020-2ead-4bd1-aa5d-5005c7a956b4',
          value: 'GROUP_EMAILS_DELETION',
          label: 'Group emails deletion',
          position: 0,
          color: 'red',
        },
        {
          id: '20202020-155d-447d-a36e-6ecbb30fc37c',
          value: 'GROUP_EMAILS_IMPORT',
          label: 'Group emails import',
          position: 1,
          color: 'green',
        },
        {
          id: '20202020-fe98-4018-9f94-f878c22b8ece',
          value: 'NONE',
          label: 'None',
          position: 2,
          color: 'blue',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  isSyncEnabled: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'isSyncEnabled',
      type: FieldMetadataType.BOOLEAN,
      label: 'Is Sync Enabled',
      description: 'Is Sync Enabled',
      icon: 'IconRefresh',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncCursor: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncCursor',
      type: FieldMetadataType.TEXT,
      label: 'Last sync cursor',
      description: 'Last sync cursor',
      icon: 'IconHistory',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Last sync date',
      description: 'Last sync date',
      icon: 'IconHistory',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncStatus: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncStatus',
      type: FieldMetadataType.SELECT,
      label: 'Sync status',
      description: 'Sync status',
      icon: 'IconStatusChange',
      isNullable: true,
      isUIReadOnly: true,
      options: [
        {
          id: '20202020-046b-4bc2-b085-bd69aaa8e577',
          value: 'ONGOING',
          label: 'Ongoing',
          position: 1,
          color: 'yellow',
        },
        {
          id: '20202020-09ec-4ea6-9a8a-bf48211b67e2',
          value: 'NOT_SYNCED',
          label: 'Not Synced',
          position: 2,
          color: 'blue',
        },
        {
          id: '20202020-2d1b-4d74-9689-9bd28fd3c3f9',
          value: 'ACTIVE',
          label: 'Active',
          position: 3,
          color: 'green',
        },
        {
          id: '20202020-0fb2-4a8b-9f9b-569144a45193',
          value: 'FAILED_INSUFFICIENT_PERMISSIONS',
          label: 'Failed Insufficient Permissions',
          position: 4,
          color: 'red',
        },
        {
          id: '20202020-bde3-415a-a8ac-55ced6014364',
          value: 'FAILED_UNKNOWN',
          label: 'Failed Unknown',
          position: 5,
          color: 'red',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncStage: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncStage',
      type: FieldMetadataType.SELECT,
      label: 'Sync stage',
      description: 'Sync stage',
      icon: 'IconStatusChange',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'PENDING_CONFIGURATION'",
      options: [
        {
          id: '20202020-1f62-4d79-a633-33a0e4fce9a6',
          value: 'MESSAGE_LIST_FETCH_PENDING',
          label: 'Messages list fetch pending',
          position: 0,
          color: 'blue',
        },
        {
          id: '20202020-d24f-4c3d-94a6-86c42e0f51d7',
          value: 'MESSAGE_LIST_FETCH_SCHEDULED',
          label: 'Messages list fetch scheduled',
          position: 1,
          color: 'green',
        },
        {
          id: '20202020-8751-408a-ae46-21a51b76be28',
          value: 'MESSAGE_LIST_FETCH_ONGOING',
          label: 'Messages list fetch ongoing',
          position: 2,
          color: 'orange',
        },
        {
          id: '20202020-1cfa-4a7d-a82d-93c8e29d0671',
          value: 'MESSAGES_IMPORT_PENDING',
          label: 'Messages import pending',
          position: 3,
          color: 'blue',
        },
        {
          id: '20202020-341e-4fbd-9dbf-30a70828ca69',
          value: 'MESSAGES_IMPORT_SCHEDULED',
          label: 'Messages import scheduled',
          position: 4,
          color: 'green',
        },
        {
          id: '20202020-e944-4594-ab81-fdbc53a85026',
          value: 'MESSAGES_IMPORT_ONGOING',
          label: 'Messages import ongoing',
          position: 5,
          color: 'orange',
        },
        {
          id: '20202020-f7c5-4756-9084-02f6a0b1a5f8',
          value: 'FAILED',
          label: 'Failed',
          position: 6,
          color: 'red',
        },
        {
          id: '20202020-0ede-4c75-84f1-29c8309829ec',
          value: 'PENDING_CONFIGURATION',
          label: 'Pending configuration',
          position: 7,
          color: 'gray',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncStageStartedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncStageStartedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Sync stage started at',
      description: 'Sync stage started at',
      icon: 'IconHistory',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  throttleFailureCount: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'throttleFailureCount',
      type: FieldMetadataType.NUMBER,
      label: 'Throttle Failure Count',
      description: 'Throttle Failure Count',
      icon: 'IconX',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 0,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  throttleRetryAfter: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'throttleRetryAfter',
      type: FieldMetadataType.DATE_TIME,
      label: 'Throttle Retry After',
      description: 'Throttle Retry After',
      icon: 'IconClock',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  connectedAccount: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'connectedAccount',
      label: 'Connected Account',
      description: 'Connected Account',
      icon: 'IconUserCircle',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'connectedAccount',
      targetFieldName: 'messageChannels',
      settings: {
        relationType: RelationType.MANY_TO_ONE,
        onDelete: RelationOnDeleteAction.CASCADE,
        joinColumnName: 'connectedAccountId',
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  messageChannelMessageAssociations: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'messageChannelMessageAssociations',
      label: 'Message Channel Association',
      description: 'Messages from the channel.',
      icon: 'IconMessage',
      isNullable: true,
      isUIReadOnly: true,
      targetObjectName: 'messageChannelMessageAssociation',
      targetFieldName: 'messageChannel',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  messageFolders: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'messageFolders',
      label: 'Message Folders',
      description: 'Message Folders',
      icon: 'IconFolder',
      isNullable: true,
      isUIReadOnly: true,
      targetObjectName: 'messageFolder',
      targetFieldName: 'messageChannel',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
});
