import {
  DateDisplayFormat,
  FieldMetadataType,
  RelationOnDeleteAction,
  RelationType,
} from 'twenty-shared/types';

import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';
import { type AllStandardObjectFieldName } from 'src/engine/workspace-manager/twenty-standard-application/types/all-standard-object-field-name.type';
import {
  type CreateStandardFieldArgs,
  createStandardFieldFlatMetadata,
} from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-field-flat-metadata.util';
import { createStandardRelationFieldFlatMetadata } from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-relation-field-flat-metadata.util';
import { getTsVectorColumnExpressionFromFields } from 'src/engine/workspace-manager/utils/get-ts-vector-column-expression.util';
import { SEARCH_FIELDS_FOR_MESSAGE_CHANNEL_MESSAGE_ASSOCIATION_MESSAGE_FOLDER } from 'src/modules/messaging/common/standard-objects/message-channel-message-association-message-folder.workspace-entity';

export const buildMessageChannelMessageAssociationMessageFolderStandardFlatFieldMetadatas =
  ({
    now,
    objectName,
    workspaceId,
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
  }: Omit<
    CreateStandardFieldArgs<
      'messageChannelMessageAssociationMessageFolder',
      FieldMetadataType
    >,
    'context'
  >): Record<
    AllStandardObjectFieldName<'messageChannelMessageAssociationMessageFolder'>,
    FlatFieldMetadata
  > => ({
    id: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'id',
        type: FieldMetadataType.UUID,
        label: 'Id',
        description: 'Id',
        icon: 'Icon123',
        isSystem: true,
        isNullable: false,
        isUIReadOnly: true,
        defaultValue: 'uuid',
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    createdAt: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'createdAt',
        type: FieldMetadataType.DATE_TIME,
        label: 'Creation date',
        description: 'Creation date',
        icon: 'IconCalendar',
        isSystem: true,
        isNullable: false,
        isUIReadOnly: true,
        defaultValue: 'now',
        settings: { displayFormat: DateDisplayFormat.RELATIVE },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    updatedAt: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'updatedAt',
        type: FieldMetadataType.DATE_TIME,
        label: 'Last update',
        description: 'Last time the record was changed',
        icon: 'IconCalendarClock',
        isSystem: true,
        isNullable: false,
        isUIReadOnly: true,
        defaultValue: 'now',
        settings: { displayFormat: DateDisplayFormat.RELATIVE },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    deletedAt: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'deletedAt',
        type: FieldMetadataType.DATE_TIME,
        label: 'Deleted at',
        description: 'Date when the record was deleted',
        icon: 'IconCalendarMinus',
        isSystem: true,
        isNullable: true,
        isUIReadOnly: true,
        settings: { displayFormat: DateDisplayFormat.RELATIVE },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    createdBy: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'createdBy',
        type: FieldMetadataType.ACTOR,
        label: 'Created by',
        description: 'The creator of the record',
        icon: 'IconCreativeCommonsSa',
        isSystem: true,
        isUIReadOnly: true,
        isNullable: false,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    updatedBy: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'updatedBy',
        type: FieldMetadataType.ACTOR,
        label: 'Updated by',
        description: 'The workspace member who last updated the record',
        icon: 'IconUserCircle',
        isSystem: true,
        isUIReadOnly: true,
        isNullable: false,
        defaultValue: {
          source: "'MANUAL'",
          name: "'System'",
          workspaceMemberId: null,
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    position: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'position',
        type: FieldMetadataType.POSITION,
        label: 'Position',
        description:
          'Message channel message association message folder record position',
        icon: 'IconHierarchy2',
        isSystem: true,
        isNullable: false,
        defaultValue: 0,
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    searchVector: createStandardFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        fieldName: 'searchVector',
        type: FieldMetadataType.TS_VECTOR,
        label: 'Search vector',
        description: 'Field used for full-text search',
        icon: 'IconUser',
        isSystem: true,
        isNullable: true,
        settings: {
          generatedType: 'STORED',
          asExpression: getTsVectorColumnExpressionFromFields(
            SEARCH_FIELDS_FOR_MESSAGE_CHANNEL_MESSAGE_ASSOCIATION_MESSAGE_FOLDER,
          ),
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    messageChannelMessageAssociation: createStandardRelationFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        type: FieldMetadataType.RELATION,
        morphId: null,
        fieldName: 'messageChannelMessageAssociation',
        label: 'Message Channel Message Association',
        description: 'Message Channel Message Association',
        icon: 'IconMessage',
        isNullable: false,
        isUIReadOnly: true,
        targetObjectName: 'messageChannelMessageAssociation',
        targetFieldName: 'messageFolders',
        settings: {
          relationType: RelationType.MANY_TO_ONE,
          onDelete: RelationOnDeleteAction.CASCADE,
          joinColumnName: 'messageChannelMessageAssociationId',
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
    messageFolder: createStandardRelationFieldFlatMetadata({
      objectName,
      workspaceId,
      context: {
        type: FieldMetadataType.RELATION,
        morphId: null,
        fieldName: 'messageFolder',
        label: 'Message Folder',
        description: 'Message Folder',
        icon: 'IconFolder',
        isNullable: false,
        isUIReadOnly: true,
        targetObjectName: 'messageFolder',
        targetFieldName: 'messageChannelMessageAssociationMessageFolders',
        settings: {
          relationType: RelationType.MANY_TO_ONE,
          onDelete: RelationOnDeleteAction.CASCADE,
          joinColumnName: 'messageFolderId',
        },
      },
      standardObjectMetadataRelatedEntityIds,
      dependencyFlatEntityMaps,
      twentyStandardApplicationId,
      now,
    }),
  });
