import {
  DateDisplayFormat,
  FieldMetadataType,
  RelationOnDeleteAction,
  RelationType,
} from 'twenty-shared/types';

import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';
import { type AllStandardObjectFieldName } from 'src/engine/workspace-manager/twenty-standard-application/types/all-standard-object-field-name.type';
import {
  type CreateStandardFieldArgs,
  createStandardFieldFlatMetadata,
} from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-field-flat-metadata.util';
import { createStandardRelationFieldFlatMetadata } from 'src/engine/workspace-manager/twenty-standard-application/utils/field-metadata/create-standard-relation-field-flat-metadata.util';
import { getTsVectorColumnExpressionFromFields } from 'src/engine/workspace-manager/utils/get-ts-vector-column-expression.util';
import { SEARCH_FIELDS_FOR_CALENDAR_CHANNEL } from 'src/modules/calendar/common/standard-objects/calendar-channel.workspace-entity';

export const buildCalendarChannelStandardFlatFieldMetadatas = ({
  now,
  objectName,
  workspaceId,
  standardObjectMetadataRelatedEntityIds,
  dependencyFlatEntityMaps,
  twentyStandardApplicationId,
}: Omit<
  CreateStandardFieldArgs<'calendarChannel', FieldMetadataType>,
  'context'
>): Record<
  AllStandardObjectFieldName<'calendarChannel'>,
  FlatFieldMetadata
> => ({
  id: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'id',
      type: FieldMetadataType.UUID,
      label: 'Id',
      description: 'Id',
      icon: 'Icon123',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'uuid',
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  createdAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'createdAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Creation date',
      description: 'Creation date',
      icon: 'IconCalendar',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'now',
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  updatedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'updatedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Last update',
      description: 'Last time the record was changed',
      icon: 'IconCalendarClock',
      isSystem: true,
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 'now',
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  deletedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'deletedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Deleted at',
      description: 'Date when the record was deleted',
      icon: 'IconCalendarMinus',
      isSystem: true,
      isNullable: true,
      isUIReadOnly: true,
      settings: { displayFormat: DateDisplayFormat.RELATIVE },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  createdBy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'createdBy',
      type: FieldMetadataType.ACTOR,
      label: 'Created by',
      description: 'The creator of the record',
      icon: 'IconCreativeCommonsSa',
      isSystem: true,
      isUIReadOnly: true,
      isNullable: false,
      defaultValue: {
        source: "'MANUAL'",
        name: "'System'",
        workspaceMemberId: null,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  updatedBy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'updatedBy',
      type: FieldMetadataType.ACTOR,
      label: 'Updated by',
      description: 'The workspace member who last updated the record',
      icon: 'IconUserCircle',
      isSystem: true,
      isUIReadOnly: true,
      isNullable: false,
      defaultValue: {
        source: "'MANUAL'",
        name: "'System'",
        workspaceMemberId: null,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  position: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'position',
      type: FieldMetadataType.POSITION,
      label: 'Position',
      description: 'Calendar channel record position',
      icon: 'IconHierarchy2',
      isSystem: true,
      isNullable: false,
      defaultValue: 0,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  searchVector: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'searchVector',
      type: FieldMetadataType.TS_VECTOR,
      label: 'Search vector',
      description: 'Field used for full-text search',
      icon: 'IconUser',
      isSystem: true,
      isNullable: true,
      settings: {
        generatedType: 'STORED',
        asExpression: getTsVectorColumnExpressionFromFields(
          SEARCH_FIELDS_FOR_CALENDAR_CHANNEL,
        ),
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  handle: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'handle',
      type: FieldMetadataType.TEXT,
      label: 'Handle',
      description: 'Handle',
      icon: 'IconAt',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  visibility: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'visibility',
      type: FieldMetadataType.SELECT,
      label: 'Visibility',
      description: 'Visibility',
      icon: 'IconEyeglass',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'SHARE_EVERYTHING'",
      options: [
        {
          id: '20202020-82a0-4859-b356-f5a1d6e3e53d',
          value: 'METADATA',
          label: 'Metadata',
          position: 0,
          color: 'green',
        },
        {
          id: '20202020-e5ec-4df5-ba3f-66ca2a79c283',
          value: 'SHARE_EVERYTHING',
          label: 'Share Everything',
          position: 1,
          color: 'orange',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  isContactAutoCreationEnabled: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'isContactAutoCreationEnabled',
      type: FieldMetadataType.BOOLEAN,
      label: 'Is Contact Auto Creation Enabled',
      description: 'Is Contact Auto Creation Enabled',
      icon: 'IconUserCircle',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  contactAutoCreationPolicy: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'contactAutoCreationPolicy',
      type: FieldMetadataType.SELECT,
      label: 'Contact auto creation policy',
      description:
        'Automatically create records for people you participated with in an event.',
      icon: 'IconUserCircle',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'AS_PARTICIPANT_AND_ORGANIZER'",
      options: [
        {
          id: '20202020-47c1-4af1-a8a6-540edeafc55e',
          value: 'AS_PARTICIPANT_AND_ORGANIZER',
          label: 'As Participant and Organizer',
          color: 'green',
          position: 0,
        },
        {
          id: '20202020-b3cc-4248-b0d1-c8d45c2418b3',
          value: 'AS_PARTICIPANT',
          label: 'As Participant',
          color: 'orange',
          position: 1,
        },
        {
          id: '20202020-84ef-4061-9c22-db596e237ddc',
          value: 'AS_ORGANIZER',
          label: 'As Organizer',
          color: 'blue',
          position: 2,
        },
        {
          id: '20202020-f170-491f-9597-0e5817e46c17',
          value: 'NONE',
          label: 'None',
          color: 'red',
          position: 3,
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  isSyncEnabled: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'isSyncEnabled',
      type: FieldMetadataType.BOOLEAN,
      label: 'Is Sync Enabled',
      description: 'Is Sync Enabled',
      icon: 'IconRefresh',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncCursor: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncCursor',
      type: FieldMetadataType.TEXT,
      label: 'Sync Cursor',
      description:
        'Sync Cursor. Used for syncing events from the calendar provider',
      icon: 'IconReload',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncStatus: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncStatus',
      type: FieldMetadataType.SELECT,
      label: 'Sync status',
      description: 'Sync status',
      icon: 'IconStatusChange',
      isNullable: true,
      isUIReadOnly: true,
      options: [
        {
          id: '20202020-ebdc-4fc8-a5c1-4bc6a90fdc3c',
          value: 'ONGOING',
          label: 'Ongoing',
          position: 1,
          color: 'yellow',
        },
        {
          id: '20202020-7126-4c26-9940-f5807ed87266',
          value: 'NOT_SYNCED',
          label: 'Not Synced',
          position: 2,
          color: 'blue',
        },
        {
          id: '20202020-0302-4201-bf84-aaa26b7ca94e',
          value: 'ACTIVE',
          label: 'Active',
          position: 3,
          color: 'green',
        },
        {
          id: '20202020-6dbb-449d-96b0-092189010f42',
          value: 'FAILED_INSUFFICIENT_PERMISSIONS',
          label: 'Failed Insufficient Permissions',
          position: 4,
          color: 'red',
        },
        {
          id: '20202020-935c-4333-a614-f49ee2ec6aa7',
          value: 'FAILED_UNKNOWN',
          label: 'Failed Unknown',
          position: 5,
          color: 'red',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncStage: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncStage',
      type: FieldMetadataType.SELECT,
      label: 'Sync stage',
      description: 'Sync stage',
      icon: 'IconStatusChange',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: "'PENDING_CONFIGURATION'",
      options: [
        {
          id: '20202020-60c1-40a3-90ae-61d9ee1083c1',
          value: 'CALENDAR_EVENT_LIST_FETCH_PENDING',
          label: 'Calendar event list fetch pending',
          position: 0,
          color: 'blue',
        },
        {
          id: '20202020-8652-444a-b72e-d4b7112179ca',
          value: 'CALENDAR_EVENT_LIST_FETCH_SCHEDULED',
          label: 'Calendar event list fetch scheduled',
          position: 1,
          color: 'green',
        },
        {
          id: '20202020-e87c-4cfe-aefc-635ad34ef223',
          value: 'CALENDAR_EVENT_LIST_FETCH_ONGOING',
          label: 'Calendar event list fetch ongoing',
          position: 2,
          color: 'orange',
        },
        {
          id: '20202020-876f-449d-9f09-de5c369ff95f',
          value: 'CALENDAR_EVENTS_IMPORT_PENDING',
          label: 'Calendar events import pending',
          position: 3,
          color: 'blue',
        },
        {
          id: '20202020-3d2a-4acd-a0ed-197343b3bf60',
          value: 'CALENDAR_EVENTS_IMPORT_SCHEDULED',
          label: 'Calendar events import scheduled',
          position: 4,
          color: 'green',
        },
        {
          id: '20202020-e762-4152-bb20-29fdd49e1dff',
          value: 'CALENDAR_EVENTS_IMPORT_ONGOING',
          label: 'Calendar events import ongoing',
          position: 5,
          color: 'orange',
        },
        {
          id: '20202020-487c-464f-8caa-c6393b82b17c',
          value: 'FAILED',
          label: 'Failed',
          position: 6,
          color: 'red',
        },
        {
          id: '20202020-ba03-4221-b186-402662b68493',
          value: 'PENDING_CONFIGURATION',
          label: 'Pending configuration',
          position: 9,
          color: 'gray',
        },
      ],
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncStageStartedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncStageStartedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Sync stage started at',
      description: 'Sync stage started at',
      icon: 'IconHistory',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  syncedAt: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'syncedAt',
      type: FieldMetadataType.DATE_TIME,
      label: 'Last sync date',
      description: 'Last sync date',
      icon: 'IconHistory',
      isNullable: true,
      isUIReadOnly: true,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  throttleFailureCount: createStandardFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      fieldName: 'throttleFailureCount',
      type: FieldMetadataType.NUMBER,
      label: 'Throttle Failure Count',
      description: 'Throttle Failure Count',
      icon: 'IconX',
      isNullable: false,
      isUIReadOnly: true,
      defaultValue: 0,
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  connectedAccount: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'connectedAccount',
      label: 'Connected Account',
      description: 'Connected Account',
      icon: 'IconUserCircle',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'connectedAccount',
      targetFieldName: 'calendarChannels',
      settings: {
        relationType: RelationType.MANY_TO_ONE,
        onDelete: RelationOnDeleteAction.CASCADE,
        joinColumnName: 'connectedAccountId',
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
  calendarChannelEventAssociations: createStandardRelationFieldFlatMetadata({
    objectName,
    workspaceId,
    context: {
      type: FieldMetadataType.RELATION,
      morphId: null,
      fieldName: 'calendarChannelEventAssociations',
      label: 'Calendar Channel Event Associations',
      description: 'Calendar Channel Event Associations',
      icon: 'IconCalendar',
      isNullable: false,
      isUIReadOnly: true,
      targetObjectName: 'calendarChannelEventAssociation',
      targetFieldName: 'calendarChannel',
      settings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    standardObjectMetadataRelatedEntityIds,
    dependencyFlatEntityMaps,
    twentyStandardApplicationId,
    now,
  }),
});
