import { WORKSPACE_MEMBER_DATA_SEED_IDS } from 'src/engine/workspace-manager/dev-seeder/data/constants/workspace-member-data-seeds.constant';

type CompanyDataSeed = {
  id: string;
  name: string;
  domainNamePrimaryLinkUrl: string;
  addressAddressCity: string;
  employees: number;
  linkedinLinkPrimaryLinkUrl: string;
  createdBySource: string;
  createdByWorkspaceMemberId: string;
  createdByName: string;
  accountOwnerId: string;
  updatedBySource: string;
  updatedByWorkspaceMemberId: string;
  updatedByName: string;
  position: number;
};

export const COMPANY_DATA_SEED_COLUMNS: (keyof CompanyDataSeed)[] = [
  'id',
  'name',
  'domainNamePrimaryLinkUrl',
  'addressAddressCity',
  'employees',
  'linkedinLinkPrimaryLinkUrl',
  'createdBySource',
  'createdByWorkspaceMemberId',
  'createdByName',
  'accountOwnerId',
  'updatedBySource',
  'updatedByWorkspaceMemberId',
  'updatedByName',
  'position',
];

// prettier-ignore
export const COMPANY_DATA_SEED_IDS = {
  ID_1: '20202020-a305-41e7-8c72-ba44072a4c58',
  ID_2: '20202020-a225-4b3d-a89c-7f6c30df998a',
  ID_3: '20202020-a8b0-422c-8fcf-5b7496f94975',
  ID_4: '20202020-aaf7-41d6-87a9-7add07bebfd8',
  ID_5: '20202020-a19d-422b-9cb2-5f8382a56877',
  ID_6: '20202020-a39c-4644-867d-e8e1851b3ee8',
  ID_7: '20202020-a0eb-4c51-aa03-c4cd2423d7cb',
  ID_8: '20202020-a9b5-48ec-97c0-dbbfcbe8df1b',
  ID_9: '20202020-a89d-44f9-ac9c-25e462460cb0',
  ID_10: '20202020-a377-4693-a2d9-89dc9188a1dc',
  ID_11: '20202020-a1d7-4279-a41a-7530ade05b5b',
  ID_12: '20202020-abaa-428e-a496-0fe54b32e7c6',
  ID_13: '20202020-ad85-4b32-b670-b4b020ed0e09',
  ID_14: '20202020-a7c6-41d1-924e-1b65b9d3b99e',
  ID_15: '20202020-a14e-446f-aa5e-59afbcdffb16',
  ID_16: '20202020-aba6-4097-ae47-053aa8fbb7e7',
  ID_17: '20202020-a076-43ec-a8ac-485420bd2ccf',
  ID_18: '20202020-aec4-4416-b087-f5a61c3a0315',
  ID_19: '20202020-a120-4ad9-8bf3-58f8691e66ce',
  ID_20: '20202020-af43-44c6-877e-5ad51fe74ff0',
  ID_21: '20202020-aab2-4e2f-8372-cc2613fb3db8',
  ID_22: '20202020-a3e8-41d6-8b48-b4e6c7bae742',
  ID_23: '20202020-a828-4ae2-b694-3c453632b147',
  ID_24: '20202020-ac47-4745-bec5-cbe19672fe13',
  ID_25: '20202020-a42f-4bc0-97ee-73e9b810322f',
  ID_26: '20202020-aa45-4913-878e-d7ebf66ee13e',
  ID_27: '20202020-a997-466d-8e1b-1de0d45611e8',
  ID_28: '20202020-aa8e-4283-ba38-faf499869cb7',
  ID_29: '20202020-a378-47b4-ae93-bf979a769ab8',
  ID_30: '20202020-a5be-4382-afbe-1b2e3f0ed166',
  ID_31: '20202020-ae71-46fe-ad2c-f25001d4c800',
  ID_32: '20202020-addd-413f-a90c-5eed6658975c',
  ID_33: '20202020-a286-45a2-a048-8a6a69fdcfe7',
  ID_34: '20202020-a6d3-42bc-ac1e-b0c9c1e032db',
  ID_35: '20202020-a026-43c0-b042-0123f72f6cf9',
  ID_36: '20202020-ab8b-4dbf-81b5-1c18941b6457',
  ID_37: '20202020-a9cb-4047-895e-045524c8c3be',
  ID_38: '20202020-a958-4f51-9d1e-d3799bf8bf94',
  ID_39: '20202020-ae04-4eae-95bb-dae396d779d8',
  ID_40: '20202020-a6f9-42e4-9891-3dbd8bd35079',
  ID_41: '20202020-a729-4cba-861d-6582f1bb5985',
  ID_42: '20202020-ac61-4374-a911-cbb469541429',
  ID_43: '20202020-ae0e-4528-bdca-c43796611200',
  ID_44: '20202020-a480-4f79-be9e-e6ca396a3ddc',
  ID_45: '20202020-aac2-4504-9a18-f50157ece5fb',
  ID_46: '20202020-a38b-447c-b98d-b21ecc37ae48',
  ID_47: '20202020-abce-4259-9808-5bd830a32e23',
  ID_48: '20202020-aedb-41d6-91cc-763d21e740b7',
  ID_49: '20202020-a5d1-459c-97fa-dd4f8e3cadc0',
  ID_50: '20202020-a412-4896-9413-ffc4d443367f',
  ID_51: '20202020-af5c-4e39-90e2-d80e82a0dc4b',
  ID_52: '20202020-aef1-4ca1-b636-aa3d104c9ead',
  ID_53: '20202020-a84a-4ce1-8785-2881210db380',
  ID_54: '20202020-ace2-45fb-a109-3b59d1fdb1c3',
  ID_55: '20202020-af6e-420d-a798-145a9c10f049',
  ID_56: '20202020-a0f8-4f7a-a510-8e7c7de219ec',
  ID_57: '20202020-ac1f-49e8-886f-f81ac9ef2b17',
  ID_58: '20202020-aa07-4364-8e0d-155f0bfbb054',
  ID_59: '20202020-a659-4a9e-a307-110daf1ee522',
  ID_60: '20202020-a1f5-49c6-8838-47b1ff5de851',
  ID_61: '20202020-a11e-43a0-8dc1-72225d6ac3a0',
  ID_62: '20202020-a2d1-48af-88ba-43c62cb1975e',
  ID_63: '20202020-ac73-4cd0-950f-5ef82ce58002',
  ID_64: '20202020-ae08-4da3-b436-1d2560108def',
  ID_65: '20202020-a6cd-44fe-a510-fdbab6364297',
  ID_66: '20202020-a5a1-41de-987f-6a8ff51b0f5b',
  ID_67: '20202020-ac06-4fce-bd59-920549a97c23',
  ID_68: '20202020-a307-4430-aa81-a9cc6e1f2b10',
  ID_69: '20202020-afea-4a51-81be-d46de6a93db7',
  ID_70: '20202020-afa7-4546-a865-18a9cd06de4c',
  ID_71: '20202020-a219-4d0a-ae4b-b4f6fb1b4744',
  ID_72: '20202020-a7a0-4d36-8914-735396c68fa5',
  ID_73: '20202020-ab53-47eb-8dcd-afe5f7e317f2',
  ID_74: '20202020-af43-4ca5-9b56-59fe182568b1',
  ID_75: '20202020-abbf-40c8-9fac-a40e245d5c87',
  ID_76: '20202020-a974-4813-b37b-fb58adc77511',
  ID_77: '20202020-ae31-44d8-b98c-b516c495fee0',
  ID_78: '20202020-a745-4f26-b5df-42ed9eb0323a',
  ID_79: '20202020-ac78-4211-b67a-3e83eb3c556f',
  ID_80: '20202020-a9e3-4cd1-aafb-664e9290f795',
  ID_81: '20202020-ade7-4068-98ac-64b580d2d5ca',
  ID_82: '20202020-ac69-4ec9-9b44-b8baf5d45ca9',
  ID_83: '20202020-af10-41df-bd84-680a0c8ec306',
  ID_84: '20202020-a9f8-49f0-ba51-e6b3fcdf0469',
  ID_85: '20202020-a9d7-4704-9f92-e6cd168d5cd3',
  ID_86: '20202020-a24f-4519-9764-0b57479deb2c',
  ID_87: '20202020-a4f8-498e-9797-66183ba2b1d4',
  ID_88: '20202020-ac6b-4e3f-8118-d6474770825e',
  ID_89: '20202020-a586-4603-8fc0-04c85dc2053f',
  ID_90: '20202020-abec-4544-b5f5-b7b6c91ca36e',
  ID_91: '20202020-ac51-4f97-bafb-e7f2ec84717e',
  ID_92: '20202020-a075-44a9-910e-3a6841c7b534',
  ID_93: '20202020-abe4-4946-988b-baca9f6b7e8b',
  ID_94: '20202020-a4ac-4527-96fe-a86a3f1b04fe',
  ID_95: '20202020-a382-44b5-917a-afe0505b0ea3',
  ID_96: '20202020-a8b7-40cb-ba39-f34496257262',
  ID_97: '20202020-a831-4e05-8b70-c8d0cd297c29',
  ID_98: '20202020-addf-422a-b9d4-89d0999061d7',
  ID_99: '20202020-a6ef-4ed9-8626-a1390f3ebda9',
  ID_100: '20202020-a7f0-44a0-aa04-bc0a00bf56a5',
  ID_101: '20202020-a95a-4cf9-99ab-795a0dcec88f',
  ID_102: '20202020-a026-47d2-9474-75fb625f5eb1',
  ID_103: '20202020-a1cc-4c9f-91b1-68e1f2efc160',
  ID_104: '20202020-aff4-4f9c-8be7-7cb37d86fe76',
  ID_105: '20202020-a2a0-4356-9f2f-64cf988b533d',
  ID_106: '20202020-ac1a-47ff-b681-f8abe99cfeb9',
  ID_107: '20202020-ad2c-4a39-a7fd-db5e64b1e2ca',
  ID_108: '20202020-aa42-4081-8976-1d7fead0fdcd',
  ID_109: '20202020-a2fe-4a8b-a827-3f832b9823f1',
  ID_110: '20202020-a3d7-4d6a-ba0e-6ffa4d25af9b',
  ID_111: '20202020-a048-4007-9024-3ac47b8484d5',
  ID_112: '20202020-ae4b-4b3f-826b-2d91511a0631',
  ID_113: '20202020-ae1f-49f9-954a-4d75c2ad15fb',
  ID_114: '20202020-a597-4f35-9600-d5ba68ee5325',
  ID_115: '20202020-aed9-480b-9367-ebb2c95cb3d7',
  ID_116: '20202020-a73f-4892-83e6-1bb6e4c66993',
  ID_117: '20202020-ab1f-4628-8ef8-847e9f2afef0',
  ID_118: '20202020-a25a-44ed-a64d-938d79442d24',
  ID_119: '20202020-a8b7-4998-a786-e5a302470efd',
  ID_120: '20202020-af1f-4531-b89d-14773319ae2d',
  ID_121: '20202020-ad82-4264-a88e-5fd9491c39e1',
  ID_122: '20202020-ad73-49fa-922a-350753580e34',
  ID_123: '20202020-a190-4324-8f31-044517a04b1a',
  ID_124: '20202020-a63f-4e00-a49e-c202a2323efb',
  ID_125: '20202020-a2b3-4c99-8313-d3dbd2151825',
  ID_126: '20202020-a4f3-4e8e-8667-f36775649a10',
  ID_127: '20202020-afc1-4458-8627-d48bf9e55828',
  ID_128: '20202020-aeb0-46e7-973c-0f0a7e187250',
  ID_129: '20202020-a896-4b36-8e12-41e881df9afe',
  ID_130: '20202020-aa8f-40af-897b-9e8e4faab278',
  ID_131: '20202020-ade4-4f96-9355-3ce52596cb9c',
  ID_132: '20202020-aead-48ee-be7c-c33f674f3985',
  ID_133: '20202020-afda-4d53-8aa8-c02ececbf3c3',
  ID_134: '20202020-a825-4ba6-9c84-6f78f8676b33',
  ID_135: '20202020-a200-450c-b9ed-05d147ae4132',
  ID_136: '20202020-a5e7-4d64-aecb-2228f69475bf',
  ID_137: '20202020-a8a1-4ca1-ab39-d07c9b5b0cf4',
  ID_138: '20202020-a801-4d4d-b0fa-eb6ffe5936fe',
  ID_139: '20202020-ad39-402d-9c61-b54b009d308e',
  ID_140: '20202020-ad11-49f7-95ed-78038ef37aec',
  ID_141: '20202020-ae68-47df-ae3c-8b7b7db28e3e',
  ID_142: '20202020-a77f-4d9b-ae33-f85441e6caff',
  ID_143: '20202020-ac8a-43cf-8fc6-90cd0e55d5ca',
  ID_144: '20202020-a994-4bcb-bea6-8075b15b5685',
  ID_145: '20202020-a487-4991-95b3-b82c40e99e48',
  ID_146: '20202020-acab-4d19-85ce-98acd979853a',
  ID_147: '20202020-a397-4de8-9767-e1445338c9e5',
  ID_148: '20202020-ad82-4004-8d30-53c41530e9e7',
  ID_149: '20202020-a85d-40a0-b5cf-6419881fb4ff',
  ID_150: '20202020-a700-46d8-97fa-5093cf00b8f4',
  ID_151: '20202020-a4fc-4d71-810a-e4083f89e8ca',
  ID_152: '20202020-abdd-4a7e-a556-09e8a833c9e4',
  ID_153: '20202020-a73e-458d-8fd0-7e433d9f9adb',
  ID_154: '20202020-a63f-49b5-b285-a4bddde93c1a',
  ID_155: '20202020-a95a-4bbd-a83b-a2db3bd5753f',
  ID_156: '20202020-ab71-4b60-a0b4-2cee6d899ea1',
  ID_157: '20202020-a862-401c-a0f1-6c004c7941ea',
  ID_158: '20202020-adbc-4e0f-bce4-88ea58aa1808',
  ID_159: '20202020-a0d4-43cd-8047-3fe6abdf2636',
  ID_160: '20202020-ad8a-4b82-954c-b92e1d9c9bc9',
  ID_161: '20202020-ac2c-4d7c-b352-508a7c7f61ba',
  ID_162: '20202020-a82e-42a2-90e3-ad14d68aebc5',
  ID_163: '20202020-a4a4-4e67-9d18-6710a920a9d5',
  ID_164: '20202020-afc1-4a3c-bb84-d282b1f4814e',
  ID_165: '20202020-ad6b-4dae-85b3-b1813e009b4d',
  ID_166: '20202020-a18b-4ea6-8d0b-20aafc1e5ea0',
  ID_167: '20202020-abcd-4dc8-8340-57a5dc8a0bb7',
  ID_168: '20202020-aef8-4f36-a63d-fbec4d72bb82',
  ID_169: '20202020-ad66-4a74-9948-9d9b3deb43f8',
  ID_170: '20202020-a356-48a3-9de5-5fef8265787f',
  ID_171: '20202020-acdc-468f-9738-7fd8f0da5db6',
  ID_172: '20202020-ad80-4ad9-a402-1a22882f92ff',
  ID_173: '20202020-ab77-40a6-b62d-83f021a6d121',
  ID_174: '20202020-a186-44a8-88da-f1ea7b6998a0',
  ID_175: '20202020-aeb1-435d-af27-042ac5a15fb0',
  ID_176: '20202020-a8c1-4991-b2fc-96e56ebc65af',
  ID_177: '20202020-afaf-4b8d-84e7-bc708022d419',
  ID_178: '20202020-a3e9-4ec6-914c-5faba30cfa14',
  ID_179: '20202020-aeb2-496e-a31b-00010c54395d',
  ID_180: '20202020-a84f-4da5-80f6-eabb31ba0cdf',
  ID_181: '20202020-a64b-4511-bca8-83c64bf5d358',
  ID_182: '20202020-ac49-4ad4-864d-142d6cbbef2a',
  ID_183: '20202020-a067-457a-a39f-3bc4e052184e',
  ID_184: '20202020-a0f5-478d-8205-5c6961a57d2c',
  ID_185: '20202020-a59b-475c-92d5-e0bacca3aca0',
  ID_186: '20202020-a9f6-4c90-9673-327db70dd23f',
  ID_187: '20202020-a4b1-4d0e-b726-352a397bfbe7',
  ID_188: '20202020-ad74-44b7-a907-afdc8c7f5eae',
  ID_189: '20202020-a605-4fa7-8a2a-61253809900b',
  ID_190: '20202020-a4e5-41d7-8b81-f7b69e402f94',
  ID_191: '20202020-a3c0-4aee-b4d9-04e23321452a',
  ID_192: '20202020-a52e-483c-89b0-74fecffeed18',
  ID_193: '20202020-a192-4f09-b64a-c0d73cf2c986',
  ID_194: '20202020-a144-4bbb-b9f3-ff69315c4be4',
  ID_195: '20202020-aed9-4719-8750-7208603a0525',
  ID_196: '20202020-abb3-43a2-a436-2196b4636518',
  ID_197: '20202020-afdb-4d03-8571-34222063f9f4',
  ID_198: '20202020-ad09-40e1-ad7d-12addfaa2875',
  ID_199: '20202020-aa85-4c52-85a2-1a4dec92cd2a',
  ID_200: '20202020-a37e-4cbe-8218-e1f56c051913',
  ID_201: '20202020-adaf-4e9d-89be-72c6a349745a',
  ID_202: '20202020-a54d-4788-ad29-87923e682305',
  ID_203: '20202020-a397-497b-90bc-f62c1c34b2a3',
  ID_204: '20202020-aeb3-40b1-8f18-de25a7fd1146',
  ID_205: '20202020-a8ce-4a77-b76d-47d9b986582d',
  ID_206: '20202020-acaf-44c5-852a-dc64a5948b11',
  ID_207: '20202020-a48b-438a-83cf-14723cad1a7a',
  ID_208: '20202020-a425-4113-b509-425ffaaf9778',
  ID_209: '20202020-aa16-4b13-a84b-b8e076c1c880',
  ID_210: '20202020-a0c0-4a3e-9da8-766157ea9c0b',
  ID_211: '20202020-a8ab-41fd-a1dc-ae6c974e183f',
  ID_212: '20202020-aa9f-436a-b275-1063392919e1',
  ID_213: '20202020-a9c5-4d2c-8a54-12f9ef829cea',
  ID_214: '20202020-a837-46e1-abc6-1abca9d2fbaa',
  ID_215: '20202020-a88f-455d-b287-540ac087f356',
  ID_216: '20202020-a314-4f96-90c9-63274bf59a58',
  ID_217: '20202020-a67f-413d-82da-ec4d766cb296',
  ID_218: '20202020-a1c2-4cea-a678-9bd4897effaa',
  ID_219: '20202020-adef-416a-a0cd-bc60d75f0708',
  ID_220: '20202020-a8c7-4b4d-848f-8475ff6d5466',
  ID_221: '20202020-aa0b-48a9-85ba-e223975696ea',
  ID_222: '20202020-a3e6-4514-88e8-7394fa3017cc',
  ID_223: '20202020-a6f2-4621-9e2e-a01da10b427f',
  ID_224: '20202020-a433-4023-b8cb-0e93f57adc7c',
  ID_225: '20202020-aaae-4eb7-b9a7-83dcad70c5db',
  ID_226: '20202020-afa0-4371-af3e-6858b75a19d0',
  ID_227: '20202020-a466-443e-8131-510fb1ec9c42',
  ID_228: '20202020-a514-4f6a-8f7a-8567a6703d24',
  ID_229: '20202020-ae5a-4779-a032-3aa97ddf6b71',
  ID_230: '20202020-a93b-4070-8960-ce11fc1928dc',
  ID_231: '20202020-a053-4383-9712-e4e91860dc04',
  ID_232: '20202020-a720-4f63-9099-68c809606382',
  ID_233: '20202020-a0bc-4767-b22e-073c77abffa5',
  ID_234: '20202020-ab74-4494-a7d7-27c6c05b98d1',
  ID_235: '20202020-a561-4416-a7a1-390f3deea8cf',
  ID_236: '20202020-ae20-49f3-b9d6-20f01b79ba00',
  ID_237: '20202020-a8ae-42dd-84a0-b893c1a0d89c',
  ID_238: '20202020-a67c-426c-9433-272a5037e156',
  ID_239: '20202020-abb1-413c-834e-a19f496306e5',
  ID_240: '20202020-aae9-45cd-b8fa-90f5a88512e9',
  ID_241: '20202020-a11c-414a-9a42-9970c577524f',
  ID_242: '20202020-a824-47ce-90a9-8cfb80020d2b',
  ID_243: '20202020-a144-4788-b18f-872c1d810aeb',
  ID_244: '20202020-ab7b-4a44-bc10-b12059d6812c',
  ID_245: '20202020-a312-4f56-98f3-a32993a4d2d2',
  ID_246: '20202020-a2cb-421a-b222-24c0c4fd9d82',
  ID_247: '20202020-ad42-4b8f-a300-c78295c5b788',
  ID_248: '20202020-ace2-409c-bbe6-c03b985c6db8',
  ID_249: '20202020-afa7-4396-baef-a121a793be3b',
  ID_250: '20202020-af68-4163-a87f-a66a6aad32b5',
  ID_251: '20202020-af69-4333-a0e7-95a349ff4ef8',
  ID_252: '20202020-a992-47fb-abee-40b27b307001',
  ID_253: '20202020-afd3-485c-948f-cee696f0c83e',
  ID_254: '20202020-a89c-4037-9749-7f7816cdf060',
  ID_255: '20202020-aa19-47dd-a8a8-84b9b5a10c0d',
  ID_256: '20202020-a97a-4a8f-97af-abddded8ddad',
  ID_257: '20202020-af49-4994-98e0-7b9bc9062ea7',
  ID_258: '20202020-af2b-421c-8eff-e2a2a58716cf',
  ID_259: '20202020-a456-44cb-9ef5-98a64d8e1e1c',
  ID_260: '20202020-aa80-4cdf-8a7c-856f1f3a46f0',
  ID_261: '20202020-aa9e-414e-84a9-dd641fdd23e2',
  ID_262: '20202020-a18b-4f50-9e04-809f83b14a98',
  ID_263: '20202020-a46b-4943-a860-a8f5dfe1f757',
  ID_264: '20202020-a993-45f0-8913-64b61ae0b6ae',
  ID_265: '20202020-a581-4518-80e9-17ea7adf84c3',
  ID_266: '20202020-a0d8-4d8b-bb29-42df3c1b9da3',
  ID_267: '20202020-a05e-4df7-8b6e-6e9395b374fa',
  ID_268: '20202020-ac2d-48ea-b519-c00bee80057d',
  ID_269: '20202020-ab8b-4b04-b31e-021167a2c2b9',
  ID_270: '20202020-ade8-4b55-a4ea-3cb5b7914382',
  ID_271: '20202020-a47d-466b-9ea0-73fb7512ea02',
  ID_272: '20202020-ad0b-4a79-9704-e463f921fd47',
  ID_273: '20202020-ab7d-4c61-a432-8f9f10667ef7',
  ID_274: '20202020-a1ba-40be-abfd-8d0c2a751a72',
  ID_275: '20202020-a35c-48ab-aa83-9067f438d3d3',
  ID_276: '20202020-a9bc-4ff9-a890-6758e48c5d23',
  ID_277: '20202020-a604-4cb1-b408-47cab902e127',
  ID_278: '20202020-abad-4d2b-bd60-2ba981b29a04',
  ID_279: '20202020-afd7-49f1-8fb7-679210414fe3',
  ID_280: '20202020-a018-492d-89de-f9cd4ee80437',
  ID_281: '20202020-ab87-465a-ba45-3694ba97a142',
  ID_282: '20202020-ae09-40cd-ac82-cb5d7ff17796',
  ID_283: '20202020-a965-4a09-8f73-c23984772f81',
  ID_284: '20202020-ad8c-49d0-aa3e-191fcaa69f18',
  ID_285: '20202020-ace5-416d-a696-96a2ea40ec33',
  ID_286: '20202020-a263-49f3-82c9-f642ea86f3ff',
  ID_287: '20202020-afef-421c-873e-276efc937ce4',
  ID_288: '20202020-a1fa-4ccc-a0e7-307aba7afa7e',
  ID_289: '20202020-add4-47bd-ba9f-7ac35d0013c3',
  ID_290: '20202020-aaf3-41f4-bed4-3f8a816508a0',
  ID_291: '20202020-a068-47fa-b99f-dc814bc035a2',
  ID_292: '20202020-ac80-4246-a1f0-e130b00faedb',
  ID_293: '20202020-a2ac-4889-8e9e-186582699190',
  ID_294: '20202020-a23f-4ea3-b692-076ebe7ddf6e',
  ID_295: '20202020-aa7c-45db-9d28-e9cdc97e1b77',
  ID_296: '20202020-aae9-4f28-8e46-2dec2461595a',
  ID_297: '20202020-a8d9-492f-982b-58df2d3144ed',
  ID_298: '20202020-a39f-49ae-b797-efd21321492a',
  ID_299: '20202020-a80d-47c6-9266-8e89d89e150f',
  ID_300: '20202020-aade-4b73-9a59-af974f40c4d4',
  ID_301: '20202020-aa2f-44a2-b657-c5c01e7351a2',
  ID_302: '20202020-a37d-4877-8711-d69cc729ae89',
  ID_303: '20202020-abda-4364-b276-71c24d741f2f',
  ID_304: '20202020-ad5e-48af-b55d-e3f5338abfb3',
  ID_305: '20202020-a3e3-4544-b6e5-8940953018e3',
  ID_306: '20202020-a0db-423a-b5ed-38166d53a7f9',
  ID_307: '20202020-a2a2-4782-b757-f2e1c30d6c03',
  ID_308: '20202020-af6c-4815-9e1e-9bc061822bbb',
  ID_309: '20202020-adcf-4466-8baa-21eb41f2a1c8',
  ID_310: '20202020-aefb-49f9-b3e0-8d2bd59432d3',
  ID_311: '20202020-a048-4b80-bd7e-935d937842a4',
  ID_312: '20202020-a48e-4b9a-9fdf-dfe5d7674283',
  ID_313: '20202020-a6fa-42aa-a1b0-f24f339a08b0',
  ID_314: '20202020-ad56-4879-99cf-51ae83bed363',
  ID_315: '20202020-a045-4266-b9e4-0e7a0697322b',
  ID_316: '20202020-ad70-445b-b168-0fe285e232f3',
  ID_317: '20202020-ad67-49a8-9774-b118a4d8fd21',
  ID_318: '20202020-a3b5-4bfe-a9d5-1bcd2ec99f5a',
  ID_319: '20202020-a346-487e-85d2-085b834ba123',
  ID_320: '20202020-a5f8-479b-8282-c4614fd7f0f0',
  ID_321: '20202020-a604-4f4a-a2cb-26205babdd7b',
  ID_322: '20202020-a494-4962-8073-8f0221a314af',
  ID_323: '20202020-a36a-4d57-a99c-b5e980a74e67',
  ID_324: '20202020-a314-4ce6-a33b-833bcad71bc5',
  ID_325: '20202020-a18b-4f40-8a81-136308dde18e',
  ID_326: '20202020-a0a3-4656-8979-eedf17d3b723',
  ID_327: '20202020-a8a9-4729-a732-7e72e7df4885',
  ID_328: '20202020-a5a9-470c-aa08-c49439c77459',
  ID_329: '20202020-a054-4643-b7f7-a921d25c1d32',
  ID_330: '20202020-a2ad-43bd-a0da-dbd8c792226d',
  ID_331: '20202020-ac04-4d3f-b13d-69686927f97c',
  ID_332: '20202020-afc6-46ca-b95f-f036c5816df7',
  ID_333: '20202020-a3e3-44ad-b7c7-91c1208bc36e',
  ID_334: '20202020-a3fd-41bd-9e3c-0a56337aa474',
  ID_335: '20202020-afdc-4d1f-bd1c-e20a00dbab08',
  ID_336: '20202020-aaa1-4447-8cd1-86ccc8fb2ed2',
  ID_337: '20202020-abdd-48e9-bb2e-5b15d9a00be6',
  ID_338: '20202020-acbb-41c0-9692-1c8c5a278b74',
  ID_339: '20202020-a607-453c-840b-ec1dd6878299',
  ID_340: '20202020-ae5e-4083-8cb7-7d8b85422d2b',
  ID_341: '20202020-a87c-464e-bf96-5b80c22f2a9f',
  ID_342: '20202020-a952-47d6-b76e-4af362c179a1',
  ID_343: '20202020-aa10-4772-84d3-1faa7522dc5e',
  ID_344: '20202020-a75f-46e7-83d6-da52c24661cf',
  ID_345: '20202020-a072-49f1-8c7b-57867b64ea95',
  ID_346: '20202020-a443-43ca-accf-b64d7fb1cbd4',
  ID_347: '20202020-aba3-43eb-ae64-ca23e5d8aef9',
  ID_348: '20202020-a5d6-4414-a24a-effcc5a126b9',
  ID_349: '20202020-ab4b-4c28-9c46-a7a8c93af72d',
  ID_350: '20202020-a963-4acf-be69-4dcd040872d2',
  ID_351: '20202020-aed1-4f20-9e22-43ec4ac60a1f',
  ID_352: '20202020-a244-4372-9062-fe38c3f463ea',
  ID_353: '20202020-a76d-4540-b458-85be1997b9fc',
  ID_354: '20202020-a214-4148-966c-ee34a2e0c09a',
  ID_355: '20202020-a0e0-48bd-a907-9b9f147852f8',
  ID_356: '20202020-afca-44b5-9c13-c8245c3a65df',
  ID_357: '20202020-a46a-46c4-a06e-b53bd19a3120',
  ID_358: '20202020-aaf4-427a-b9d0-7274634d6426',
  ID_359: '20202020-a122-47e7-8ee9-f71430f2413f',
  ID_360: '20202020-a373-4a35-996c-e9aee6a35437',
  ID_361: '20202020-a9ca-4653-86fb-ba1fbc2e2292',
  ID_362: '20202020-a7a9-4a32-ab6a-910039586743',
  ID_363: '20202020-a53f-4873-ace7-fbf4a42fd956',
  ID_364: '20202020-a3e6-44a2-ba1a-a9b6a45a529e',
  ID_365: '20202020-a44a-4130-85bc-0899e43642c5',
  ID_366: '20202020-a147-42d8-9895-7432ff7e22f2',
  ID_367: '20202020-a859-4275-b748-98dbb3a32ba8',
  ID_368: '20202020-a22c-467b-a8cf-50df1c440fe6',
  ID_369: '20202020-ab15-4fe7-930f-5b9895203c80',
  ID_370: '20202020-aa76-4c0a-b17c-4ebef1d02d85',
  ID_371: '20202020-a967-4fb7-9c66-02ae8a2dc573',
  ID_372: '20202020-a52a-4115-abaa-de6ced8994f7',
  ID_373: '20202020-a659-4e64-b9ba-8f6a718667bc',
  ID_374: '20202020-a398-470f-97ef-905b9053f1d7',
  ID_375: '20202020-a9c6-4a3c-bc55-ee55512535f6',
  ID_376: '20202020-ad24-4991-b762-87977537c30f',
  ID_377: '20202020-a633-42ba-888c-12718f2c7d65',
  ID_378: '20202020-a631-44bd-a507-f4c972e97797',
  ID_379: '20202020-ae79-43eb-aa92-28a4aa06df5f',
  ID_380: '20202020-aa15-4a76-a35c-728a7268d87d',
  ID_381: '20202020-ab7c-4acc-bc26-b6fcbd981114',
  ID_382: '20202020-af91-4123-b33b-3a71b446117c',
  ID_383: '20202020-ad21-4ed4-bdf7-d73cbd598099',
  ID_384: '20202020-a68d-49d5-a588-51cbf5aab898',
  ID_385: '20202020-ab2b-4387-8c42-f7487d9d46d4',
  ID_386: '20202020-a216-4ad4-aa26-c00e23fd5844',
  ID_387: '20202020-afe3-4d1d-b238-c47866862c3a',
  ID_388: '20202020-adf9-4c7c-8afa-cf10f4f7d07a',
  ID_389: '20202020-a93a-4e1a-a6b5-8dc99eb8ce86',
  ID_390: '20202020-a4c1-4dc2-ba46-b5b06b7fb6b8',
  ID_391: '20202020-a0ee-44ba-89ad-f6377417e293',
  ID_392: '20202020-ab82-459b-baea-e5d3ad151d36',
  ID_393: '20202020-ad94-4fc4-8d49-2d922c45b189',
  ID_394: '20202020-a219-49d1-83cc-214e001350c9',
  ID_395: '20202020-a945-469e-8ae3-e2cd85f79c15',
  ID_396: '20202020-a4af-407b-884d-d67a5550ad5f',
  ID_397: '20202020-a262-43b6-9f8c-87edb0ef0215',
  ID_398: '20202020-a023-4180-9da1-6b417beacf0e',
  ID_399: '20202020-abb2-4548-9819-923c53153d87',
  ID_400: '20202020-a2da-4948-86af-f8a5cb56bccb',
  ID_401: '20202020-a065-4387-980b-4092a6703336',
  ID_402: '20202020-a673-47a3-b412-d9e19be4a994',
  ID_403: '20202020-a50e-441b-9428-d6b8909ecbbe',
  ID_404: '20202020-a099-4a0d-9dcb-6487aafbae15',
  ID_405: '20202020-ac15-4b16-b94c-39042f7d45c2',
  ID_406: '20202020-ab24-4246-8226-3801c3b06e77',
  ID_407: '20202020-a059-4999-b642-4d0504dfa229',
  ID_408: '20202020-a5be-4af6-9bc8-648553417e61',
  ID_409: '20202020-a657-4453-8435-5d004b261a51',
  ID_410: '20202020-a045-4b32-8484-a6807e9e0d22',
  ID_411: '20202020-a3de-4cdd-8ee3-34149cc32272',
  ID_412: '20202020-a6ba-4d1a-8964-622829039e34',
  ID_413: '20202020-a982-469f-b938-dc4e6b3ad2f6',
  ID_414: '20202020-a1c9-498d-9476-ff5c30111fba',
  ID_415: '20202020-a21e-48d6-8a05-607f3ee54cf1',
  ID_416: '20202020-a0c5-4732-930e-72e658e939ea',
  ID_417: '20202020-a5c6-401e-a055-11c63b1f8c63',
  ID_418: '20202020-a272-41c7-a1ac-59647cbe2bad',
  ID_419: '20202020-ad26-4a55-851b-8acc3c4f0e36',
  ID_420: '20202020-a4d9-4935-bc70-e183b9ae967c',
  ID_421: '20202020-a8b6-409f-8f41-3b47755b142b',
  ID_422: '20202020-aa92-4871-89d0-471e559a95b3',
  ID_423: '20202020-ad87-4bc0-b7ed-a664805a753f',
  ID_424: '20202020-a101-43d7-a42f-6621ca4fa2c4',
  ID_425: '20202020-a316-4d93-a56b-ac9f4b3bde66',
  ID_426: '20202020-a25d-4833-b3a1-7667311bf100',
  ID_427: '20202020-a3b1-45db-b798-19b4bb268f4c',
  ID_428: '20202020-a4b3-4f74-a183-92958bebceb6',
  ID_429: '20202020-abcf-4ae1-8ccd-ea0105317117',
  ID_430: '20202020-a362-4007-b6b8-23224a3d9cab',
  ID_431: '20202020-a4ed-402a-8ae5-2f0a978bf6f0',
  ID_432: '20202020-aaab-4e37-8472-8d5fa763856a',
  ID_433: '20202020-ab51-43fd-a23d-5141065d46fd',
  ID_434: '20202020-a595-466b-9c73-6f6fa4391b98',
  ID_435: '20202020-a1a0-45de-bba7-b7002b85047c',
  ID_436: '20202020-a640-4b47-8b39-433d6ce2be67',
  ID_437: '20202020-a513-4679-9cff-a121913996a7',
  ID_438: '20202020-a254-4d62-83ed-1eb8f7c6fd84',
  ID_439: '20202020-aa29-4f90-ba1c-2cc4d6c4c7c2',
  ID_440: '20202020-a621-4772-b39a-f9e8ed2c4a6f',
  ID_441: '20202020-a0a8-420e-9217-eea91058f7bc',
  ID_442: '20202020-a000-4485-94de-70c2a98daef2',
  ID_443: '20202020-a6b8-4423-bbcc-394550345a9d',
  ID_444: '20202020-a528-4efa-8373-69cb6a370997',
  ID_445: '20202020-a785-464c-a055-4811ac50ace2',
  ID_446: '20202020-a469-4edb-942c-4571d7243172',
  ID_447: '20202020-aca6-4963-a6dc-acdb5618e1ca',
  ID_448: '20202020-a02e-4e28-b4a9-6096b36e26df',
  ID_449: '20202020-acd2-40db-8f19-1f2751cf4fc0',
  ID_450: '20202020-aa50-443f-b83d-18ef2a21a292',
  ID_451: '20202020-a6ea-40bb-8a10-d21d882d4795',
  ID_452: '20202020-aa44-4972-b5b5-1e00e675843b',
  ID_453: '20202020-a975-4e58-bfba-8011177ed614',
  ID_454: '20202020-ac4a-4400-8cef-7099fd422895',
  ID_455: '20202020-a544-4946-9c3a-94e00a24d7d6',
  ID_456: '20202020-a6d5-416d-a74f-1a67d7d38f2d',
  ID_457: '20202020-acdd-4c32-9de6-ab8f22868b72',
  ID_458: '20202020-ab3d-4aa9-9a30-ea0b97bec26d',
  ID_459: '20202020-ac06-4880-bce0-0c55deba0e70',
  ID_460: '20202020-aaed-46f7-a716-83d7506b000e',
  ID_461: '20202020-a414-4099-ab05-bd7978057101',
  ID_462: '20202020-ac03-421b-af11-24a33d59c77b',
  ID_463: '20202020-a5da-485e-ba1e-0593413ce765',
  ID_464: '20202020-aa80-4e13-a426-efa7a35df15f',
  ID_465: '20202020-ad42-494f-a634-50a167607f65',
  ID_466: '20202020-a4fd-46e3-9aa9-b412abace758',
  ID_467: '20202020-a948-4d20-bc77-deee9561d1c6',
  ID_468: '20202020-a652-4e1c-b62a-6036a1552d3f',
  ID_469: '20202020-a60a-4a5f-beaa-d69339e1c22f',
  ID_470: '20202020-ae9e-43c4-987f-8babcd75cfd5',
  ID_471: '20202020-afb2-41e3-87f3-7a0f61ba546a',
  ID_472: '20202020-ab1f-48d2-b70c-a6993585da08',
  ID_473: '20202020-ac66-4117-aa6a-fbf1f6bded69',
  ID_474: '20202020-abac-477d-a6fb-911f28423c83',
  ID_475: '20202020-a3e9-4d96-9ccf-8d3b65b2cdfa',
  ID_476: '20202020-abba-4475-9e22-0a54a3247092',
  ID_477: '20202020-a0bd-4814-87a9-97ae93f2034b',
  ID_478: '20202020-ae97-4f55-adce-c82153d5e29b',
  ID_479: '20202020-a70a-4071-ab3f-d8731c548d2b',
  ID_480: '20202020-a9b4-40da-9a06-811cca19443d',
  ID_481: '20202020-acc1-4851-baaa-e8b8159fafba',
  ID_482: '20202020-a30d-4604-9018-dd212faf7845',
  ID_483: '20202020-aba0-40e7-bcba-3e7927950daf',
  ID_484: '20202020-a475-43a2-a7b2-d225c96003c5',
  ID_485: '20202020-af86-4b50-b5ba-a5835a457259',
  ID_486: '20202020-a6bd-4acf-a5ef-5f62e4bbf65d',
  ID_487: '20202020-ad3e-4f09-b39a-c01b0bc84eae',
  ID_488: '20202020-a9a5-4616-a786-a7cf213c59f0',
  ID_489: '20202020-a7a3-46ed-b6e6-79745720af8f',
  ID_490: '20202020-aaf9-44b7-af76-73cd7aa561c4',
  ID_491: '20202020-a40b-4997-be7f-e944866b606c',
  ID_492: '20202020-a657-4a56-9d42-c2d9e2726a22',
  ID_493: '20202020-a5f0-403b-869c-d5eb3c33eb89',
  ID_494: '20202020-a2cd-4470-a7bf-b15db123cbec',
  ID_495: '20202020-ab7c-427c-a0d7-5681ea79e632',
  ID_496: '20202020-a5be-4aff-8929-5797b9f6833d',
  ID_497: '20202020-a917-4b80-bad4-b5ad1c122256',
  ID_498: '20202020-a4b6-4609-b282-39001908f263',
  ID_499: '20202020-a3ad-4a57-a6dc-9a044afa0db1',
  ID_500: '20202020-aa72-4a46-83c8-fef42161d4f1',
  ID_501: '20202020-aa73-4bad-9623-d1edf90219b6',
  ID_502: '20202020-ac13-4f26-bfcd-ed8b2c6c224d',
  ID_503: '20202020-a5ad-462d-8c25-7ddecd6aa7cc',
  ID_504: '20202020-aa63-4b07-957e-5c188b9e7a04',
  ID_505: '20202020-a4af-48e1-802d-8eb305b33128',
  ID_506: '20202020-ab2a-4282-98d9-41980a4e4795',
  ID_507: '20202020-a215-4d86-b442-f38200409a2e',
  ID_508: '20202020-aa29-4d8f-bfa3-520ca735808c',
  ID_509: '20202020-aedb-4d19-ba79-5833af334e6a',
  ID_510: '20202020-a2f8-46df-b64e-e56fa2a87932',
  ID_511: '20202020-aec4-42e3-b38b-14b2d8263638',
  ID_512: '20202020-aad5-46a9-b435-f83e4cfb7b1f',
  ID_513: '20202020-accd-4472-ae71-18458e1147fd',
  ID_514: '20202020-a3f7-4d53-9e63-69b831e6e230',
  ID_515: '20202020-a6e8-4e71-87f2-5e67b92d521c',
  ID_516: '20202020-a5bf-4355-ba01-20c0a1f9603b',
  ID_517: '20202020-a66e-4da1-bf5d-af1cacb3606c',
  ID_518: '20202020-a48e-4b34-8ece-634226cc5b90',
  ID_519: '20202020-afc7-48a4-8641-53ed0857e65e',
  ID_520: '20202020-a190-454b-b375-dfaf129a0001',
  ID_521: '20202020-a0d2-4eb5-ab51-ac96923fc0b2',
  ID_522: '20202020-a6b9-43a4-a96b-18c407f39db3',
  ID_523: '20202020-ad7d-4df4-9066-5837c4569ccb',
  ID_524: '20202020-ab3f-4fd9-8d69-ffcb197cbff2',
  ID_525: '20202020-a054-45ab-bbb1-5121d7ee5037',
  ID_526: '20202020-a4bb-4bc0-b03c-668ae3f29534',
  ID_527: '20202020-a161-4faf-b0be-c865c83a524f',
  ID_528: '20202020-a771-4af0-9ecd-cb87c0be387b',
  ID_529: '20202020-a1bb-4da5-91e3-31ae24b94b6b',
  ID_530: '20202020-a7a9-427d-afa7-7a0ef1b68856',
  ID_531: '20202020-a142-47f8-8d7b-75c76232cabb',
  ID_532: '20202020-a3a3-474a-8051-b900ffaac02f',
  ID_533: '20202020-a1ee-4686-af31-61e6b49dcd9b',
  ID_534: '20202020-ab09-4115-9e8e-1462006169f0',
  ID_535: '20202020-a141-49de-8a78-7f20cbd3a2a1',
  ID_536: '20202020-a922-4496-9561-f75b2c169b16',
  ID_537: '20202020-ab66-4c44-86c4-bbc86ed091a9',
  ID_538: '20202020-ab3c-4369-b86a-15549501c985',
  ID_539: '20202020-ace0-49c8-ba34-b05618c6dbb9',
  ID_540: '20202020-a5eb-4f2f-9757-6c6f804f836e',
  ID_541: '20202020-ae55-4bd1-a999-85a5828c6cd9',
  ID_542: '20202020-ab10-49f7-8111-5c8e1a7617a6',
  ID_543: '20202020-a854-4dc6-8994-2935ddeeb59a',
  ID_544: '20202020-a160-4384-8d2e-6155f4adee0c',
  ID_545: '20202020-a69a-4f58-9c80-8d6540c047dc',
  ID_546: '20202020-ae80-4fbc-8e79-88233787ce46',
  ID_547: '20202020-aab7-480e-9303-08f5ac0d3136',
  ID_548: '20202020-aacb-4788-ab45-c3e28e5b1f7f',
  ID_549: '20202020-a52e-4389-a485-8729b991e6f1',
  ID_550: '20202020-a116-4833-8b9a-60ae95318d2b',
  ID_551: '20202020-a043-441a-b269-a2378afed31c',
  ID_552: '20202020-aff9-4d18-ba24-26304be22c42',
  ID_553: '20202020-af34-4f9d-9035-c4a031411ba8',
  ID_554: '20202020-aa36-469b-bdf8-62c986736b82',
  ID_555: '20202020-abd6-4c1b-90d9-ab87afd062a1',
  ID_556: '20202020-a2fe-4dc0-b81d-1dedea6c8473',
  ID_557: '20202020-a6c1-4713-b7f9-929964a27f64',
  ID_558: '20202020-a5d2-44cc-97fd-f2ab5f00c22e',
  ID_559: '20202020-af28-4a93-bba3-b02aa55543a3',
  ID_560: '20202020-a0ae-46da-9697-ed949ee75b67',
  ID_561: '20202020-abb6-4964-8b6d-57fec60d63e8',
  ID_562: '20202020-a946-4ecf-b960-342da68a5761',
  ID_563: '20202020-a981-4198-b485-de1995624741',
  ID_564: '20202020-aba2-4628-af2b-bee2757146a1',
  ID_565: '20202020-a8e4-48f4-9b5b-a91a00b4b0cd',
  ID_566: '20202020-af07-495a-929d-ab45e5c6428b',
  ID_567: '20202020-acdb-4e1a-a4d7-359f19a7bfe0',
  ID_568: '20202020-a472-4f6f-9749-06cbce08d4a5',
  ID_569: '20202020-a059-48ca-8d80-164009a58b92',
  ID_570: '20202020-abc6-4eb7-9e03-90585a6f1345',
  ID_571: '20202020-a8e9-4634-bc1b-6e1ae515b9d0',
  ID_572: '20202020-a8fc-4e43-b4a5-c15393883ce3',
  ID_573: '20202020-ad71-4fcf-957f-7f568eb1c7d8',
  ID_574: '20202020-ae16-4dc8-9529-7a5d14ba8e86',
  ID_575: '20202020-a7a8-41a6-9930-93238de04c45',
  ID_576: '20202020-ad58-4269-a157-9f631c2be8af',
  ID_577: '20202020-a354-4ac7-9826-9dfc7efe8125',
  ID_578: '20202020-ad76-4b5d-bb4f-8d43a3054af7',
  ID_579: '20202020-a509-4be6-b4c4-6a2466a212c3',
  ID_580: '20202020-a6ac-4e00-a5e3-4ffd01cdcd3c',
  ID_581: '20202020-a3b5-446c-b410-80ca84717ef5',
  ID_582: '20202020-ab59-44c6-942f-191e0bab1e34',
  ID_583: '20202020-a70d-4aca-aaec-5878254a0f5e',
  ID_584: '20202020-a4d8-468f-94ea-14f0ebd794df',
  ID_585: '20202020-adff-406f-88c5-d553353db985',
  ID_586: '20202020-ad5b-45a5-96ea-934a9efeec95',
  ID_587: '20202020-a1b8-4c63-b163-5dbcc96f946e',
  ID_588: '20202020-ad8e-4782-a0f3-0809cb5c502f',
  ID_589: '20202020-a952-41ca-a3f5-94520f4ff7e5',
  ID_590: '20202020-ae6d-4c8e-9948-3bee6b75e368',
  ID_591: '20202020-a364-4f29-b08a-817acd872a7b',
  ID_592: '20202020-a058-4981-a23c-84e01c6f7cea',
  ID_593: '20202020-ad5f-4a4f-88cd-37408995df9f',
  ID_594: '20202020-a53a-4575-a846-3c8034adb91d',
  ID_595: '20202020-a851-4f6b-9764-6178c3c4c1d8',
  ID_596: '20202020-a6cc-4898-8265-3319b2006a17',
  ID_597: '20202020-a3a8-44cf-bf47-1c74b757ddb9',
  ID_598: '20202020-ade2-432f-9ce1-fa23dbf59769',
  ID_599: '20202020-afff-49b1-99b9-26924b60bd56',
};

// prettier-ignore
const COMPANY_DATA_SEEDS_RAW = [
  {
    id: COMPANY_DATA_SEED_IDS.ID_1,
    name: 'Google',
    domainNamePrimaryLinkUrl: 'goo.gle',
    addressAddressCity: 'Mountain View',
    employees: 284571,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/google',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_2,
    name: 'Microsoft',
    domainNamePrimaryLinkUrl: 'microsoft.com',
    addressAddressCity: 'Redmond',
    employees: 226067,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/microsoft',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_3,
    name: 'Meta',
    domainNamePrimaryLinkUrl: 'metacareers.com',
    addressAddressCity: 'Menlo Park',
    employees: 119511,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/meta',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_4,
    name: 'SLB',
    domainNamePrimaryLinkUrl: 'slb.com',
    addressAddressCity: 'Houston',
    employees: 113151,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/slbglobal',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_5,
    name: 'Cisco',
    domainNamePrimaryLinkUrl: 'cisco.com',
    addressAddressCity: 'San Jose',
    employees: 99625,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/cisco',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_6,
    name: 'Uber',
    domainNamePrimaryLinkUrl: 'uber.com',
    addressAddressCity: 'San Francisco',
    employees: 90545,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/uber-com',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_7,
    name: 'Salesforce',
    domainNamePrimaryLinkUrl: 'salesforce.com',
    addressAddressCity: 'San Francisco',
    employees: 71322,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/salesforce',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_8,
    name: 'Amdocs',
    domainNamePrimaryLinkUrl: 'amdocs.com',
    addressAddressCity: 'Chesterfield',
    employees: 35731,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/amdocs',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_9,
    name: 'VMware',
    domainNamePrimaryLinkUrl: 'vmware.com',
    addressAddressCity: 'Palo Alto',
    employees: 34759,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/vmware',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_10,
    name: 'GlobalLogic',
    domainNamePrimaryLinkUrl: 'globallogic.com',
    addressAddressCity: 'Santa Clara',
    employees: 24461,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/globallogic',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_11,
    name: 'ServiceNow',
    domainNamePrimaryLinkUrl: 'servicenow.com',
    addressAddressCity: 'Santa Clara',
    employees: 24104,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/servicenow',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_12,
    name: 'SS&C Technologies',
    domainNamePrimaryLinkUrl: 'ssctech.com',
    addressAddressCity: 'Windsor',
    employees: 20311,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/ss-c-technologies',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_13,
    name: 'Workday',
    domainNamePrimaryLinkUrl: 'workday.com',
    addressAddressCity: 'Pleasanton',
    employees: 20036,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/workday',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_14,
    name: 'Red Hat',
    domainNamePrimaryLinkUrl: 'redhat.com',
    addressAddressCity: 'Raleigh',
    employees: 19945,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/red-hat',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_15,
    name: 'NetSuite',
    domainNamePrimaryLinkUrl: 'netsuite.com',
    addressAddressCity: 'Austin',
    employees: 19269,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/netsuite',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_16,
    name: 'Synopsys Inc',
    domainNamePrimaryLinkUrl: 'synopsys.com',
    addressAddressCity: 'Sunnyvale',
    employees: 18061,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/synopsys',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_17,
    name: 'Siemens Digital Industries Software',
    domainNamePrimaryLinkUrl: 'sw.siemens.com',
    addressAddressCity: 'Plano',
    employees: 17262,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/siemenssoftware',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_18,
    name: 'SAS',
    domainNamePrimaryLinkUrl: 'sas.com',
    addressAddressCity: 'Cary',
    employees: 16287,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sas',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_19,
    name: 'Intuit',
    domainNamePrimaryLinkUrl: 'intuit.com',
    addressAddressCity: 'Mountain View',
    employees: 15851,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/intuit',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_20,
    name: 'Broadcom Software',
    domainNamePrimaryLinkUrl: 'broadcom.com',
    addressAddressCity: 'San Jose',
    employees: 15127,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/broadcomsoftware',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_21,
    name: 'Autodesk',
    domainNamePrimaryLinkUrl: 'autodesk.com',
    addressAddressCity: 'San Francisco',
    employees: 14593,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/autodesk',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_22,
    name: 'Epic',
    domainNamePrimaryLinkUrl: 'epic.com',
    addressAddressCity: 'Verona',
    employees: 13765,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/epic1979',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_23,
    name: 'Bosch USA',
    domainNamePrimaryLinkUrl: 'bosch.us',
    addressAddressCity: 'Farmington',
    employees: 13754,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/boschusa',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_24,
    name: 'Cloud Software Group',
    domainNamePrimaryLinkUrl: 'cloudsoftwaregroup.com',
    addressAddressCity: 'Fort Lauderdale',
    employees: 13111,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/cloudsoftwaregroup',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_25,
    name: 'Pitney Bowes',
    domainNamePrimaryLinkUrl: 'pitneybowes.com',
    addressAddressCity: 'Stamford',
    employees: 12306,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pitney-bowes',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_26,
    name: 'Juniper Networks',
    domainNamePrimaryLinkUrl: 'juniper.net',
    addressAddressCity: 'Sunnyvale',
    employees: 11928,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/juniper-networks',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_27,
    name: 'Chegg Inc.',
    domainNamePrimaryLinkUrl: 'chegg.com',
    addressAddressCity: 'Santa Clara',
    employees: 10790,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/chegg-inc-',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_28,
    name: 'Teradata',
    domainNamePrimaryLinkUrl: 'teradata.com',
    addressAddressCity: 'San Diego',
    employees: 10748,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/teradata',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_29,
    name: 'NICE',
    domainNamePrimaryLinkUrl: 'nice.com',
    addressAddressCity: 'Hoboken',
    employees: 10258,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/nice-systems',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_30,
    name: 'Cadence Design Systems',
    domainNamePrimaryLinkUrl: 'cadence.com',
    addressAddressCity: 'San Jose',
    employees: 9377,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/cadence-design-systems',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_31,
    name: 'Cox Automotive Inc.',
    domainNamePrimaryLinkUrl: 'coxautoinc.com',
    addressAddressCity: 'Atlanta',
    employees: 9331,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/cox-automotive-inc-',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_32,
    name: 'Trimble Inc.',
    domainNamePrimaryLinkUrl: 'trimble.com',
    addressAddressCity: 'Broomfield',
    employees: 9311,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/trimble',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_33,
    name: '[24]7.ai',
    domainNamePrimaryLinkUrl: '247.ai',
    addressAddressCity: 'San Jose',
    employees: 9170,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/24-7-ai',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_34,
    name: 'Akamai Technologies',
    domainNamePrimaryLinkUrl: 'akamai.com',
    addressAddressCity: 'Cambridge',
    employees: 9168,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/akamai-technologies',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_35,
    name: 'Splunk',
    domainNamePrimaryLinkUrl: 'splunk.com',
    addressAddressCity: 'San Francisco',
    employees: 8891,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/splunk',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_36,
    name: 'Okta',
    domainNamePrimaryLinkUrl: 'okta.com',
    addressAddressCity: 'San Francisco',
    employees: 8860,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/okta-inc-',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_37,
    name: 'Ceridian',
    domainNamePrimaryLinkUrl: 'ceridian.com',
    addressAddressCity: 'Minneapolis',
    employees: 8813,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ceridian',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_38,
    name: 'RealPage, Inc.',
    domainNamePrimaryLinkUrl: 'realpage.com',
    addressAddressCity: 'Richardson',
    employees: 8227,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/realpage',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_39,
    name: 'Freelance',
    domainNamePrimaryLinkUrl: 'jobicy.com',
    addressAddressCity: 'Ny',
    employees: 8180,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pro-freelance',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_40,
    name: 'Stripe',
    domainNamePrimaryLinkUrl: 'stripe.com',
    addressAddressCity: 'South San Francisco',
    employees: 8145,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/stripe',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_41,
    name: 'Shutterfly',
    domainNamePrimaryLinkUrl: 'shutterflyinc.com',
    addressAddressCity: 'San Jose',
    employees: 8070,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/shutterfly',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_42,
    name: 'Unity',
    domainNamePrimaryLinkUrl: 'unity.com',
    addressAddressCity: 'San Francisco',
    employees: 8063,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/unity',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_43,
    name: 'Veeva Systems',
    domainNamePrimaryLinkUrl: 'veeva.com',
    addressAddressCity: 'Pleasanton',
    employees: 7831,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/veeva-systems',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_44,
    name: 'Nuance Communications',
    domainNamePrimaryLinkUrl: 'nuance.com',
    addressAddressCity: 'Burlington',
    employees: 7761,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/nuance-communications',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_45,
    name: 'Freshworks',
    domainNamePrimaryLinkUrl: 'freshworks.com',
    addressAddressCity: 'San Mateo',
    employees: 7687,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/freshworks-inc',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_46,
    name: 'Seal Software, a DocuSign Company',
    domainNamePrimaryLinkUrl: 'seal-software.com',
    addressAddressCity: 'Walnut Creek',
    employees: 7586,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/seal-software-group',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_47,
    name: 'DocuSign',
    domainNamePrimaryLinkUrl: 'docusign.com',
    addressAddressCity: 'San Francisco',
    employees: 7557,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/docusign',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_48,
    name: 'Nutanix',
    domainNamePrimaryLinkUrl: 'nutanix.com',
    addressAddressCity: 'San Jose',
    employees: 7454,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/nutanix',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_49,
    name: 'Genesys',
    domainNamePrimaryLinkUrl: 'genesys.com',
    addressAddressCity: 'Menlo Park',
    employees: 7371,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/genesys',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_50,
    name: 'SAP Concur',
    domainNamePrimaryLinkUrl: 'concur.com',
    addressAddressCity: 'Bellevue',
    employees: 7305,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sapconcur',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_51,
    name: 'Square',
    domainNamePrimaryLinkUrl: 'squareup.com',
    addressAddressCity: 'San Francisco',
    employees: 7233,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/joinsquare',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_52,
    name: 'Snap Inc.',
    domainNamePrimaryLinkUrl: 'snap.com',
    addressAddressCity: 'Santa Monica',
    employees: 7219,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/snap-inc-co',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_53,
    name: 'MathWorks',
    domainNamePrimaryLinkUrl: 'mathworks.com',
    addressAddressCity: 'Natick',
    employees: 7188,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/the-mathworks_2',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_54,
    name: 'PTC',
    domainNamePrimaryLinkUrl: 'ptc.co',
    addressAddressCity: 'Boston',
    employees: 7119,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ptcinc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_55,
    name: 'Ansys',
    domainNamePrimaryLinkUrl: 'ansys.com',
    addressAddressCity: 'Canonsburg',
    employees: 7112,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ansys-inc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_56,
    name: 'Aricent',
    domainNamePrimaryLinkUrl: 'altran.com',
    addressAddressCity: 'Santa Clara',
    employees: 7016,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aricent',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_57,
    name: 'Databricks',
    domainNamePrimaryLinkUrl: 'databricks.com',
    addressAddressCity: 'San Francisco',
    employees: 6927,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/databricks',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_58,
    name: 'Shipt',
    domainNamePrimaryLinkUrl: 'shipt.com',
    addressAddressCity: 'Birmingham',
    employees: 6902,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/shipt',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_59,
    name: 'CSG',
    domainNamePrimaryLinkUrl: 'csgi.com',
    addressAddressCity: 'Englewood',
    employees: 6849,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/csg-',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_60,
    name: 'Twilio',
    domainNamePrimaryLinkUrl: 'twilio.com',
    addressAddressCity: 'San Francisco',
    employees: 6721,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/twilio-inc-',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_61,
    name: 'Veritas Technologies LLC',
    domainNamePrimaryLinkUrl: 'veritas.com',
    addressAddressCity: 'Santa Clara',
    employees: 6718,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/veritas-technologies-llc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_62,
    name: 'Citrix',
    domainNamePrimaryLinkUrl: 'citrix.com',
    addressAddressCity: 'Fort Lauderdale',
    employees: 6528,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/citrix',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_63,
    name: 'Tyler Technologies',
    domainNamePrimaryLinkUrl: 'tylertech.com',
    addressAddressCity: 'Plano',
    employees: 6496,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/tyler-technologies',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_64,
    name: 'Esri',
    domainNamePrimaryLinkUrl: 'esri.com',
    addressAddressCity: 'Redlands',
    employees: 6463,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/esri',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_65,
    name: 'Paycom',
    domainNamePrimaryLinkUrl: 'paycom.com',
    addressAddressCity: 'Oklahoma City',
    employees: 6378,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/paycom',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_66,
    name: 'Roblox',
    domainNamePrimaryLinkUrl: 'roblox.com',
    addressAddressCity: 'San Mateo',
    employees: 6297,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/roblox',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_67,
    name: 'Zendesk',
    domainNamePrimaryLinkUrl: 'zendesk.com',
    addressAddressCity: 'San Francisco',
    employees: 6255,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/zendesk',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_68,
    name: 'Newfold Digital',
    domainNamePrimaryLinkUrl: 'newfold.com',
    addressAddressCity: 'Jacksonville',
    employees: 6213,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/newfold',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_69,
    name: 'Informatica',
    domainNamePrimaryLinkUrl: 'informatica.com',
    addressAddressCity: 'Redwood City',
    employees: 5850,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/informatica',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_70,
    name: 'Caf\u00e9',
    domainNamePrimaryLinkUrl: 'at.cafe',
    addressAddressCity: 'New York',
    employees: 5795,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/get-cafe',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_71,
    name: 'Mavenir',
    domainNamePrimaryLinkUrl: 'mavenir.com',
    addressAddressCity: 'Richardson',
    employees: 5763,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mavenir',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_72,
    name: 'Allscripts',
    domainNamePrimaryLinkUrl: 'allscripts.com',
    addressAddressCity: 'Chicago',
    employees: 5719,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/allscripts',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_73,
    name: 'Yardi',
    domainNamePrimaryLinkUrl: 'yardi.com',
    addressAddressCity: 'Goleta',
    employees: 5583,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/yardi',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_74,
    name: 'Datadog',
    domainNamePrimaryLinkUrl: 'datadoghq.com',
    addressAddressCity: 'New York',
    employees: 5470,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/datadog',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_75,
    name: 'Epicor',
    domainNamePrimaryLinkUrl: 'epicor.com',
    addressAddressCity: 'Austin',
    employees: 5310,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/epicor-software-corp',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_76,
    name: 'Hexagon Asset Lifecycle Intelligence',
    domainNamePrimaryLinkUrl: 'hexagonppm.com',
    addressAddressCity: 'Madison',
    employees: 5262,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/hexagonassetlifecycleintelligence',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_77,
    name: 'Blue Yonder',
    domainNamePrimaryLinkUrl: 'blueyonder.com',
    addressAddressCity: 'Scottsdale',
    employees: 5205,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/blueyonder',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_78,
    name: 'MongoDB',
    domainNamePrimaryLinkUrl: 'mongodb.com',
    addressAddressCity: 'New York',
    employees: 5182,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mongodbinc',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_79,
    name: 'uTest',
    domainNamePrimaryLinkUrl: 'utest.com',
    addressAddressCity: 'Framingham',
    employees: 5125,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/utest',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_80,
    name: 'Paylocity',
    domainNamePrimaryLinkUrl: 'paylocity.com',
    addressAddressCity: 'Schaumburg',
    employees: 5095,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/paylocity',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_81,
    name: 'IAC',
    domainNamePrimaryLinkUrl: 'iac.com',
    addressAddressCity: 'New York',
    employees: 5040,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/iac',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_82,
    name: 'Toast',
    domainNamePrimaryLinkUrl: 'toasttab.com',
    addressAddressCity: 'Boston',
    employees: 5008,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/toast-inc',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_83,
    name: 'Bentley Systems',
    domainNamePrimaryLinkUrl: 'bentley.com',
    addressAddressCity: 'Exton',
    employees: 4862,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/bentley-systems',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_84,
    name: 'Owner.com',
    domainNamePrimaryLinkUrl: 'owner.com',
    addressAddressCity: 'Palo Alto',
    employees: 4677,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/profitboss',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_85,
    name: 'eClinicalWorks',
    domainNamePrimaryLinkUrl: 'eclinicalworks.com',
    addressAddressCity: 'Westborough',
    employees: 4661,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/eclinicalworks',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_86,
    name: 'Altimetrik',
    domainNamePrimaryLinkUrl: 'altimetrik.com',
    addressAddressCity: 'Southfield',
    employees: 4629,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/altimetrik',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_87,
    name: 'CA Technologies',
    domainNamePrimaryLinkUrl: 'ca.com',
    addressAddressCity: 'San Jose',
    employees: 4616,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ca-technologies',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_88,
    name: 'Dynatrace',
    domainNamePrimaryLinkUrl: 'dynatrace.com',
    addressAddressCity: 'Waltham',
    employees: 4502,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/dynatrace',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_89,
    name: 'Sprinklr',
    domainNamePrimaryLinkUrl: 'sprinklr.com',
    addressAddressCity: 'New York',
    employees: 4495,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sprinklr',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_90,
    name: 'UiPath',
    domainNamePrimaryLinkUrl: 'uipath.com',
    addressAddressCity: 'New York',
    employees: 4484,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/uipath',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_91,
    name: 'The Reynolds and Reynolds Company',
    domainNamePrimaryLinkUrl: 'reyrey.com',
    addressAddressCity: 'Dayton',
    employees: 4473,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/the-reynolds-and-reynolds-company',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_92,
    name: 'Stealth',
    domainNamePrimaryLinkUrl: 'stealthstartup.com',
    addressAddressCity: 'San Francisco',
    employees: 4472,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/stealthstartup',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_93,
    name: 'WEX',
    domainNamePrimaryLinkUrl: 'wexinc.com',
    addressAddressCity: 'Portland',
    employees: 4377,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/wexinc',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_94,
    name: 'HighRadius',
    domainNamePrimaryLinkUrl: 'highradius.com',
    addressAddressCity: 'Houston',
    employees: 4316,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/highradius',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_95,
    name: 'Avalara',
    domainNamePrimaryLinkUrl: 'avalara.com',
    addressAddressCity: 'Seattle',
    employees: 4311,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/avalara',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_96,
    name: 'Manhattan Associates',
    domainNamePrimaryLinkUrl: 'manh.com',
    addressAddressCity: 'Atlanta',
    employees: 4236,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/manhattan-associates',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_97,
    name: 'Aspen Technology',
    domainNamePrimaryLinkUrl: 'aspentech.com',
    addressAddressCity: 'Bedford',
    employees: 4194,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aspen-technology',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_98,
    name: 'Hyland',
    domainNamePrimaryLinkUrl: 'hyland.com',
    addressAddressCity: 'Westlake',
    employees: 4166,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/hyland-software',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_99,
    name: 'Palantir Technologies',
    domainNamePrimaryLinkUrl: 'palantir.com',
    addressAddressCity: 'Denver',
    employees: 4104,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/palantir-technologies',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_100,
    name: 'Market America, Inc.',
    domainNamePrimaryLinkUrl: 'marketamerica.com',
    addressAddressCity: 'Greensboro',
    employees: 4091,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/market-america-inc-',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_101,
    name: 'Procore Technologies',
    domainNamePrimaryLinkUrl: 'procore.com',
    addressAddressCity: 'Carpinteria',
    employees: 4010,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/procore-technologies',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_102,
    name: 'ZoomInfo',
    domainNamePrimaryLinkUrl: 'zoominfo.com',
    addressAddressCity: 'Vancouver',
    employees: 3875,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/zoominfo',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_103,
    name: 'TIBCO',
    domainNamePrimaryLinkUrl: 'tibco.com',
    addressAddressCity: 'Palo Alto',
    employees: 3871,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tibco',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_104,
    name: 'GE Digital',
    domainNamePrimaryLinkUrl: 'ge.com',
    addressAddressCity: 'San Ramon',
    employees: 3849,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ge-digital',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_105,
    name: 'RMS',
    domainNamePrimaryLinkUrl: 'rms.com',
    addressAddressCity: 'Newark',
    employees: 3844,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/rms',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_106,
    name: 'Tableau',
    domainNamePrimaryLinkUrl: 'tableau.com',
    addressAddressCity: 'Seattle',
    employees: 3838,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tableau-software',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_107,
    name: 'Extreme Networks',
    domainNamePrimaryLinkUrl: 'extremenetworks.com',
    addressAddressCity: 'Morrisville',
    employees: 3799,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/extreme-networks',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_108,
    name: 'Smartsheet',
    domainNamePrimaryLinkUrl: 'smartsheet.com',
    addressAddressCity: 'Bellevue',
    employees: 3798,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/smartsheet-com',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_109,
    name: 'Quest Software',
    domainNamePrimaryLinkUrl: 'quest.com',
    addressAddressCity: 'Aliso Viejo',
    employees: 3795,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/quest-software',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_110,
    name: 'Motive',
    domainNamePrimaryLinkUrl: 'gomotive.com',
    addressAddressCity: 'San Francisco',
    employees: 3788,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/motive-inc',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_111,
    name: 'Retired Life',
    domainNamePrimaryLinkUrl: 'swde.com',
    addressAddressCity: 'San Jose',
    employees: 3774,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/retired-life',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_112,
    name: 'Dropbox',
    domainNamePrimaryLinkUrl: 'dropbox.com',
    addressAddressCity: 'San Francisco',
    employees: 3751,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/dropbox',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_113,
    name: 'Deltek',
    domainNamePrimaryLinkUrl: 'deltek.com',
    addressAddressCity: 'Herndon',
    employees: 3727,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/deltek',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_114,
    name: 'e2open',
    domainNamePrimaryLinkUrl: 'e2open.com',
    addressAddressCity: 'Austin',
    employees: 3694,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/e2open',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_115,
    name: 'Altair',
    domainNamePrimaryLinkUrl: 'altair.com',
    addressAddressCity: 'Troy',
    employees: 3596,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/altair-engineering',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_116,
    name: 'Gopuff',
    domainNamePrimaryLinkUrl: 'gopuff.com',
    addressAddressCity: 'Philadelphia',
    employees: 3574,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/gopuff',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_117,
    name: 'FICO',
    domainNamePrimaryLinkUrl: 'fico.com',
    addressAddressCity: 'Bozeman',
    employees: 3511,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/fico',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_118,
    name: 'Elastic',
    domainNamePrimaryLinkUrl: 'elastic.co',
    addressAddressCity: 'Mountain View',
    employees: 3489,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/elastic-co',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_119,
    name: 'Blackbaud',
    domainNamePrimaryLinkUrl: 'blackbaud.com',
    addressAddressCity: 'Charleston',
    employees: 3478,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/blackbaud',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_120,
    name: 'MicroStrategy',
    domainNamePrimaryLinkUrl: 'microstrategy.com',
    addressAddressCity: 'Vienna',
    employees: 3469,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/microstrategy',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_121,
    name: 'Discord',
    domainNamePrimaryLinkUrl: 'discord.com',
    addressAddressCity: 'San Francisco',
    employees: 3467,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/discord',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_122,
    name: 'Inovalon',
    domainNamePrimaryLinkUrl: 'inovalon.com',
    addressAddressCity: 'Bowie',
    employees: 3459,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/inovalon',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_123,
    name: 'Progress',
    domainNamePrimaryLinkUrl: 'progress.com',
    addressAddressCity: 'Burlington',
    employees: 3428,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/progress-software',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_124,
    name: 'Rubrik',
    domainNamePrimaryLinkUrl: 'rbrk.co',
    addressAddressCity: 'Palo Alto',
    employees: 3370,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/rubrik-inc',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_125,
    name: 'Axtria - Ingenious Insights',
    domainNamePrimaryLinkUrl: 'axtria.com',
    addressAddressCity: 'Berkeley Heights',
    employees: 3367,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/axtria',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_126,
    name: 'Audible',
    domainNamePrimaryLinkUrl: 'audible.com',
    addressAddressCity: 'Newark',
    employees: 3192,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/audible',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_127,
    name: 'Kaseya',
    domainNamePrimaryLinkUrl: 'kaseya.com',
    addressAddressCity: 'Miami',
    employees: 3191,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kaseya',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_128,
    name: 'MRI Software',
    domainNamePrimaryLinkUrl: 'mrisoftware.com',
    addressAddressCity: 'Solon',
    employees: 3107,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mri-software-llc',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_129,
    name: 'CyberArk',
    domainNamePrimaryLinkUrl: 'cyberark.com',
    addressAddressCity: 'Newton Center',
    employees: 3099,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/cyber-ark-software',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_130,
    name: 'Cornerstone OnDemand',
    domainNamePrimaryLinkUrl: 'cornerstoneondemand.com',
    addressAddressCity: 'Santa Monica',
    employees: 3089,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/cornerstone-ondemand',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_131,
    name: 'Reddit, Inc.',
    domainNamePrimaryLinkUrl: 'redditinc.com',
    addressAddressCity: 'San Francisco',
    employees: 3061,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/reddit-com',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_132,
    name: 'Ivanti',
    domainNamePrimaryLinkUrl: 'ivanti.com',
    addressAddressCity: 'South Jordan',
    employees: 3056,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ivanti',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_133,
    name: 'Cloudera',
    domainNamePrimaryLinkUrl: 'cloudera.com',
    addressAddressCity: 'Santa Clara',
    employees: 3007,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/cloudera',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_134,
    name: 'Medidata Solutions',
    domainNamePrimaryLinkUrl: 'medidata.com',
    addressAddressCity: 'New York',
    employees: 3001,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/medidata-solutions',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_135,
    name: 'Commvault',
    domainNamePrimaryLinkUrl: 'commvault.com',
    addressAddressCity: 'Eatontown',
    employees: 2974,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/commvault',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_136,
    name: 'ConnectWise',
    domainNamePrimaryLinkUrl: 'connectwise.com',
    addressAddressCity: 'Tampa',
    employees: 2937,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/connectwise',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_137,
    name: 'BILL',
    domainNamePrimaryLinkUrl: 'bill.com',
    addressAddressCity: 'Alviso',
    employees: 2932,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/bill',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_138,
    name: 'Alteryx',
    domainNamePrimaryLinkUrl: 'alteryx.com',
    addressAddressCity: 'Irvine',
    employees: 2916,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/alteryx',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_139,
    name: 'MNC Software',
    domainNamePrimaryLinkUrl: 'mncsoftware.com',
    addressAddressCity: 'San Diego',
    employees: 2912,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mnc-software',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_140,
    name: 'Celonis',
    domainNamePrimaryLinkUrl: 'celonis.com',
    addressAddressCity: 'New York',
    employees: 2906,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/celonis',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_141,
    name: 'Attachmate',
    domainNamePrimaryLinkUrl: 'microfocus.com',
    addressAddressCity: 'Seattle',
    employees: 2889,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/attachmate',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_142,
    name: 'NETSCOUT',
    domainNamePrimaryLinkUrl: 'netscout.com',
    addressAddressCity: 'Westford',
    employees: 2853,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/netscout',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_143,
    name: 'Confluent',
    domainNamePrimaryLinkUrl: 'confluent.io',
    addressAddressCity: 'Mountain View',
    employees: 2844,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/confluent',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_144,
    name: 'Samsara',
    domainNamePrimaryLinkUrl: 'samsara.com',
    addressAddressCity: 'San Francisco',
    employees: 2824,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/samsara',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_145,
    name: 'Chetu, Inc.',
    domainNamePrimaryLinkUrl: 'chetu.com',
    addressAddressCity: 'Fort Lauderdale',
    employees: 2809,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/chetu-inc-',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_146,
    name: 'Kronos Incorporated',
    domainNamePrimaryLinkUrl: 'ukg.com',
    addressAddressCity: 'Lowell',
    employees: 2808,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kronos',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_147,
    name: 'Qlik',
    domainNamePrimaryLinkUrl: 'qlik.com',
    addressAddressCity: 'King Of Prussia',
    employees: 2779,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/qlik',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_148,
    name: 'Vertafore',
    domainNamePrimaryLinkUrl: 'vertafore.com',
    addressAddressCity: 'Denver',
    employees: 2768,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/vertafore',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_149,
    name: 'Asana',
    domainNamePrimaryLinkUrl: 'asana.com',
    addressAddressCity: 'San Francisco',
    employees: 2753,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/asana',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_150,
    name: 'Jamf',
    domainNamePrimaryLinkUrl: 'jamf.com',
    addressAddressCity: 'Minneapolis',
    employees: 2721,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/jamf-software',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_151,
    name: 'Paycor',
    domainNamePrimaryLinkUrl: 'paycor.com',
    addressAddressCity: 'Cincinnati',
    employees: 2719,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/paycor',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_152,
    name: 'Hudl',
    domainNamePrimaryLinkUrl: 'hudl.com',
    addressAddressCity: 'Lincoln',
    employees: 2709,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/hudl',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_153,
    name: 'Precisely',
    domainNamePrimaryLinkUrl: 'precisely.com',
    addressAddressCity: 'Burlington',
    employees: 2662,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/preciselydata',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_154,
    name: 'New Relic',
    domainNamePrimaryLinkUrl: 'newrelic.com',
    addressAddressCity: 'San Francisco',
    employees: 2636,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/new-relic-inc-',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_155,
    name: 'Aptean',
    domainNamePrimaryLinkUrl: 'aptean.com',
    addressAddressCity: 'Alpharetta',
    employees: 2617,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aptean',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_156,
    name: 'o9 Solutions, Inc.',
    domainNamePrimaryLinkUrl: 'o9solutions.com',
    addressAddressCity: 'Dallas',
    employees: 2612,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/o9solutions',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_157,
    name: 'SpotOn',
    domainNamePrimaryLinkUrl: 'spoton.com',
    addressAddressCity: 'San Francisco',
    employees: 2608,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/spoton',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_158,
    name: 'Automation Anywhere',
    domainNamePrimaryLinkUrl: 'automationanywhere.com',
    addressAddressCity: 'San Jose',
    employees: 2588,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/automation-anywhere',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_159,
    name: 'Tekion Corp',
    domainNamePrimaryLinkUrl: 'tekion.com',
    addressAddressCity: 'Pleasanton',
    employees: 2579,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tekion',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_160,
    name: 'Aurora',
    domainNamePrimaryLinkUrl: 'aurora.tech',
    addressAddressCity: 'Mountain View',
    employees: 2557,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aurora-inc.',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_161,
    name: 'SolarWinds',
    domainNamePrimaryLinkUrl: 'solarwinds.com',
    addressAddressCity: 'Austin',
    employees: 2529,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/solarwinds',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_162,
    name: 'GoTo',
    domainNamePrimaryLinkUrl: 'goto.com',
    addressAddressCity: 'Boston',
    employees: 2505,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/goto',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_163,
    name: 'PROS',
    domainNamePrimaryLinkUrl: 'pros.com',
    addressAddressCity: 'Houston',
    employees: 2479,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pros',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_164,
    name: 'Miro',
    domainNamePrimaryLinkUrl: 'miro.com',
    addressAddressCity: 'San Francisco',
    employees: 2445,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mirohq',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_165,
    name: 'Kofax',
    domainNamePrimaryLinkUrl: 'kofax.com',
    addressAddressCity: 'Irvine',
    employees: 2442,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kofax',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_166,
    name: 'Accolite Digital',
    domainNamePrimaryLinkUrl: 'accolite.com',
    addressAddressCity: 'Addison',
    employees: 2438,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/accolitedigital',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_167,
    name: 'HashiCorp',
    domainNamePrimaryLinkUrl: 'hashicorp.com',
    addressAddressCity: 'San Francisco',
    employees: 2436,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/hashicorp',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_168,
    name: 'Pluralsight',
    domainNamePrimaryLinkUrl: 'pluralsight.com',
    addressAddressCity: 'Draper',
    employees: 2433,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pluralsight',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_169,
    name: 'Bottomline Technologies',
    domainNamePrimaryLinkUrl: 'bottomline.com',
    addressAddressCity: 'Portsmouth',
    employees: 2407,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/bottomline-technologies',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_170,
    name: 'Anaplan',
    domainNamePrimaryLinkUrl: 'anaplan.com',
    addressAddressCity: 'San Francisco',
    employees: 2401,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/anaplan',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_171,
    name: 'OneTrust',
    domainNamePrimaryLinkUrl: 'onetrust.com',
    addressAddressCity: 'Atlanta',
    employees: 2383,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/onetrust',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_172,
    name: 'Medallia',
    domainNamePrimaryLinkUrl: 'medallia.com',
    addressAddressCity: 'Pleasanton',
    employees: 2381,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/medallia-inc.',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_173,
    name: 'SailPoint',
    domainNamePrimaryLinkUrl: 'sailpoint.com',
    addressAddressCity: 'Austin',
    employees: 2366,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/sailpoint-technologies',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_174,
    name: 'Appian Corporation',
    domainNamePrimaryLinkUrl: 'appian.com',
    addressAddressCity: 'Mc Lean',
    employees: 2345,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/appian-corporation',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_175,
    name: 'Dealertrack',
    domainNamePrimaryLinkUrl: 'dealertrack.com',
    addressAddressCity: 'New Hyde Park',
    employees: 2335,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/dealertrack',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_176,
    name: 'impact.com',
    domainNamePrimaryLinkUrl: 'impact.com',
    addressAddressCity: 'Santa Barbara',
    employees: 2327,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/impactdotcom',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_177,
    name: 'Inhabit\u00ae',
    domainNamePrimaryLinkUrl: 'inhabitiq.com',
    addressAddressCity: 'Knoxville',
    employees: 2286,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/inhabit-iq',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_178,
    name: 'SymphonyAI',
    domainNamePrimaryLinkUrl: 'symphonyai.com',
    addressAddressCity: 'Palo Alto',
    employees: 2282,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/symphonyai',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_179,
    name: 'CCC Intelligent Solutions',
    domainNamePrimaryLinkUrl: 'cccis.com',
    addressAddressCity: 'Chicago',
    employees: 2282,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/ccc-intelligent-solutions',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_180,
    name: 'Toshiba Global Commerce Solutions',
    domainNamePrimaryLinkUrl: 'toshiba.com',
    addressAddressCity: 'Durham',
    employees: 2281,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/toshibacommerce',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_181,
    name: 'Vertex Inc.',
    domainNamePrimaryLinkUrl: 'vertexinc.com',
    addressAddressCity: 'King Of Prussia',
    employees: 2265,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/vertex-inc.',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_182,
    name: 'PRO Unlimited',
    domainNamePrimaryLinkUrl: 'magnitglobal.com',
    addressAddressCity: 'San Francisco',
    employees: 2264,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/prounlimited',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_183,
    name: 'Five9',
    domainNamePrimaryLinkUrl: 'five9.com',
    addressAddressCity: 'San Ramon',
    employees: 2253,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/five9',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_184,
    name: 'Cohesity',
    domainNamePrimaryLinkUrl: 'cohesity.com',
    addressAddressCity: 'San Jose',
    employees: 2252,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/cohesity',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_185,
    name: 'Wind River',
    domainNamePrimaryLinkUrl: 'windriver.com',
    addressAddressCity: 'Alameda',
    employees: 2244,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/wind-river',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_186,
    name: 'Icertis',
    domainNamePrimaryLinkUrl: 'icertis.com',
    addressAddressCity: 'Bellevue',
    employees: 2233,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/icertis',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_187,
    name: 'Navan',
    domainNamePrimaryLinkUrl: 'navan.com',
    addressAddressCity: 'Palo Alto',
    employees: 2221,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/navan',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_188,
    name: 'Diligent',
    domainNamePrimaryLinkUrl: 'diligent.com',
    addressAddressCity: 'New York',
    employees: 2215,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/diligent-board-member-services',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_189,
    name: 'Applied Systems',
    domainNamePrimaryLinkUrl: 'appliedsystems.com',
    addressAddressCity: 'University Park',
    employees: 2198,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/applied-systems',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_190,
    name: 'Forcepoint',
    domainNamePrimaryLinkUrl: 'forcepoint.com',
    addressAddressCity: 'Austin',
    employees: 2196,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/forcepoint',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_191,
    name: 'Compuware',
    domainNamePrimaryLinkUrl: 'bmc.com',
    addressAddressCity: 'Detroit',
    employees: 2183,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/compuware',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_192,
    name: 'Netsmart',
    domainNamePrimaryLinkUrl: 'ntst.com',
    addressAddressCity: 'Leawood',
    employees: 2177,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/netsmart',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_193,
    name: 'The Apache Software Foundation',
    domainNamePrimaryLinkUrl: 'apache.org',
    addressAddressCity: 'Wilmington',
    employees: 2177,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/the-apache-software-foundation',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_194,
    name: 'ArisGlobal',
    domainNamePrimaryLinkUrl: 'arisglobal.com',
    addressAddressCity: 'Miami',
    employees: 2168,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aris-global',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_195,
    name: 'WORKING BY MY SELF',
    domainNamePrimaryLinkUrl: 'fcutechnologies.com',
    addressAddressCity: 'Fort Lauderdale',
    employees: 2148,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/working-by-my-self',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_196,
    name: 'Varonis',
    domainNamePrimaryLinkUrl: 'varonis.com',
    addressAddressCity: 'New York',
    employees: 2140,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/varonis',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_197,
    name: 'Fever',
    domainNamePrimaryLinkUrl: 'feverup.com',
    addressAddressCity: 'New York',
    employees: 2125,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/fever-up',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_198,
    name: 'Agilysys',
    domainNamePrimaryLinkUrl: 'agilysys.com',
    addressAddressCity: 'Alpharetta',
    employees: 2081,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/agilysys',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_199,
    name: 'OutSystems',
    domainNamePrimaryLinkUrl: 'outsystems.com',
    addressAddressCity: 'Boston',
    employees: 2057,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/outsystems',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_200,
    name: 'Entrata',
    domainNamePrimaryLinkUrl: 'entrata.com',
    addressAddressCity: 'Lehi',
    employees: 2045,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/entratasoftware',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_201,
    name: 'Verkada',
    domainNamePrimaryLinkUrl: 'verkada.com',
    addressAddressCity: 'San Mateo',
    employees: 2044,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/verkada',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_202,
    name: 'Majesco',
    domainNamePrimaryLinkUrl: 'majesco.com',
    addressAddressCity: 'Morristown',
    employees: 2021,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/majesco',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_203,
    name: 'Boomi',
    domainNamePrimaryLinkUrl: 'boomi.com',
    addressAddressCity: 'Wayne',
    employees: 2009,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/boomi-inc',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_204,
    name: 'PDI Technologies',
    domainNamePrimaryLinkUrl: 'pditechnologies.com',
    addressAddressCity: 'Alpharetta',
    employees: 2005,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pdi-technologies',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_205,
    name: 'ServiceTitan',
    domainNamePrimaryLinkUrl: 'servicetitan.com',
    addressAddressCity: 'Glendale',
    employees: 1997,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/servicetitan',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_206,
    name: 'Sitecore',
    domainNamePrimaryLinkUrl: 'sitecore.com',
    addressAddressCity: 'San Francisco',
    employees: 1943,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sitecore',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_207,
    name: 'SAP SuccessFactors',
    domainNamePrimaryLinkUrl: 'sap.com',
    addressAddressCity: 'South San Francisco',
    employees: 1941,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/successfactors',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_208,
    name: 'Postman',
    domainNamePrimaryLinkUrl: 'postman.com',
    addressAddressCity: 'San Francisco',
    employees: 1928,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/postman-platform',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_209,
    name: 'Scale AI',
    domainNamePrimaryLinkUrl: 'scale.com',
    addressAddressCity: 'San Francisco',
    employees: 1906,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/scaleai',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_210,
    name: 'Duck Creek Technologies',
    domainNamePrimaryLinkUrl: 'duckcreek.com',
    addressAddressCity: 'Boston',
    employees: 1894,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/duck-creek-technologies',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_211,
    name: 'MICROS Systems Inc',
    domainNamePrimaryLinkUrl: 'oracle.com',
    addressAddressCity: 'Columbia',
    employees: 1882,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/micros-systems-inc',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_212,
    name: 'Riverbed Technology',
    domainNamePrimaryLinkUrl: 'riverbed.com',
    addressAddressCity: 'San Francisco',
    employees: 1874,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/riverbed-technology',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_213,
    name: 'Fast Enterprises, LLC',
    domainNamePrimaryLinkUrl: 'fastenterprises.com',
    addressAddressCity: 'Englewood',
    employees: 1833,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/fast-enterprises',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_214,
    name: 'Alvaria, Inc.',
    domainNamePrimaryLinkUrl: 'alvaria.com',
    addressAddressCity: 'Westford',
    employees: 1830,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/alvaria-inc',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_215,
    name: 'BlackLine',
    domainNamePrimaryLinkUrl: 'blackline.com',
    addressAddressCity: 'Woodland Hills',
    employees: 1826,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/blackline',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_216,
    name: '3Pillar Global',
    domainNamePrimaryLinkUrl: '3pillarglobal.com',
    addressAddressCity: 'Fairfax',
    employees: 1824,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/3pillar-global',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_217,
    name: 'Saama',
    domainNamePrimaryLinkUrl: 'saama.com',
    addressAddressCity: 'Campbell',
    employees: 1809,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/saama-technologies',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_218,
    name: 'Ancestry',
    domainNamePrimaryLinkUrl: 'ancestry.com',
    addressAddressCity: 'Lehi',
    employees: 1794,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ancestry.com',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_219,
    name: 'insightsoftware',
    domainNamePrimaryLinkUrl: 'insightsoftware.com',
    addressAddressCity: 'Raleigh',
    employees: 1788,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/outcomes-by-insightsoftware',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_220,
    name: 'Ebix',
    domainNamePrimaryLinkUrl: 'ebix.com',
    addressAddressCity: 'Duluth',
    employees: 1757,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ebix',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_221,
    name: 'Zuora',
    domainNamePrimaryLinkUrl: 'zuora.com',
    addressAddressCity: 'Redwood City',
    employees: 1746,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/zuora',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_222,
    name: 'IntelyCare',
    domainNamePrimaryLinkUrl: 'intelycare.com',
    addressAddressCity: 'Quincy',
    employees: 1731,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/intelycare',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_223,
    name: 'Axway',
    domainNamePrimaryLinkUrl: 'axway.com',
    addressAddressCity: 'Scottsdale',
    employees: 1731,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/axway',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_224,
    name: 'Community Brands',
    domainNamePrimaryLinkUrl: 'communitybrands.com',
    addressAddressCity: 'Saint Petersburg',
    employees: 1731,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/communitybrands',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_225,
    name: 'InterSystems',
    domainNamePrimaryLinkUrl: 'intersystems.com',
    addressAddressCity: 'Cambridge',
    employees: 1730,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/intersystems',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_226,
    name: 'Mozilla',
    domainNamePrimaryLinkUrl: 'mozilla.org',
    addressAddressCity: 'San Francisco',
    employees: 1721,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/mozilla-corporation',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_227,
    name: 'Semrush',
    domainNamePrimaryLinkUrl: 'semrush.com',
    addressAddressCity: 'Boston',
    employees: 1706,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/semrush',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_228,
    name: 'Avid',
    domainNamePrimaryLinkUrl: 'avid.com',
    addressAddressCity: 'Burlington',
    employees: 1705,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/avid-technology',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_229,
    name: 'Conga',
    domainNamePrimaryLinkUrl: 'conga.com',
    addressAddressCity: 'Broomfield',
    employees: 1695,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/conga',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_230,
    name: 'InfoBeans',
    domainNamePrimaryLinkUrl: 'infobeans.com',
    addressAddressCity: 'Danville',
    employees: 1691,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/infobeans',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_231,
    name: 'AppFolio, Inc.',
    domainNamePrimaryLinkUrl: 'appfolioinc.com',
    addressAddressCity: 'Goleta',
    employees: 1688,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/appfolio-inc',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_232,
    name: 'Sovos',
    domainNamePrimaryLinkUrl: 'sovos.com',
    addressAddressCity: 'Wilmington',
    employees: 1684,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sovos',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_233,
    name: 'nCino, Inc.',
    domainNamePrimaryLinkUrl: 'ncino.com',
    addressAddressCity: 'Wilmington',
    employees: 1680,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ncino-inc-',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_234,
    name: 'Vistex',
    domainNamePrimaryLinkUrl: 'vistex.com',
    addressAddressCity: 'Hoffman Estates',
    employees: 1677,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/vistex',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_235,
    name: 'Taboola',
    domainNamePrimaryLinkUrl: 'taboola.com',
    addressAddressCity: 'New York',
    employees: 1677,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/taboola',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_236,
    name: 'EverCommerce',
    domainNamePrimaryLinkUrl: 'evercommerce.com',
    addressAddressCity: 'Denver',
    employees: 1673,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/evercommerce',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_237,
    name: 'Virgin Pulse',
    domainNamePrimaryLinkUrl: 'virginpulse.com',
    addressAddressCity: 'Providence',
    employees: 1666,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/virgin-pulse',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_238,
    name: 'Houzz',
    domainNamePrimaryLinkUrl: 'houzz.com',
    addressAddressCity: 'Palo Alto',
    employees: 1641,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/houzz',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_239,
    name: 'AvidXchange, Inc.',
    domainNamePrimaryLinkUrl: 'avidxchange.com',
    addressAddressCity: 'Charlotte',
    employees: 1639,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/avidxchange-inc-',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_240,
    name: 'Planview, Inc.',
    domainNamePrimaryLinkUrl: 'planview.com',
    addressAddressCity: 'Austin',
    employees: 1634,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/planview',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_241,
    name: 'HackerRank',
    domainNamePrimaryLinkUrl: 'hackerrank.com',
    addressAddressCity: 'Mountain View',
    employees: 1632,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/hackerrank',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_242,
    name: 'Clearwater Analytics',
    domainNamePrimaryLinkUrl: 'clearwateranalytics.com',
    addressAddressCity: 'Boise',
    employees: 1615,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/clearwateranalytics',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_243,
    name: 'Outreach',
    domainNamePrimaryLinkUrl: 'outreach.io',
    addressAddressCity: 'Seattle',
    employees: 1612,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/outreach-saas',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_244,
    name: 'Everbridge',
    domainNamePrimaryLinkUrl: 'everbridge.com',
    addressAddressCity: 'Burlington',
    employees: 1607,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/everbridge',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_245,
    name: 'Zycus',
    domainNamePrimaryLinkUrl: 'zycus.com',
    addressAddressCity: 'Princeton',
    employees: 1604,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/zycus',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_246,
    name: 'Bullhorn',
    domainNamePrimaryLinkUrl: 'bullhorn.com',
    addressAddressCity: 'Boston',
    employees: 1604,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/bullhorn',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_247,
    name: 'LivePerson',
    domainNamePrimaryLinkUrl: 'liveperson.com',
    addressAddressCity: 'New York',
    employees: 1603,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/liveperson',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_248,
    name: 'Relativity',
    domainNamePrimaryLinkUrl: 'relativity.com',
    addressAddressCity: 'Chicago',
    employees: 1601,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/relativityhq',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_249,
    name: 'HealthEdge',
    domainNamePrimaryLinkUrl: 'healthedge.com',
    addressAddressCity: 'Burlington',
    employees: 1600,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/healthedge',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_250,
    name: 'QAD',
    domainNamePrimaryLinkUrl: 'qad.com',
    addressAddressCity: 'Santa Barbara',
    employees: 1598,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/qad',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_251,
    name: 'Braze',
    domainNamePrimaryLinkUrl: 'braze.com',
    addressAddressCity: 'New York',
    employees: 1598,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/braze-',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_252,
    name: 'Exadel',
    domainNamePrimaryLinkUrl: 'exadel.com',
    addressAddressCity: 'Walnut Creek',
    employees: 1592,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/exadel',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_253,
    name: 'Phenom',
    domainNamePrimaryLinkUrl: 'phenom.com',
    addressAddressCity: 'Ambler',
    employees: 1592,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/phenomtxm',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_254,
    name: 'Bazaarvoice',
    domainNamePrimaryLinkUrl: 'bazaarvoice.com',
    addressAddressCity: 'Austin',
    employees: 1587,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/bazaarvoice',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_255,
    name: 'AppDynamics',
    domainNamePrimaryLinkUrl: 'appdynamics.com',
    addressAddressCity: 'San Francisco',
    employees: 1553,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/appdynamics',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_256,
    name: 'Mitchell International',
    domainNamePrimaryLinkUrl: 'mitchell.com',
    addressAddressCity: 'San Diego',
    employees: 1548,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/mitchell-international',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_257,
    name: 'Talkdesk',
    domainNamePrimaryLinkUrl: 'talkdesk.com',
    addressAddressCity: 'San Francisco',
    employees: 1491,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/talkdesk',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_258,
    name: 'Hughes Systique Corporation (HSC)',
    domainNamePrimaryLinkUrl: 'hsc.com',
    addressAddressCity: 'Rockville',
    employees: 1481,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/hsc',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_259,
    name: 'Avature',
    domainNamePrimaryLinkUrl: 'avature.net',
    addressAddressCity: 'New York',
    employees: 1478,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/avature',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_260,
    name: 'Anyone Home Inc',
    domainNamePrimaryLinkUrl: 'anyonehome.com',
    addressAddressCity: 'Lake Forest',
    employees: 1476,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/anyone-home-inc',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_261,
    name: 'Engineer.ai',
    domainNamePrimaryLinkUrl: 'builder.ai',
    addressAddressCity: 'Venice',
    employees: 1474,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/engineer.ai',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_262,
    name: 'Apptio',
    domainNamePrimaryLinkUrl: 'apptio.com',
    addressAddressCity: 'Bellevue',
    employees: 1467,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/apptio',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_263,
    name: 'KMS Technology, Inc.',
    domainNamePrimaryLinkUrl: 'kms-technology.com',
    addressAddressCity: 'Atlanta',
    employees: 1464,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kms-technology',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_264,
    name: 'JFrog',
    domainNamePrimaryLinkUrl: 'jfrog.com',
    addressAddressCity: 'Sunnyvale',
    employees: 1459,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/jfrog-ltd',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_265,
    name: 'ASG Technologies',
    domainNamePrimaryLinkUrl: 'asg.com',
    addressAddressCity: 'Naples',
    employees: 1459,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/asg',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_266,
    name: 'Seismic',
    domainNamePrimaryLinkUrl: 'seismic.com',
    addressAddressCity: 'San Diego',
    employees: 1457,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/seismic',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_267,
    name: 'ModMed',
    domainNamePrimaryLinkUrl: 'modmed.com',
    addressAddressCity: 'Boca Raton',
    employees: 1452,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/modernizing-medicine',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_268,
    name: 'ACV Auctions',
    domainNamePrimaryLinkUrl: 'acvauctions.com',
    addressAddressCity: 'Buffalo',
    employees: 1450,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/acv-auctions',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_269,
    name: 'Cerence Inc.',
    domainNamePrimaryLinkUrl: 'cerence.com',
    addressAddressCity: 'Burlington',
    employees: 1448,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/cerence',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_270,
    name: 'Via',
    domainNamePrimaryLinkUrl: 'ridewithvia.com',
    addressAddressCity: 'New York',
    employees: 1446,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ridewithvia',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_271,
    name: 'Kingsoft',
    domainNamePrimaryLinkUrl: 'ksosoft.com',
    addressAddressCity: 'Palo Alto',
    employees: 1445,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kingsoft',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_272,
    name: 'Model N',
    domainNamePrimaryLinkUrl: 'modeln.com',
    addressAddressCity: 'San Mateo',
    employees: 1445,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/modeln',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_273,
    name: 'ThoughtSpot',
    domainNamePrimaryLinkUrl: 'thoughtspot.com',
    addressAddressCity: 'Mountain View',
    employees: 1436,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/thoughtspot',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_274,
    name: 'SSS',
    domainNamePrimaryLinkUrl: 'getebs.com',
    addressAddressCity: 'Littleton',
    employees: 1431,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/employee-based-software',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_275,
    name: 'BeyondTrust',
    domainNamePrimaryLinkUrl: 'beyondtrust.com',
    addressAddressCity: 'Duluth',
    employees: 1428,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/beyondtrust',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_276,
    name: 'MetricStream',
    domainNamePrimaryLinkUrl: 'metricstream.com',
    addressAddressCity: 'Alviso',
    employees: 1426,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/metricstream',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_277,
    name: 'LogMeIn',
    domainNamePrimaryLinkUrl: 'logmeininc.com',
    addressAddressCity: 'Boston',
    employees: 1425,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/logmein',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_278,
    name: 'Khoros',
    domainNamePrimaryLinkUrl: 'khoros.com',
    addressAddressCity: 'Austin',
    employees: 1424,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/khoros',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_279,
    name: 'Sprout Social, Inc.',
    domainNamePrimaryLinkUrl: 'sproutsocial.com',
    addressAddressCity: 'Chicago',
    employees: 1416,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/sprout-social-inc-',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_280,
    name: 'Odessa',
    domainNamePrimaryLinkUrl: 'odessainc.com',
    addressAddressCity: 'Philadelphia',
    employees: 1415,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/odessa-inc-',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_281,
    name: 'Enverus',
    domainNamePrimaryLinkUrl: 'enverus.com',
    addressAddressCity: 'Austin',
    employees: 1404,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/enverus-energy',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_282,
    name: 'AvePoint',
    domainNamePrimaryLinkUrl: 'avepoint.com',
    addressAddressCity: 'Jersey City',
    employees: 1404,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/avepoint',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_283,
    name: 'Gong',
    domainNamePrimaryLinkUrl: 'gong.io',
    addressAddressCity: 'San Francisco',
    employees: 1398,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/gong-io',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_284,
    name: 'Syncfusion',
    domainNamePrimaryLinkUrl: 'syncfusion.com',
    addressAddressCity: 'Morrisville',
    employees: 1397,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/syncfusion',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_285,
    name: 'Ping Identity',
    domainNamePrimaryLinkUrl: 'pingidentity.com',
    addressAddressCity: 'Denver',
    employees: 1388,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ping-identity',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_286,
    name: 'WellSky',
    domainNamePrimaryLinkUrl: 'wellsky.com',
    addressAddressCity: 'Overland Park',
    employees: 1387,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/wellsky',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_287,
    name: 'Tricentis',
    domainNamePrimaryLinkUrl: 'tricentis.com',
    addressAddressCity: 'Austin',
    employees: 1383,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tricentis',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_288,
    name: 'Taskrabbit',
    domainNamePrimaryLinkUrl: 'taskrabbit.com',
    addressAddressCity: 'San Francisco',
    employees: 1383,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/taskrabbit',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_289,
    name: 'Syniti',
    domainNamePrimaryLinkUrl: 'syniti.com',
    addressAddressCity: 'Needham Heights',
    employees: 1372,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/synitidata',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_290,
    name: 'BigCommerce',
    domainNamePrimaryLinkUrl: 'bigcommerce.com',
    addressAddressCity: 'Austin',
    employees: 1360,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/bigcommerce',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_291,
    name: 'OEC',
    domainNamePrimaryLinkUrl: 'oeconnection.com',
    addressAddressCity: 'Richfield',
    employees: 1357,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/oeconnection',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_292,
    name: 'Calsoft',
    domainNamePrimaryLinkUrl: 'calsoftinc.com',
    addressAddressCity: 'San Jose',
    employees: 1357,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/calsoft',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_293,
    name: 'Taller',
    domainNamePrimaryLinkUrl: 'tallertechnologies.com',
    addressAddressCity: 'San Francisco',
    employees: 1351,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/taller-technologies',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_294,
    name: 'Planet',
    domainNamePrimaryLinkUrl: 'planet.com',
    addressAddressCity: 'San Francisco',
    employees: 1348,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/planet-labs',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_295,
    name: '6sense',
    domainNamePrimaryLinkUrl: '6sense.com',
    addressAddressCity: 'San Francisco',
    employees: 1346,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/6sense',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_296,
    name: 'Vitech Systems Group',
    domainNamePrimaryLinkUrl: 'vitechinc.com',
    addressAddressCity: 'New York',
    employees: 1345,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/vitech-systems-group',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_297,
    name: 'Smarsh',
    domainNamePrimaryLinkUrl: 'smarsh.com',
    addressAddressCity: 'Portland',
    employees: 1344,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/smarsh',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_298,
    name: 'NICE Actimize',
    domainNamePrimaryLinkUrl: 'niceactimize.com',
    addressAddressCity: 'Hoboken',
    employees: 1343,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/actimize',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_299,
    name: 'Dataiku',
    domainNamePrimaryLinkUrl: 'dataiku.com',
    addressAddressCity: 'New York',
    employees: 1340,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/dataiku',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_300,
    name: 'Liferay',
    domainNamePrimaryLinkUrl: 'liferay.com',
    addressAddressCity: 'Diamond Bar',
    employees: 1329,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/liferay-inc-',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_301,
    name: 'Gainsight',
    domainNamePrimaryLinkUrl: 'gainsight.com',
    addressAddressCity: 'San Francisco',
    employees: 1328,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/gainsight',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_302,
    name: 'Infotech',
    domainNamePrimaryLinkUrl: 'infotechinc.com',
    addressAddressCity: 'Gainesville',
    employees: 1322,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/infotech-inc',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_303,
    name: 'JAGGAER',
    domainNamePrimaryLinkUrl: 'jaggaer.com',
    addressAddressCity: 'Morrisville',
    employees: 1317,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/jaggaer',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_304,
    name: 'Checkr, Inc.',
    domainNamePrimaryLinkUrl: 'checkr.com',
    addressAddressCity: 'San Francisco',
    employees: 1304,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/checkr-com',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_305,
    name: 'CARFAX',
    domainNamePrimaryLinkUrl: 'carfax.com',
    addressAddressCity: 'Centreville',
    employees: 1296,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/carfax',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_306,
    name: 'Lucid Software',
    domainNamePrimaryLinkUrl: 'lucid.co',
    addressAddressCity: 'South Jordan',
    employees: 1295,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/lucidsoftware',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_307,
    name: 'Domo',
    domainNamePrimaryLinkUrl: 'domo.com',
    addressAddressCity: 'American Fork',
    employees: 1293,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/domotalk',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_308,
    name: 'Podium',
    domainNamePrimaryLinkUrl: 'podium.com',
    addressAddressCity: 'Lehi',
    employees: 1292,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/podium',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_309,
    name: 'Mendix',
    domainNamePrimaryLinkUrl: 'mendix.com',
    addressAddressCity: 'Boston',
    employees: 1290,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mendix',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_310,
    name: 'EDB',
    domainNamePrimaryLinkUrl: 'edbpostgres.com',
    addressAddressCity: 'Bedford',
    employees: 1289,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/edbpostgres',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_311,
    name: 'OneStream Software',
    domainNamePrimaryLinkUrl: 'onestreamsoftware.com',
    addressAddressCity: 'Birmingham',
    employees: 1288,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/onestream-software',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_312,
    name: 'Rent.',
    domainNamePrimaryLinkUrl: 'rent.com',
    addressAddressCity: 'Atlanta',
    employees: 1285,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/rentsolutions',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_313,
    name: 'Waystar',
    domainNamePrimaryLinkUrl: 'waystar.com',
    addressAddressCity: 'Louisville',
    employees: 1273,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/waystar',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_314,
    name: '2020',
    domainNamePrimaryLinkUrl: '2020spaces.com',
    addressAddressCity: 'Westford',
    employees: 1267,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/2020spaces',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_315,
    name: 'isolved',
    domainNamePrimaryLinkUrl: 'isolvedhcm.com',
    addressAddressCity: 'Charlotte',
    employees: 1261,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/isolved',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_316,
    name: 'Art Technology Group',
    domainNamePrimaryLinkUrl: 'atg.com',
    addressAddressCity: 'Cambridge',
    employees: 1259,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/atg',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_317,
    name: 'CAST',
    domainNamePrimaryLinkUrl: 'castsoftware.com',
    addressAddressCity: 'New York',
    employees: 1259,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/cast',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_318,
    name: 'OCLC',
    domainNamePrimaryLinkUrl: 'oc.lc',
    addressAddressCity: 'Dublin',
    employees: 1258,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/oclc',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_319,
    name: 'Mediaocean',
    domainNamePrimaryLinkUrl: 'mediaocean.com',
    addressAddressCity: 'New York',
    employees: 1255,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mediaocean',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_320,
    name: 'Bandwidth Inc.',
    domainNamePrimaryLinkUrl: 'bandwidth.com',
    addressAddressCity: 'Raleigh',
    employees: 1252,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/bandwidth-inc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_321,
    name: 'Hexagon Safety, Infrastructure & Geospatial',
    domainNamePrimaryLinkUrl: 'hexagonsafetyinfrastructure.com',
    addressAddressCity: 'Madison',
    employees: 1252,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/hexagon-geospatial',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_322,
    name: 'Wish',
    domainNamePrimaryLinkUrl: 'wish.com',
    addressAddressCity: 'San Francisco',
    employees: 1248,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/wishshopping',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_323,
    name: 'Sagitec Solutions',
    domainNamePrimaryLinkUrl: 'sagitec.com',
    addressAddressCity: 'Saint Paul',
    employees: 1244,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/sagitec-solutions',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_324,
    name: 'Zinnia ',
    domainNamePrimaryLinkUrl: 'zinnia.com',
    addressAddressCity: 'Greenwich',
    employees: 1243,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/zinniatm',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_325,
    name: 'CureMD',
    domainNamePrimaryLinkUrl: 'curemd.com',
    addressAddressCity: 'New York',
    employees: 1243,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/curemd',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_326,
    name: 'Druva',
    domainNamePrimaryLinkUrl: 'druva.com',
    addressAddressCity: 'Santa Clara',
    employees: 1238,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/druva',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_327,
    name: 'Restaurant365',
    domainNamePrimaryLinkUrl: 'restaurant365.com',
    addressAddressCity: 'Irvine',
    employees: 1234,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/restaurant365-cloud-erp-for-restaurants',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_328,
    name: 'Lawson Software',
    domainNamePrimaryLinkUrl: 'lawson.com',
    addressAddressCity: 'New York',
    employees: 1231,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/lawson-software',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_329,
    name: 'AlphaSense',
    domainNamePrimaryLinkUrl: 'alpha-sense.com',
    addressAddressCity: 'New York',
    employees: 1223,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/alphasense',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_330,
    name: 'ECI Software Solutions',
    domainNamePrimaryLinkUrl: 'ecisolutions.com',
    addressAddressCity: 'Fort Worth',
    employees: 1223,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/eci-software--solutions',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_331,
    name: 'Wrike',
    domainNamePrimaryLinkUrl: 'wrike.com',
    addressAddressCity: 'San Diego',
    employees: 1210,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/wrike',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_332,
    name: 'Syndigo',
    domainNamePrimaryLinkUrl: 'syndigo.com',
    addressAddressCity: 'Chicago',
    employees: 1208,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/syndigo',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_333,
    name: 'Gigamon',
    domainNamePrimaryLinkUrl: 'gigamon.com',
    addressAddressCity: 'Santa Clara',
    employees: 1196,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/gigamon',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_334,
    name: 'Fastly',
    domainNamePrimaryLinkUrl: 'fastly.com',
    addressAddressCity: 'San Francisco',
    employees: 1188,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/fastly',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_335,
    name: 'Cantaloupe Inc',
    domainNamePrimaryLinkUrl: 'cantaloupe.com',
    addressAddressCity: 'Malvern',
    employees: 1187,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/cantaloupeinc',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_336,
    name: 'EagleView',
    domainNamePrimaryLinkUrl: 'eagleview.com',
    addressAddressCity: 'Bellevue',
    employees: 1184,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/eagleview-technologies-inc',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_337,
    name: 'Litera',
    domainNamePrimaryLinkUrl: 'litera.com',
    addressAddressCity: 'Chicago',
    employees: 1183,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/literamicrosystems',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_338,
    name: 'Collibra',
    domainNamePrimaryLinkUrl: 'collibra.com',
    addressAddressCity: 'New York',
    employees: 1183,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/collibra',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_339,
    name: 'Picsart',
    domainNamePrimaryLinkUrl: 'picsart.com',
    addressAddressCity: 'Miami Beach',
    employees: 1180,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/picsart-photo-studio',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_340,
    name: 'CalAmp',
    domainNamePrimaryLinkUrl: 'calamp.com',
    addressAddressCity: 'Irvine',
    employees: 1180,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/calamp-corp',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_341,
    name: 'ESS',
    domainNamePrimaryLinkUrl: 'ess-home.com',
    addressAddressCity: 'Tempe',
    employees: 1178,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ess',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_342,
    name: 'Grafana Labs',
    domainNamePrimaryLinkUrl: 'grafana.com',
    addressAddressCity: 'New York',
    employees: 1178,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/grafana-labs',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_343,
    name: 'Fivetran',
    domainNamePrimaryLinkUrl: '5tran.co',
    addressAddressCity: 'Oakland',
    employees: 1176,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/fivetran',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_344,
    name: 'CentralSquare Technologies',
    domainNamePrimaryLinkUrl: 'centralsquare.com',
    addressAddressCity: 'Lake Mary',
    employees: 1175,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/centralsqtech',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_345,
    name: 'StubHub',
    domainNamePrimaryLinkUrl: 'stubhub.com',
    addressAddressCity: 'New York',
    employees: 1164,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/stubhub',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_346,
    name: 'EIS Ltd',
    domainNamePrimaryLinkUrl: 'eisgroup.com',
    addressAddressCity: 'San Francisco',
    employees: 1154,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/eisgroupltd',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_347,
    name: 'Tebra',
    domainNamePrimaryLinkUrl: 'tebra.com',
    addressAddressCity: 'Corona Del Mar',
    employees: 1151,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tebra',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_348,
    name: 'Benefitfocus',
    domainNamePrimaryLinkUrl: 'benefitfocus.com',
    addressAddressCity: 'Charleston',
    employees: 1148,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/benefitfocus',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_349,
    name: 'NISC',
    domainNamePrimaryLinkUrl: 'nisc.coop',
    addressAddressCity: 'Lake Saint Louis',
    employees: 1140,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/nisc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_350,
    name: 'Dell Compellent',
    domainNamePrimaryLinkUrl: 'dell.com',
    addressAddressCity: 'Eden Prairie',
    employees: 1138,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/dell-compellent',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_351,
    name: 'Radancy',
    domainNamePrimaryLinkUrl: 'radancy.com',
    addressAddressCity: 'New York',
    employees: 1137,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/radancy',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_352,
    name: 'Granicus',
    domainNamePrimaryLinkUrl: 'granicus.com',
    addressAddressCity: 'Denver',
    employees: 1134,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/granicusinc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_353,
    name: 'ACTIVE Network',
    domainNamePrimaryLinkUrl: 'activenetwork.com',
    addressAddressCity: 'Plano',
    employees: 1134,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/the-active-network',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_354,
    name: 'Acquia',
    domainNamePrimaryLinkUrl: 'acquia.com',
    addressAddressCity: 'Boston',
    employees: 1134,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/acquia',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_355,
    name: 'WalkMe\u2122',
    domainNamePrimaryLinkUrl: 'walkme.com',
    addressAddressCity: 'San Francisco',
    employees: 1127,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/walkme',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_356,
    name: 'Outbrain',
    domainNamePrimaryLinkUrl: 'outbrain.com',
    addressAddressCity: 'New York',
    employees: 1123,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/outbrain',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_357,
    name: 'WillowTree',
    domainNamePrimaryLinkUrl: 'willowtreeapps.com',
    addressAddressCity: 'Charlottesville',
    employees: 1117,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/willowtreeapps',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_358,
    name: 'LogicMonitor',
    domainNamePrimaryLinkUrl: 'logicmonitor.com',
    addressAddressCity: 'Santa Barbara',
    employees: 1113,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/logicmonitor',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_359,
    name: 'Jellysmack',
    domainNamePrimaryLinkUrl: 'jellysmack.com',
    addressAddressCity: 'New York',
    employees: 1109,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/jellysmack',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_360,
    name: 'Henry Schein One',
    domainNamePrimaryLinkUrl: 'henryscheinone.com',
    addressAddressCity: 'American Fork',
    employees: 1108,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/henry-schein-one',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_361,
    name: 'Prometheus Group',
    domainNamePrimaryLinkUrl: 'prometheusgroup.com',
    addressAddressCity: 'Raleigh',
    employees: 1102,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/prometheusgroup',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_362,
    name: 'Atlas',
    domainNamePrimaryLinkUrl: 'atlashxm.com',
    addressAddressCity: 'Chicago',
    employees: 1101,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/atlashxm',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_363,
    name: 'Dialpad',
    domainNamePrimaryLinkUrl: 'dialpad.com',
    addressAddressCity: 'San Ramon',
    employees: 1101,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/dialpad',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_364,
    name: 'Accruent',
    domainNamePrimaryLinkUrl: 'accruent.com',
    addressAddressCity: 'Austin',
    employees: 1098,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/accruent',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_365,
    name: 'Charles River Development',
    domainNamePrimaryLinkUrl: 'crd.com',
    addressAddressCity: 'Burlington',
    employees: 1090,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/charles-river-development',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_366,
    name: 'Flexera',
    domainNamePrimaryLinkUrl: 'flexera.com',
    addressAddressCity: 'Itasca',
    employees: 1089,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/flexera',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_367,
    name: 'Quotient Technology Inc.',
    domainNamePrimaryLinkUrl: 'quotient.com',
    addressAddressCity: 'Salt Lake City',
    employees: 1087,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/quotient-technology',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_368,
    name: 'Sage Intacct, Inc.',
    domainNamePrimaryLinkUrl: 'sageintacct.com',
    addressAddressCity: 'San Jose',
    employees: 1087,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sageintacct',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_369,
    name: 'Plaid',
    domainNamePrimaryLinkUrl: 'plaid.com',
    addressAddressCity: 'San Francisco',
    employees: 1081,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/plaid-',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_370,
    name: 'C3 AI',
    domainNamePrimaryLinkUrl: 'c3.ai',
    addressAddressCity: 'Redwood City',
    employees: 1077,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/c3-ai',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_371,
    name: 'Upland Software',
    domainNamePrimaryLinkUrl: 'uplandsoftware.com',
    addressAddressCity: 'Austin',
    employees: 1072,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/upland-software',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_372,
    name: 'Zapier',
    domainNamePrimaryLinkUrl: 'zapier.com',
    addressAddressCity: 'San Francisco',
    employees: 1066,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/zapier',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_373,
    name: 'WSO2',
    domainNamePrimaryLinkUrl: 'wso2.com',
    addressAddressCity: 'Santa Clara',
    employees: 1065,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/wso2',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_374,
    name: 'Auctane',
    domainNamePrimaryLinkUrl: 'auctane.com',
    addressAddressCity: 'Austin',
    employees: 1055,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/auctane',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_375,
    name: 'Salesloft',
    domainNamePrimaryLinkUrl: 'salesloft.com',
    addressAddressCity: 'Atlanta',
    employees: 1055,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/salesloft',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_376,
    name: 'RLDatix',
    domainNamePrimaryLinkUrl: 'rldatix.com',
    addressAddressCity: 'Chicago',
    employees: 1048,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/rldatix',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_377,
    name: 'SS&C Blue Prism',
    domainNamePrimaryLinkUrl: 'blueprism.com',
    addressAddressCity: 'Windsor',
    employees: 1048,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/blue-prism-limited',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_378,
    name: 'Waitr',
    domainNamePrimaryLinkUrl: 'waitrapp.com',
    addressAddressCity: 'Lafayette',
    employees: 1043,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/waitr-inc-',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_379,
    name: 'Software Engineering Institute | Carnegie Mellon University',
    domainNamePrimaryLinkUrl: 'sei.cmu.edu',
    addressAddressCity: 'Pittsburgh',
    employees: 1043,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/software-engineering-institute',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_380,
    name: 'Downey Unified School District',
    domainNamePrimaryLinkUrl: 'dusd.net',
    addressAddressCity: 'Downey',
    employees: 1038,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/downey-unified-school-district',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_381,
    name: 'Private Access, Inc.',
    domainNamePrimaryLinkUrl: 'privateaccess.com',
    addressAddressCity: 'Irvine',
    employees: 1037,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/private-access-inc.',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_382,
    name: 'iManage',
    domainNamePrimaryLinkUrl: 'imanage.com',
    addressAddressCity: 'Chicago',
    employees: 1036,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/imanage',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_383,
    name: 'QASource',
    domainNamePrimaryLinkUrl: 'qasource.com',
    addressAddressCity: 'Pleasanton',
    employees: 1032,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/qasource',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_384,
    name: 'Azuga, Inc.',
    domainNamePrimaryLinkUrl: 'azuga.com',
    addressAddressCity: 'San Jose',
    employees: 1026,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/azuga-inc-',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_385,
    name: 'Talent Systems, LLC',
    domainNamePrimaryLinkUrl: 'talentsystems.com',
    addressAddressCity: 'Los Angeles',
    employees: 1022,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/talent-systems-llc',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_386,
    name: 'Datasite',
    domainNamePrimaryLinkUrl: 'datasite.com',
    addressAddressCity: 'Minneapolis',
    employees: 1021,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/datasiteglobal',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_387,
    name: 'AVASOFT',
    domainNamePrimaryLinkUrl: 'avasoft.com',
    addressAddressCity: 'Blue Bell',
    employees: 1017,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/avasoft',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_388,
    name: 'DataRobot',
    domainNamePrimaryLinkUrl: 'datarobot.com',
    addressAddressCity: 'Boston',
    employees: 1015,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/datarobot',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_389,
    name: 'Technisys',
    domainNamePrimaryLinkUrl: 'technisys.com',
    addressAddressCity: 'Miami',
    employees: 1014,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/technisys',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_390,
    name: 'project44',
    domainNamePrimaryLinkUrl: 'project44.com',
    addressAddressCity: 'Chicago',
    employees: 1013,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/project-44',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_391,
    name: 'Imprivata',
    domainNamePrimaryLinkUrl: 'imprivata.com',
    addressAddressCity: 'Waltham',
    employees: 1013,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/imprivata',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_392,
    name: 'Webflow',
    domainNamePrimaryLinkUrl: 'webflow.com',
    addressAddressCity: 'San Francisco',
    employees: 1011,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/webflow-inc-',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_393,
    name: 'Blend',
    domainNamePrimaryLinkUrl: 'blend.com',
    addressAddressCity: 'San Francisco',
    employees: 1011,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/blend-',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_394,
    name: 'Egnyte',
    domainNamePrimaryLinkUrl: 'egnyte.com',
    addressAddressCity: 'Mountain View',
    employees: 1009,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/egnyte',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_395,
    name: 'SS&C Eze',
    domainNamePrimaryLinkUrl: 'ezesoft.com',
    addressAddressCity: 'Windsor',
    employees: 1008,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ezesoftware',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_396,
    name: 'Tipalti',
    domainNamePrimaryLinkUrl: 'tipalti.com',
    addressAddressCity: 'San Mateo',
    employees: 1007,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tipalti',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_397,
    name: 'Altium\u00ae',
    domainNamePrimaryLinkUrl: 'altium.com',
    addressAddressCity: 'La Jolla',
    employees: 1005,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/altium',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_398,
    name: 'airSlate',
    domainNamePrimaryLinkUrl: 'airslate.com',
    addressAddressCity: 'Brookline',
    employees: 1001,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/airslate',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_399,
    name: 'Arbisoft',
    domainNamePrimaryLinkUrl: 'arbisoft.com',
    addressAddressCity: 'Mckinney',
    employees: 996,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/arbisoft',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_400,
    name: 'Airtable',
    domainNamePrimaryLinkUrl: 'airtable.com',
    addressAddressCity: 'San Francisco',
    employees: 989,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/airtable',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_401,
    name: 'Birdeye',
    domainNamePrimaryLinkUrl: 'birdeye.com',
    addressAddressCity: 'Palo Alto',
    employees: 988,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/birdeye',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_402,
    name: 'Ultimate Software',
    domainNamePrimaryLinkUrl: 'ultimatesoftware.com',
    addressAddressCity: 'Fort Lauderdale',
    employees: 988,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/ultimate-software',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_403,
    name: 'Homecare Homebase',
    domainNamePrimaryLinkUrl: 'hchb.com',
    addressAddressCity: 'Dallas',
    employees: 987,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/homecare-homebase',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_404,
    name: 'DISCO',
    domainNamePrimaryLinkUrl: 'csdisco.com',
    addressAddressCity: 'Austin',
    employees: 984,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/cs-disco-llc',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_405,
    name: 'Highspot',
    domainNamePrimaryLinkUrl: 'highspot.com',
    addressAddressCity: 'Seattle',
    employees: 982,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/highspot',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_406,
    name: 'Sagent',
    domainNamePrimaryLinkUrl: 'sagent.com',
    addressAddressCity: 'King Of Prussia',
    employees: 981,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/sagent-lending-technologies',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_407,
    name: 'Apollo.io',
    domainNamePrimaryLinkUrl: 'apollo.io',
    addressAddressCity: 'San Francisco',
    employees: 981,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/apolloio',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_408,
    name: 'PAS',
    domainNamePrimaryLinkUrl: 'pas.com',
    addressAddressCity: 'Houston',
    employees: 981,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pas',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_409,
    name: 'Wikimedia Foundation',
    domainNamePrimaryLinkUrl: 'wikimediafoundation.org',
    addressAddressCity: 'San Francisco',
    employees: 981,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/wikimedia-foundation',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_410,
    name: 'Nintex',
    domainNamePrimaryLinkUrl: 'nintex.com',
    addressAddressCity: 'Bellevue',
    employees: 978,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/nintex',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_411,
    name: 'RUCKUS Networks',
    domainNamePrimaryLinkUrl: 'commscope.com',
    addressAddressCity: 'Sunnyvale',
    employees: 978,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ruckus-networks',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_412,
    name: 'ForgeRock',
    domainNamePrimaryLinkUrl: 'forgerock.com',
    addressAddressCity: 'San Francisco',
    employees: 977,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/forgerock',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_413,
    name: 'Trading Technologies',
    domainNamePrimaryLinkUrl: 'tradingtechnologies.com',
    addressAddressCity: 'Chicago',
    employees: 975,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/trading-technologies',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_414,
    name: 'KANINI',
    domainNamePrimaryLinkUrl: 'kanini.com',
    addressAddressCity: 'Nashville',
    employees: 972,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kanini',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_415,
    name: 'Dealer.com',
    domainNamePrimaryLinkUrl: 'dealer.com',
    addressAddressCity: 'Burlington',
    employees: 962,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/dealer-com',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_416,
    name: 'WS',
    domainNamePrimaryLinkUrl: 'ws-inc.com',
    addressAddressCity: 'Pinehurst',
    employees: 960,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/wbem-solutions',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_417,
    name: 'Kyriba',
    domainNamePrimaryLinkUrl: 'kyriba.com',
    addressAddressCity: 'San Diego',
    employees: 960,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kyriba',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_418,
    name: 'Demandbase',
    domainNamePrimaryLinkUrl: 'demandbase.com',
    addressAddressCity: 'San Francisco',
    employees: 958,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/demandbase',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_419,
    name: 'Sumo Logic',
    domainNamePrimaryLinkUrl: 'sumologic.com',
    addressAddressCity: 'Redwood City',
    employees: 954,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sumo-logic',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_420,
    name: 'Edifecs',
    domainNamePrimaryLinkUrl: 'edifecs.com',
    addressAddressCity: 'Bellevue',
    employees: 949,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/edifecs',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_421,
    name: 'ibi | Information Builders',
    domainNamePrimaryLinkUrl: 'ibi.com',
    addressAddressCity: 'Fort Lauderdale',
    employees: 948,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/information-builders',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_422,
    name: 'Emburse',
    domainNamePrimaryLinkUrl: 'emburse.com',
    addressAddressCity: 'Los Angeles',
    employees: 941,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/emburse',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_423,
    name: 'ConstructConnect',
    domainNamePrimaryLinkUrl: 'constructconnect.com',
    addressAddressCity: 'Cincinnati',
    employees: 940,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/constructconnect',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_424,
    name: 'Perforce Software',
    domainNamePrimaryLinkUrl: 'perforce.com',
    addressAddressCity: 'Minneapolis',
    employees: 939,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/perforce',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_425,
    name: 'Insurity',
    domainNamePrimaryLinkUrl: 'insurity.com',
    addressAddressCity: 'Hartford',
    employees: 938,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/insurity',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_426,
    name: 'webOS',
    domainNamePrimaryLinkUrl: 'developer.lge.com',
    addressAddressCity: 'Santa Clara',
    employees: 936,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/webos',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_427,
    name: 'Zenoti',
    domainNamePrimaryLinkUrl: 'zenoti.com',
    addressAddressCity: 'Bellevue',
    employees: 934,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/zenoti',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_428,
    name: 'Intapp',
    domainNamePrimaryLinkUrl: 'intapp.com',
    addressAddressCity: 'Palo Alto',
    employees: 930,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/intapp',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_429,
    name: 'OATI',
    domainNamePrimaryLinkUrl: 'oati.com',
    addressAddressCity: 'Minneapolis',
    employees: 930,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/oati',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_430,
    name: 'Frontline Education',
    domainNamePrimaryLinkUrl: 'frontlineeducation.com',
    addressAddressCity: 'Malvern',
    employees: 926,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/frontline-education',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_431,
    name: 'Aspect Software',
    domainNamePrimaryLinkUrl: 'aspect.com',
    addressAddressCity: 'Westford',
    employees: 920,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aspect-software',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_432,
    name: 'GreyOrange',
    domainNamePrimaryLinkUrl: 'greyorange.com',
    addressAddressCity: 'Roswell',
    employees: 919,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/gogreyorange',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_433,
    name: 'Sirion',
    domainNamePrimaryLinkUrl: 'sirionlabs.com',
    addressAddressCity: 'Bellevue',
    employees: 918,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sirionlabs',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_434,
    name: 'In Time Tec',
    domainNamePrimaryLinkUrl: 'intimetec.com',
    addressAddressCity: 'Meridian',
    employees: 917,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/in-time-tec',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_435,
    name: 'Operative',
    domainNamePrimaryLinkUrl: 'operative.com',
    addressAddressCity: 'New York',
    employees: 910,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/operative',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_436,
    name: 'Kore.ai',
    domainNamePrimaryLinkUrl: 'kore.ai',
    addressAddressCity: 'Orlando',
    employees: 908,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kore-inc',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_437,
    name: 'Redis',
    domainNamePrimaryLinkUrl: 'redis.com',
    addressAddressCity: 'Mountain View',
    employees: 908,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/redisinc',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_438,
    name: 'Addepar',
    domainNamePrimaryLinkUrl: 'addepar.com',
    addressAddressCity: 'Mountain View',
    employees: 907,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/addepar',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_439,
    name: 'TCP Software',
    domainNamePrimaryLinkUrl: 'tcpsoftware.com',
    addressAddressCity: 'Austin',
    employees: 902,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tcpsoftware',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_440,
    name: 'TraceLink',
    domainNamePrimaryLinkUrl: 'tracelink.com',
    addressAddressCity: 'Wilmington',
    employees: 897,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tracelink',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_441,
    name: 'Benchling',
    domainNamePrimaryLinkUrl: 'benchling.com',
    addressAddressCity: 'San Francisco',
    employees: 895,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/benchling',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_442,
    name: 'Housecall Pro',
    domainNamePrimaryLinkUrl: 'housecallpro.com',
    addressAddressCity: 'Denver',
    employees: 894,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/housecallpro',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_443,
    name: 'Turnitin',
    domainNamePrimaryLinkUrl: 'turnitin.com',
    addressAddressCity: 'Oakland',
    employees: 885,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/turnitin',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_444,
    name: 'Schr\u00f6dinger',
    domainNamePrimaryLinkUrl: 'schrodinger.com',
    addressAddressCity: 'New York',
    employees: 885,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/schr-dinger',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_445,
    name: 'eGain Corporation',
    domainNamePrimaryLinkUrl: 'egain.com',
    addressAddressCity: 'Sunnyvale',
    employees: 879,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/egain-corporation',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_446,
    name: 'Brightly',
    domainNamePrimaryLinkUrl: 'brightlysoftware.com',
    addressAddressCity: 'Cary',
    employees: 878,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/brightlysoftware',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_447,
    name: 'Snap-on Business Solutions',
    domainNamePrimaryLinkUrl: 'snapon.com',
    addressAddressCity: 'Richfield',
    employees: 876,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/snap-on-business-solutions',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_448,
    name: 'ACS Technologies',
    domainNamePrimaryLinkUrl: 'acstechnologies.com',
    addressAddressCity: 'Florence',
    employees: 874,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/acs-technologies',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_449,
    name: 'Uniphore',
    domainNamePrimaryLinkUrl: 'uniphore.com',
    addressAddressCity: 'Palo Alto',
    employees: 872,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/uniphore',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_450,
    name: 'Folio3 Software',
    domainNamePrimaryLinkUrl: 'folio3.com',
    addressAddressCity: 'Belmont',
    employees: 872,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/folio3',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_451,
    name: 'MHC',
    domainNamePrimaryLinkUrl: 'mhcautomation.com',
    addressAddressCity: 'Burnsville',
    employees: 871,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mhcautomation',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_452,
    name: 'Xactly Corp',
    domainNamePrimaryLinkUrl: 'xactlycorp.com',
    addressAddressCity: 'Los Gatos',
    employees: 865,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/xactly-corporation',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_453,
    name: 'Weave',
    domainNamePrimaryLinkUrl: 'getweave.com',
    addressAddressCity: 'Lehi',
    employees: 864,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/getweave',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_454,
    name: 'Microworkers',
    domainNamePrimaryLinkUrl: 'microworkers.com',
    addressAddressCity: 'Frisco',
    employees: 862,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/microworkers.com',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_455,
    name: 'Trilogy',
    domainNamePrimaryLinkUrl: 'trilogy.com',
    addressAddressCity: 'Austin',
    employees: 861,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/trilogy',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_456,
    name: 'Akvelon, Inc.',
    domainNamePrimaryLinkUrl: 'akvelon.com',
    addressAddressCity: 'Bellevue',
    employees: 860,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/akvelon',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_457,
    name: 'iPipeline',
    domainNamePrimaryLinkUrl: 'ipipeline.com',
    addressAddressCity: 'Exton',
    employees: 856,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ipipeline',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_458,
    name: 'Salary.com',
    domainNamePrimaryLinkUrl: 'salary.com',
    addressAddressCity: 'Wellesley Hills',
    employees: 854,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/salarydotcom',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_459,
    name: 'PandaDoc',
    domainNamePrimaryLinkUrl: 'pandadoc.com',
    addressAddressCity: 'San Francisco',
    employees: 851,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pandadoc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_460,
    name: 'MSC Software',
    domainNamePrimaryLinkUrl: 'mscsoftware.com',
    addressAddressCity: 'Newport Beach',
    employees: 849,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/msc-software',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_461,
    name: 'Harness',
    domainNamePrimaryLinkUrl: 'harness.io',
    addressAddressCity: 'San Francisco',
    employees: 848,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/harnessinc',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_462,
    name: 'ActiveCampaign',
    domainNamePrimaryLinkUrl: 'activecampaign.com',
    addressAddressCity: 'Chicago',
    employees: 848,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/activecampaign-inc-',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_463,
    name: 'Doximity',
    domainNamePrimaryLinkUrl: 'doximity.com',
    addressAddressCity: 'San Francisco',
    employees: 848,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/doximity',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_464,
    name: 'Couchbase',
    domainNamePrimaryLinkUrl: 'couchbase.com',
    addressAddressCity: 'Santa Clara',
    employees: 847,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/couchbase',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_465,
    name: 'Lytx, Inc.',
    domainNamePrimaryLinkUrl: 'lytx.com',
    addressAddressCity: 'San Diego',
    employees: 845,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/lytxinc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_466,
    name: 'Pendo.io',
    domainNamePrimaryLinkUrl: 'pendo.io',
    addressAddressCity: 'Raleigh',
    employees: 844,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pendo-io',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_467,
    name: 'Workato',
    domainNamePrimaryLinkUrl: 'workato.com',
    addressAddressCity: 'Mountain View',
    employees: 842,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/workato',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_468,
    name: 'Saviynt',
    domainNamePrimaryLinkUrl: 'saviynt.com',
    addressAddressCity: 'El Segundo',
    employees: 842,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/saviynt',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_469,
    name: 'SmartBear',
    domainNamePrimaryLinkUrl: 'smartbear.com',
    addressAddressCity: 'Somerville',
    employees: 838,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/smartbear',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_470,
    name: 'Rovi Corporation (now TiVo)',
    domainNamePrimaryLinkUrl: 'tivo.com',
    addressAddressCity: 'San Carlos',
    employees: 837,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/rovi',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_471,
    name: 'Handshake',
    domainNamePrimaryLinkUrl: 'joinhandshake.com',
    addressAddressCity: 'San Francisco',
    employees: 833,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/team-handshake',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_472,
    name: 'Navitaire, an Amadeus company',
    domainNamePrimaryLinkUrl: 'navitaire.com',
    addressAddressCity: 'Minneapolis',
    employees: 829,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/navitaire',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_473,
    name: 'OneSpan',
    domainNamePrimaryLinkUrl: 'onespan.com',
    addressAddressCity: 'Chicago',
    employees: 826,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/onespan',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_474,
    name: 'Bitsight',
    domainNamePrimaryLinkUrl: 'bitsight.com',
    addressAddressCity: 'Boston',
    employees: 824,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/bitsight',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_475,
    name: 'ID.me',
    domainNamePrimaryLinkUrl: 'id.me',
    addressAddressCity: 'Mc Lean',
    employees: 823,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/id.me',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_476,
    name: 'SymphonyAI Retail CPG',
    domainNamePrimaryLinkUrl: 'symphonyretailai.com',
    addressAddressCity: 'Frisco',
    employees: 823,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/symphonyretailcpg',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_477,
    name: 'Unilog',
    domainNamePrimaryLinkUrl: 'unilogcorp.com',
    addressAddressCity: 'Wayne',
    employees: 823,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/unilog-inc',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_478,
    name: 'Teletrac Navman',
    domainNamePrimaryLinkUrl: 'teletracnavman.com',
    addressAddressCity: 'Irvine',
    employees: 821,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/teletrac',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_479,
    name: 'Buildertrend',
    domainNamePrimaryLinkUrl: 'buildertrend.com',
    addressAddressCity: 'Omaha',
    employees: 819,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/buildertrend',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_480,
    name: 'Tecsys Inc.',
    domainNamePrimaryLinkUrl: 'tecsys.com',
    addressAddressCity: 'Chicago',
    employees: 816,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tecsys-inc',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_481,
    name: 'ThousandEyes (part of Cisco)',
    domainNamePrimaryLinkUrl: 'thousandeyes.com',
    addressAddressCity: 'San Francisco',
    employees: 816,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/thousandeyes',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_482,
    name: 'Greenhouse Software',
    domainNamePrimaryLinkUrl: 'greenhouse.io',
    addressAddressCity: 'New York',
    employees: 814,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/greenhouse-inc-',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_483,
    name: 'Exiger',
    domainNamePrimaryLinkUrl: 'exiger.com',
    addressAddressCity: 'New York',
    employees: 811,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/exiger',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_484,
    name: 'MBO Partners',
    domainNamePrimaryLinkUrl: 'mbopartners.com',
    addressAddressCity: 'Ashburn',
    employees: 808,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mbo-partners',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_485,
    name: 'Neo4j',
    domainNamePrimaryLinkUrl: 'neo4j.com',
    addressAddressCity: 'San Mateo',
    employees: 808,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/neo4j',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_486,
    name: 'VTS',
    domainNamePrimaryLinkUrl: 'vts.com',
    addressAddressCity: 'New York',
    employees: 805,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/we-are-vts',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_487,
    name: 'Slice',
    domainNamePrimaryLinkUrl: 'slicelife.com',
    addressAddressCity: 'New York',
    employees: 805,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/slice',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_488,
    name: 'Amplitude',
    domainNamePrimaryLinkUrl: 'amplitude.com',
    addressAddressCity: 'San Francisco',
    employees: 803,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/amplitude-analytics',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_489,
    name: 'Daxko',
    domainNamePrimaryLinkUrl: 'daxko.com',
    addressAddressCity: 'Birmingham',
    employees: 802,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/daxko',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_490,
    name: 'AppLovin',
    domainNamePrimaryLinkUrl: 'applovin.com',
    addressAddressCity: 'Palo Alto',
    employees: 802,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/applovin',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_491,
    name: 'Xometry',
    domainNamePrimaryLinkUrl: 'xometry.com',
    addressAddressCity: 'Rockville',
    employees: 801,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/xometry',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_492,
    name: 'Quickbase',
    domainNamePrimaryLinkUrl: 'quickbase.com',
    addressAddressCity: 'Boston',
    employees: 796,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/quickbase',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_493,
    name: 'Agora',
    domainNamePrimaryLinkUrl: 'agora.io',
    addressAddressCity: 'Santa Clara',
    employees: 793,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/agora-lab-inc',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_494,
    name: 'InMoment',
    domainNamePrimaryLinkUrl: 'inmoment.com',
    addressAddressCity: 'South Jordan',
    employees: 793,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/weareinmoment',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_495,
    name: 'PatientPoint\u00ae',
    domainNamePrimaryLinkUrl: 'patientpoint.com',
    addressAddressCity: 'Cincinnati',
    employees: 789,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/patientpoint',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_496,
    name: 'HHAeXchange',
    domainNamePrimaryLinkUrl: 'hhaexchange.com',
    addressAddressCity: 'New York',
    employees: 788,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/hhaexchange',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_497,
    name: 'NinjaOne',
    domainNamePrimaryLinkUrl: 'ninjaone.com',
    addressAddressCity: 'Austin',
    employees: 787,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ninjaone',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_498,
    name: 'Zywave',
    domainNamePrimaryLinkUrl: 'zywave.com',
    addressAddressCity: 'Milwaukee',
    employees: 785,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/zywave',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_499,
    name: 'Adobe Marketo',
    domainNamePrimaryLinkUrl: 'marketo.com',
    addressAddressCity: 'San Jose',
    employees: 784,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/adobemarketoengage',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_500,
    name: 'MasterControl',
    domainNamePrimaryLinkUrl: 'mastercontrol.com',
    addressAddressCity: 'Salt Lake City',
    employees: 783,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mastercontrol',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_501,
    name: 'Jumio Corporation',
    domainNamePrimaryLinkUrl: 'jumio.com',
    addressAddressCity: 'Sunnyvale',
    employees: 779,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/jumio-corporation',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_502,
    name: 'CRMNEXT',
    domainNamePrimaryLinkUrl: 'crmnext.com',
    addressAddressCity: 'Raleigh',
    employees: 778,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/crmnext',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_503,
    name: 'ChannelAdvisor',
    domainNamePrimaryLinkUrl: 'channeladvisor.com',
    addressAddressCity: 'Morrisville',
    employees: 777,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/channeladvisor',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_504,
    name: 'SumTotal Systems, LLC',
    domainNamePrimaryLinkUrl: 'sumtotalsystems.com',
    addressAddressCity: 'Gainesville',
    employees: 776,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sumtotal-systems',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_505,
    name: 'Payscale',
    domainNamePrimaryLinkUrl: 'payscale.com',
    addressAddressCity: 'Seattle',
    employees: 775,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/payscale',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_506,
    name: 'Riskonnect, Inc.',
    domainNamePrimaryLinkUrl: 'riskonnect.com',
    addressAddressCity: 'Kennesaw',
    employees: 775,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/riskonnect-inc',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_507,
    name: 'Riskified',
    domainNamePrimaryLinkUrl: 'riskified.com',
    addressAddressCity: 'New York',
    employees: 770,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/riskified',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_508,
    name: 'Shopkeeper',
    domainNamePrimaryLinkUrl: 'shopkeeper.com',
    addressAddressCity: 'Pompano Beach',
    employees: 770,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/shopkeeperapp',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_509,
    name: 'Stack Overflow',
    domainNamePrimaryLinkUrl: 'stackoverflow.com',
    addressAddressCity: 'New York',
    employees: 768,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/stack-overflow',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_510,
    name: 'Netwrix Corporation',
    domainNamePrimaryLinkUrl: 'netwrix.com',
    addressAddressCity: 'Frisco',
    employees: 768,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/netwrix-corporation',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_511,
    name: 'Securonix',
    domainNamePrimaryLinkUrl: 'securonix.com',
    addressAddressCity: 'Addison',
    employees: 767,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/securonix',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_512,
    name: 'Draup',
    domainNamePrimaryLinkUrl: 'draup.com',
    addressAddressCity: 'Spring',
    employees: 766,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/draupplatform',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_513,
    name: 'eQ Technologic',
    domainNamePrimaryLinkUrl: '1eq.com',
    addressAddressCity: 'Costa Mesa',
    employees: 766,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/eq-technologic',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_514,
    name: 'Mindtickle',
    domainNamePrimaryLinkUrl: 'mindtickle.com',
    addressAddressCity: 'San Francisco',
    employees: 765,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mindtickle',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_515,
    name: 'Omnitracs',
    domainNamePrimaryLinkUrl: 'omnitracs.com',
    addressAddressCity: 'Roanoke',
    employees: 764,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/omnitracs',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_516,
    name: 'Programmer',
    domainNamePrimaryLinkUrl: 'gregoryleroy.com',
    addressAddressCity: 'Austin',
    employees: 762,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/programmer',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_517,
    name: 'Navis',
    domainNamePrimaryLinkUrl: 'navis.com',
    addressAddressCity: 'Alpharetta',
    employees: 761,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/navis',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_518,
    name: 'AuditBoard',
    domainNamePrimaryLinkUrl: 'auditboard.com',
    addressAddressCity: 'Cerritos',
    employees: 759,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/auditboard',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_519,
    name: 'Algolia',
    domainNamePrimaryLinkUrl: 'algolia.com',
    addressAddressCity: 'San Francisco',
    employees: 759,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/algolia',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_520,
    name: 'YML',
    domainNamePrimaryLinkUrl: 'yml.co',
    addressAddressCity: 'Redwood City',
    employees: 754,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ymlco',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_521,
    name: 'Bolt',
    domainNamePrimaryLinkUrl: 'bolt.com',
    addressAddressCity: 'San Francisco',
    employees: 750,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/bolt-com',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_522,
    name: 'Dandy',
    domainNamePrimaryLinkUrl: 'meetdandy.com',
    addressAddressCity: 'New York',
    employees: 745,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/dandyofficial',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_523,
    name: 'Diverse Lynx',
    domainNamePrimaryLinkUrl: 'diverselynx.com',
    addressAddressCity: 'Princeton',
    employees: 743,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/diverselynx',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_524,
    name: 'JMP',
    domainNamePrimaryLinkUrl: 'jmp.com',
    addressAddressCity: 'Cary',
    employees: 741,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/jmp',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_525,
    name: 'ON24',
    domainNamePrimaryLinkUrl: 'on24.com',
    addressAddressCity: 'San Francisco',
    employees: 741,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/on24',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_526,
    name: 'LabVantage Solutions, Inc',
    domainNamePrimaryLinkUrl: 'labvantage.com',
    addressAddressCity: 'Somerset',
    employees: 740,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/labvantage',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_527,
    name: 'Exabeam',
    domainNamePrimaryLinkUrl: 'exabeam.com',
    addressAddressCity: 'San Mateo',
    employees: 739,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/exabeam',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_528,
    name: 'Iterable',
    domainNamePrimaryLinkUrl: 'iterable.com',
    addressAddressCity: 'San Francisco',
    employees: 739,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/iterable',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_529,
    name: 'Clari',
    domainNamePrimaryLinkUrl: 'clari.com',
    addressAddressCity: 'Sunnyvale',
    employees: 737,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/clari',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_530,
    name: 'Komodo Health',
    domainNamePrimaryLinkUrl: 'komodohealth.com',
    addressAddressCity: 'San Francisco',
    employees: 737,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/komodo-health',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_531,
    name: 'Alation',
    domainNamePrimaryLinkUrl: 'alation.com',
    addressAddressCity: 'Redwood City',
    employees: 736,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/alation',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_532,
    name: 'Celigo',
    domainNamePrimaryLinkUrl: 'celigo.com',
    addressAddressCity: 'Redwood City',
    employees: 733,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/celigo-inc',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_533,
    name: 'Aptos Retail',
    domainNamePrimaryLinkUrl: 'aptos.com',
    addressAddressCity: 'Alpharetta',
    employees: 733,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aptos-retail',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_534,
    name: 'WorkForce Software',
    domainNamePrimaryLinkUrl: 'workforcesoftware.com',
    addressAddressCity: 'Livonia',
    employees: 721,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/workforce-software',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_535,
    name: 'HPE Security - Data Security',
    domainNamePrimaryLinkUrl: 'voltage.com',
    addressAddressCity: 'Sunnyvale',
    employees: 713,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/hpe-security-data-security',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_536,
    name: 'DDN Storage',
    domainNamePrimaryLinkUrl: 'ddn.com',
    addressAddressCity: 'Chatsworth',
    employees: 712,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ddn-storage',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_537,
    name: 'KPA',
    domainNamePrimaryLinkUrl: 'kpa.io',
    addressAddressCity: 'Broomfield',
    employees: 709,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/kpa-llc',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_538,
    name: 'Lohika',
    domainNamePrimaryLinkUrl: 'lohika.com',
    addressAddressCity: 'San Mateo',
    employees: 705,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/lohika',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_539,
    name: 'Qualifacts',
    domainNamePrimaryLinkUrl: 'qualifacts.com',
    addressAddressCity: 'Nashville',
    employees: 705,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/qualifacts',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_540,
    name: 'Centric Software',
    domainNamePrimaryLinkUrl: 'centricsoftware.com',
    addressAddressCity: 'Campbell',
    employees: 705,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/centric-software',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_541,
    name: 'Omdena',
    domainNamePrimaryLinkUrl: 'omdena.com',
    addressAddressCity: 'New York',
    employees: 704,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/omdena',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_542,
    name: 'AccountantsWorld',
    domainNamePrimaryLinkUrl: 'accountantsworld.com',
    addressAddressCity: 'Hauppauge',
    employees: 704,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/accountantsworld',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_543,
    name: 'Aderant',
    domainNamePrimaryLinkUrl: 'aderant.com',
    addressAddressCity: 'Atlanta',
    employees: 704,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aderant',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_544,
    name: 'Python Software Foundation',
    domainNamePrimaryLinkUrl: 'python.org',
    addressAddressCity: 'Beaverton',
    employees: 704,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/python-software-foundation',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_545,
    name: 'OpenGov Inc.',
    domainNamePrimaryLinkUrl: 'opengov.com',
    addressAddressCity: 'San Jose',
    employees: 703,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/opengov-inc',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_546,
    name: 'Denodo',
    domainNamePrimaryLinkUrl: 'denodo.com',
    addressAddressCity: 'Palo Alto',
    employees: 702,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/denodo-technologies',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_547,
    name: 'NEOGOV',
    domainNamePrimaryLinkUrl: 'neogov.com',
    addressAddressCity: 'El Segundo',
    employees: 698,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/neogov',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_548,
    name: 'VertexOne',
    domainNamePrimaryLinkUrl: 'vertexone.net',
    addressAddressCity: 'Dallas',
    employees: 696,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/vertex-one',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_549,
    name: 'The Linux Foundation',
    domainNamePrimaryLinkUrl: 'linuxfoundation.org',
    addressAddressCity: 'San Francisco',
    employees: 694,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/the-linux-foundation',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_550,
    name: 'Reputation',
    domainNamePrimaryLinkUrl: 'reputation.com',
    addressAddressCity: 'San Ramon',
    employees: 694,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/reputation-com',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_551,
    name: 'Relevantz ',
    domainNamePrimaryLinkUrl: 'relevantz.com',
    addressAddressCity: 'Alpharetta',
    employees: 691,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/relevantz',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_552,
    name: 'M-Files',
    domainNamePrimaryLinkUrl: 'm-files.com',
    addressAddressCity: 'Austin',
    employees: 691,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/m-files-corporation',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_553,
    name: 'Homebase',
    domainNamePrimaryLinkUrl: 'joinhomebase.com',
    addressAddressCity: 'San Francisco',
    employees: 688,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/homebase-app',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_554,
    name: 'Calypso Technology',
    domainNamePrimaryLinkUrl: 'calypso.com',
    addressAddressCity: 'San Francisco',
    employees: 688,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/calypso-technology',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_555,
    name: 'Viewpoint',
    domainNamePrimaryLinkUrl: 'viewpoint.com',
    addressAddressCity: 'Broomfield',
    employees: 686,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/viewpoint-construction-software',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_556,
    name: 'Devo',
    domainNamePrimaryLinkUrl: 'devo.com',
    addressAddressCity: 'Cambridge',
    employees: 685,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/devoinc',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_557,
    name: 'WebPT',
    domainNamePrimaryLinkUrl: 'webpt.com',
    addressAddressCity: 'Phoenix',
    employees: 685,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/webpt',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_558,
    name: 'MatrixCare',
    domainNamePrimaryLinkUrl: 'matrixcare.com',
    addressAddressCity: 'Minneapolis',
    employees: 683,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/matrixcare',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_559,
    name: 'Sisense',
    domainNamePrimaryLinkUrl: 'sisense.com',
    addressAddressCity: 'New York',
    employees: 683,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/sisense',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_560,
    name: 'Calendly',
    domainNamePrimaryLinkUrl: 'calendly.com',
    addressAddressCity: 'Atlanta',
    employees: 681,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/calendly',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_561,
    name: 'Placer.ai',
    domainNamePrimaryLinkUrl: 'placer.io',
    addressAddressCity: 'Los Altos',
    employees: 677,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/placer',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_562,
    name: 'MResult',
    domainNamePrimaryLinkUrl: 'mresult.com',
    addressAddressCity: 'Mystic',
    employees: 674,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mresult',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_563,
    name: 'Coherent Solutions',
    domainNamePrimaryLinkUrl: 'coherentsolutions.com',
    addressAddressCity: 'Minneapolis',
    employees: 672,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/coherent-solutions',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_564,
    name: 'Mirantis',
    domainNamePrimaryLinkUrl: 'mirantis.com',
    addressAddressCity: 'Campbell',
    employees: 671,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mirantis',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_565,
    name: 'Simplify Healthcare',
    domainNamePrimaryLinkUrl: 'simplifyhealthcare.com',
    addressAddressCity: 'Aurora',
    employees: 671,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/simplifyhealthcare',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_566,
    name: 'JumpCloud',
    domainNamePrimaryLinkUrl: 'jumpcloud.com',
    addressAddressCity: 'Louisville',
    employees: 671,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/jumpcloud',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_567,
    name: 'ASAP',
    domainNamePrimaryLinkUrl: 'asap.com',
    addressAddressCity: 'Lafayette',
    employees: 667,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/asap',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_568,
    name: 'Xoxoday',
    domainNamePrimaryLinkUrl: 'xoxoday.com',
    addressAddressCity: 'Redwood City',
    employees: 666,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/xoxoday',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_569,
    name: 'DataStax',
    domainNamePrimaryLinkUrl: 'datastax.com',
    addressAddressCity: 'Santa Clara',
    employees: 666,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/datastax',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_570,
    name: 'Foursquare',
    domainNamePrimaryLinkUrl: 'foursquare.com',
    addressAddressCity: 'New York',
    employees: 665,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/foursquare',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_571,
    name: 'LastPass',
    domainNamePrimaryLinkUrl: 'lastpass.com',
    addressAddressCity: 'Boston',
    employees: 664,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/lastpass',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_572,
    name: 'SOCi, Inc.',
    domainNamePrimaryLinkUrl: 'meetsoci.com',
    addressAddressCity: 'San Diego',
    employees: 664,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/soci-inc-',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_573,
    name: 'Stratus Technologies',
    domainNamePrimaryLinkUrl: 'stratus.com',
    addressAddressCity: 'Maynard',
    employees: 662,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/stratus-technologies',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_574,
    name: 'AdvancedMD',
    domainNamePrimaryLinkUrl: 'advancedmd.com',
    addressAddressCity: 'South Jordan',
    employees: 661,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/advancedmd',
    createdBySource: 'CALENDAR',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_575,
    name: 'Matterport',
    domainNamePrimaryLinkUrl: 'matterport.com',
    addressAddressCity: 'Sunnyvale',
    employees: 660,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/matterport',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_576,
    name: 'Samsung Research America (SRA)',
    domainNamePrimaryLinkUrl: 'sra.samsung.com',
    addressAddressCity: 'Mountain View',
    employees: 658,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/sra-samsungreasearchamerica',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_577,
    name: 'Creatio',
    domainNamePrimaryLinkUrl: 'creatio.com',
    addressAddressCity: 'Boston',
    employees: 657,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/creatioglobal',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_578,
    name: 'Branch',
    domainNamePrimaryLinkUrl: 'branch.io',
    addressAddressCity: 'Palo Alto',
    employees: 657,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/branch-metrics',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_579,
    name: 'Versa Networks',
    domainNamePrimaryLinkUrl: 'versa-networks.com',
    addressAddressCity: 'Alviso',
    employees: 655,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/versa-networks',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_580,
    name: 'Mitek Systems',
    domainNamePrimaryLinkUrl: 'miteksystems.com',
    addressAddressCity: 'San Diego',
    employees: 653,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/miteksystems',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_581,
    name: 'PDF Solutions',
    domainNamePrimaryLinkUrl: 'pdf.com',
    addressAddressCity: 'Santa Clara',
    employees: 653,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/pdf-solutions',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_582,
    name: 'ESO',
    domainNamePrimaryLinkUrl: 'eso.com',
    addressAddressCity: 'Austin',
    employees: 652,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/eso-solutions',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_583,
    name: 'Mural',
    domainNamePrimaryLinkUrl: 'mural.co',
    addressAddressCity: 'San Francisco',
    employees: 650,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/mural.co',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_584,
    name: 'FourKites, Inc.',
    domainNamePrimaryLinkUrl: 'fourkites.com',
    addressAddressCity: 'Chicago',
    employees: 650,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/fourkites-inc',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_585,
    name: 'Aras Corporation',
    domainNamePrimaryLinkUrl: 'aras.com',
    addressAddressCity: 'Andover',
    employees: 648,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/aras-corporation',
    createdBySource: 'WEBHOOK',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_586,
    name: 'Delphix',
    domainNamePrimaryLinkUrl: 'delphix.com',
    addressAddressCity: 'Redwood City',
    employees: 648,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/delphix',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_587,
    name: 'Wolfram',
    domainNamePrimaryLinkUrl: 'wolfram.com',
    addressAddressCity: 'Champaign',
    employees: 644,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/wolfram-research',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_588,
    name: 'Eightfold',
    domainNamePrimaryLinkUrl: 'eightfold.ai',
    addressAddressCity: 'Santa Clara',
    employees: 643,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/eightfoldai',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_589,
    name: 'Quark Software Inc.',
    domainNamePrimaryLinkUrl: 'quark.com',
    addressAddressCity: 'Grand Rapids',
    employees: 641,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/quark',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_590,
    name: 'connectRN',
    domainNamePrimaryLinkUrl: 'connectrn.com',
    addressAddressCity: 'Waltham',
    employees: 640,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/connectrn',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_591,
    name: 'RSI',
    domainNamePrimaryLinkUrl: 'rsidelivers.com',
    addressAddressCity: 'Pembroke',
    employees: 638,
    linkedinLinkPrimaryLinkUrl:
      'https://linkedin.com/company/revenue-solutions-inc-',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_592,
    name: 'Macrosoft',
    domainNamePrimaryLinkUrl: 'macrosoftinc.com',
    addressAddressCity: 'Parsippany',
    employees: 638,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/macrosoft',
    createdBySource: 'SYSTEM',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_593,
    name: 'Paradox',
    domainNamePrimaryLinkUrl: 'paradox.ai',
    addressAddressCity: 'Scottsdale',
    employees: 637,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/paradoxolivia',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_594,
    name: 'SmartRecruiters',
    domainNamePrimaryLinkUrl: 'smartrecruiters.com',
    addressAddressCity: 'San Francisco',
    employees: 637,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/smartrecruiters',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_595,
    name: 'Tealium',
    domainNamePrimaryLinkUrl: 'tealium.com',
    addressAddressCity: 'San Diego',
    employees: 635,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tealium',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_596,
    name: 'Securiti',
    domainNamePrimaryLinkUrl: 'securiti.ai',
    addressAddressCity: 'San Jose',
    employees: 634,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/securitiai',
    createdBySource: 'MANUAL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_597,
    name: 'Lattice',
    domainNamePrimaryLinkUrl: 'lattice.com',
    addressAddressCity: 'San Francisco',
    employees: 634,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/lattice-hq',
    createdBySource: 'EMAIL',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.PHIL,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_598,
    name: 'TuSimple',
    domainNamePrimaryLinkUrl: 'tusimple.com',
    addressAddressCity: 'San Diego',
    employees: 633,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/tusimple',
    createdBySource: 'IMPORT',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_599,
    name: 'Ceipal',
    domainNamePrimaryLinkUrl: 'ceipal.com',
    addressAddressCity: 'Rochester',
    employees: 633,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/ceipal',
    createdBySource: 'WORKFLOW',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },

  {
    id: COMPANY_DATA_SEED_IDS.ID_599,
    name: 'RSD',
    domainNamePrimaryLinkUrl: 'rocketsoftware.com',
    addressAddressCity: 'Waltham',
    employees: 633,
    linkedinLinkPrimaryLinkUrl: 'https://linkedin.com/company/rsd',
    createdBySource: 'API',
    createdByWorkspaceMemberId: WORKSPACE_MEMBER_DATA_SEED_IDS.TIM,
    createdByName: 'Tim A',
    accountOwnerId: WORKSPACE_MEMBER_DATA_SEED_IDS.JONY,
  },
];

export const COMPANY_DATA_SEEDS: CompanyDataSeed[] = COMPANY_DATA_SEEDS_RAW.map(
  (company, index) => ({
    ...company,
    updatedBySource: company.createdBySource,
    updatedByWorkspaceMemberId: company.createdByWorkspaceMemberId,
    updatedByName: company.createdByName,
    position: index + 1,
  }),
);
