import { assertUnreachable } from 'twenty-shared/utils';

import {
  ConflictError,
  NotFoundError,
  UserInputError,
} from 'src/engine/core-modules/graphql/utils/graphql-errors.util';
import {
  WebhookException,
  WebhookExceptionCode,
} from 'src/engine/metadata-modules/webhook/webhook.exception';

export const webhookGraphqlApiExceptionHandler = (error: Error) => {
  if (error instanceof WebhookException) {
    switch (error.code) {
      case WebhookExceptionCode.WEBHOOK_NOT_FOUND:
        throw new NotFoundError(error);
      case WebhookExceptionCode.INVALID_WEBHOOK_INPUT:
      case WebhookExceptionCode.INVALID_TARGET_URL:
        throw new UserInputError(error);
      case WebhookExceptionCode.WEBHOOK_ALREADY_EXISTS:
        throw new ConflictError(error);
      default: {
        return assertUnreachable(error.code);
      }
    }
  }

  throw error;
};
