import { v4 } from 'uuid';

import { LogicFunctionRuntime } from 'src/engine/metadata-modules/logic-function/logic-function.entity';
import { type UniversalFlatLogicFunction } from 'src/engine/workspace-manager/workspace-migration/universal-flat-entity/types/universal-flat-logic-function.type';

type AutoGeneratedFields = 'createdAt' | 'updatedAt' | 'deletedAt' | 'runtime';

type RequiredFields =
  | 'name'
  | 'handlerName'
  | 'sourceHandlerPath'
  | 'builtHandlerPath'
  | 'isBuildUpToDate'
  | 'applicationUniversalIdentifier';

type OptionalFields = Exclude<
  keyof UniversalFlatLogicFunction,
  AutoGeneratedFields | RequiredFields
>;

export type BuildUniversalFlatLogicFunctionToCreateInput = Pick<
  UniversalFlatLogicFunction,
  RequiredFields
> &
  Partial<Pick<UniversalFlatLogicFunction, OptionalFields>> & {
    id?: string;
  };

export const buildUniversalFlatLogicFunctionToCreate = (
  input: BuildUniversalFlatLogicFunctionToCreateInput,
): UniversalFlatLogicFunction & { id: string } => {
  const now = new Date().toISOString();

  return {
    id: input.id ?? v4(),
    universalIdentifier: input.universalIdentifier ?? v4(),
    name: input.name,
    description: input.description ?? null,
    runtime: LogicFunctionRuntime.NODE22,
    timeoutSeconds: input.timeoutSeconds ?? 300,
    checksum: input.checksum ?? null,
    toolInputSchema: input.toolInputSchema ?? null,
    isTool: input.isTool ?? false,
    isBuildUpToDate: input.isBuildUpToDate,
    handlerName: input.handlerName,
    sourceHandlerPath: input.sourceHandlerPath,
    builtHandlerPath: input.builtHandlerPath,
    cronTriggerSettings: input.cronTriggerSettings ?? null,
    databaseEventTriggerSettings: input.databaseEventTriggerSettings ?? null,
    httpRouteTriggerSettings: input.httpRouteTriggerSettings ?? null,
    createdAt: now,
    updatedAt: now,
    deletedAt: null,
    applicationUniversalIdentifier: input.applicationUniversalIdentifier,
  };
};
