import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const OPPORTUNITY_FLAT_FIELDS_MOCK = {
  name: getFlatFieldMetadataMock({
    id: '5f510348-58e9-4ded-8dbe-144ae3644bd4',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.TEXT,
    name: 'name',
    label: 'Name',
    defaultValue: "''",
    description: 'The opportunity name',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-8609-4f65-a2d9-44009eb422b5',
  }),
  amount: getFlatFieldMetadataMock({
    id: '2713c658-cfad-4bc2-a6a0-adc4815185a1',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.CURRENCY,
    name: 'amount',
    label: 'Amount',
    defaultValue: { amountMicros: null, currencyCode: "''" },
    description: 'Opportunity amount',
    icon: 'IconCurrencyDollar',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-583e-4642-8533-db761d5fa82f',
  }),
  closeDate: getFlatFieldMetadataMock({
    id: '1d15aa71-38ea-473f-aac9-e4519882213f',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.DATE_TIME,
    name: 'closeDate',
    label: 'Close date',
    defaultValue: null,
    description: 'Opportunity close date',
    icon: 'IconCalendarEvent',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-527e-44d6-b1ac-c4158d307b97',
  }),
  stage: getFlatFieldMetadataMock({
    id: '4642f809-f302-4525-8af1-3f3ad79998fb',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.SELECT,
    name: 'stage',
    label: 'Stage',
    defaultValue: "'NEW'",
    description: 'Opportunity stage',
    icon: 'IconProgressCheck',
    standardOverrides: null,
    options: [
      {
        id: 'fdf5cede-2b0e-44d0-adbe-3bc7e613efc9',
        color: 'red',
        label: 'New',
        value: 'NEW',
        position: 0,
      },
      {
        id: '2bf892e2-79ad-4182-84a2-54f797ec8b95',
        color: 'purple',
        label: 'Screening',
        value: 'SCREENING',
        position: 1,
      },
      {
        id: 'fa1c0aee-d400-4352-93c6-077a4fc6ff96',
        color: 'sky',
        label: 'Meeting',
        value: 'MEETING',
        position: 2,
      },
      {
        id: '2aaf3721-6ea7-4596-8b3f-2d09a09f8a8e',
        color: 'turquoise',
        label: 'Proposal',
        value: 'PROPOSAL',
        position: 3,
      },
      {
        id: '24da0470-c4c0-4a3f-86d7-1629d850663e',
        color: 'yellow',
        label: 'Customer',
        value: 'CUSTOMER',
        position: 4,
      },
    ],
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-6f76-477d-8551-28cd65b2b4b9',
  }),
  position: getFlatFieldMetadataMock({
    id: 'd4ca6cb7-fbdb-4e27-b5be-ac9f3a17cf0a',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.POSITION,
    name: 'position',
    label: 'Position',
    defaultValue: 0,
    description: 'Opportunity record position',
    icon: 'IconHierarchy2',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-806d-493a-bbc6-6313e62958e2',
  }),
  createdBy: getFlatFieldMetadataMock({
    id: '29222276-99f1-4443-b5d6-6ea6aa16f28a',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.ACTOR,
    name: 'createdBy',
    label: 'Created by',
    defaultValue: {
      name: "'System'",
      source: "'MANUAL'",
      workspaceMemberId: null,
    },
    description: 'The creator of the record',
    icon: 'IconCreativeCommonsSa',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-a63e-4a62-8e63-42a51828f831',
  }),
  searchVector: getFlatFieldMetadataMock({
    id: '0ba0c3f0-41f1-4c49-b28b-0a04adddbc7c',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.TS_VECTOR,
    name: 'searchVector',
    label: 'Search vector',
    defaultValue: null,
    description: 'Field used for full-text search',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '428a0da5-4b2e-4ce3-b695-89a8b384e6e3',
  }),
  id: getFlatFieldMetadataMock({
    id: '06f91646-dd7c-481d-b2d9-6dc02b9b6ca8',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '9cc5c7c6-d9eb-46aa-b4a9-e5a922749b14',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: '04629f30-4fdc-4084-bf3f-7f254acc6cf8',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: '07435758-30b2-4d10-a2c3-947b8db7797f',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  pointOfContact: getFlatFieldMetadataMock({
    id: '0e55bf63-1ffb-4f74-89f2-edd5a6a6686c',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.RELATION,
    name: 'pointOfContact',
    label: 'Point of Contact',
    defaultValue: null,
    description: 'Opportunity point of contact',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'pointOfContactId',
    },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '7580c1b1-e8f9-480b-bd41-38b20df35777',
    relationTargetObjectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    universalIdentifier: '20202020-8dfb-42fc-92b6-01afb759ed16',
  }),
  company: getFlatFieldMetadataMock({
    id: '512890f1-4da0-4b96-bb71-5ccabefb82e7',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.RELATION,
    name: 'company',
    label: 'Company',
    defaultValue: null,
    description: 'Opportunity company',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'companyId',
    },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '3eda8c8e-74e4-401f-bb0e-470db5b267e6',
    relationTargetObjectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    universalIdentifier: '20202020-cbac-457e-b565-adece5fc815f',
  }),
  favorites: getFlatFieldMetadataMock({
    id: '87bb9924-a1cc-4357-9c8a-52141dabf266',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.RELATION,
    name: 'favorites',
    label: 'Favorites',
    defaultValue: null,
    description: 'Favorites linked to the opportunity',
    icon: 'IconHeart',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '6380cf8e-4327-4d1e-ad21-1826ce4ecf05',
    relationTargetObjectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    universalIdentifier: '20202020-a1c2-4500-aaae-83ba8a0e827a',
  }),
  taskTargets: getFlatFieldMetadataMock({
    id: 'c0c9f9ac-0d40-4206-90e5-0d1e14f8a09f',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.RELATION,
    name: 'taskTargets',
    label: 'Tasks',
    defaultValue: null,
    description: 'Tasks tied to the opportunity',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '49afc8d8-dde3-4d19-aa6b-bd16a751b114',
    relationTargetObjectMetadataId: 'bb2b29b8-7f46-4106-a8ae-3a32df9c9166',
    universalIdentifier: '20202020-59c0-4179-a208-4a255f04a5be',
  }),
  noteTargets: getFlatFieldMetadataMock({
    id: '36210a54-a72e-4530-a1eb-a0420c53e551',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.RELATION,
    name: 'noteTargets',
    label: 'Notes',
    defaultValue: null,
    description: 'Notes tied to the opportunity',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'f42eac2a-8d99-4259-b69a-549abd553eda',
    relationTargetObjectMetadataId: '12e3cb51-c3de-4192-b0d5-965d48d001c0',
    universalIdentifier: '20202020-dd3f-42d5-a382-db58aabf43d3',
  }),
  attachments: getFlatFieldMetadataMock({
    id: '16515578-a6ce-48af-a303-2005bb8492f0',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.RELATION,
    name: 'attachments',
    label: 'Attachments',
    defaultValue: null,
    description: 'Attachments linked to the opportunity',
    icon: 'IconFileImport',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'da72fbe2-a5aa-42b5-b6bd-482a3919eb20',
    relationTargetObjectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    universalIdentifier: '20202020-87c7-4118-83d6-2f4031005209',
  }),
  timelineActivities: getFlatFieldMetadataMock({
    id: '7826944b-3b21-4448-892e-5a2a68161313',
    objectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    type: FieldMetadataType.RELATION,
    name: 'timelineActivities',
    label: 'Timeline Activities',
    defaultValue: null,
    description: 'Timeline Activities linked to the opportunity.',
    icon: 'IconTimelineEvent',
    standardOverrides: null,
    options: null,
    settings: { relationType: RelationType.ONE_TO_MANY },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '026cbaa7-860c-4ed4-b878-8d78849e6c28',
    relationTargetObjectMetadataId: '3090f830-c4b1-41a1-8e18-815760830bec',
    universalIdentifier: '20202020-30e2-421f-96c7-19c69d1cf631',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
