import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const FAVORITE_FLAT_FIELDS_MOCK = {
  position: getFlatFieldMetadataMock({
    id: '64dbf3ef-a352-44bb-9055-f95822f18d0a',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.NUMBER,
    name: 'position',
    label: 'Position',
    defaultValue: 0,
    description: 'Favorite position',
    icon: 'IconList',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-dd26-42c6-8c3c-2a7598c204f6',
  }),
  id: getFlatFieldMetadataMock({
    id: '49f58497-4e7c-49e6-b3bc-c91d4b8a8ddc',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '0606a76c-8a72-48ca-90c6-526c729c25eb',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: 'fb202982-0c8e-4917-8dda-acb8248be749',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: 'ef52e151-a974-470f-bbe7-f345fd4eca65',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  forWorkspaceMember: getFlatFieldMetadataMock({
    id: '07f2c3ba-63d1-4e44-bac4-bc4591e51bac',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'forWorkspaceMember',
    label: 'Workspace Member',
    defaultValue: null,
    description: 'Favorite workspace member',
    icon: 'IconCircleUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'forWorkspaceMemberId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'a15a4b41-1849-4dea-aa43-f53caad016be',
    relationTargetObjectMetadataId: '7d8264db-2b55-4b74-81ff-b7064ed43840',
    universalIdentifier: '20202020-ce63-49cb-9676-fdc0c45892cd',
  }),
  person: getFlatFieldMetadataMock({
    id: '013cec20-e9cc-42db-b9b9-ff6bd0f52abd',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'person',
    label: 'Person',
    defaultValue: null,
    description: 'Favorite person',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'personId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'a1a72bee-1c15-4598-ba23-67ba8e3e505d',
    relationTargetObjectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    universalIdentifier: '20202020-c428-4f40-b6f3-86091511c41c',
  }),
  company: getFlatFieldMetadataMock({
    id: '9a11532c-6839-46ed-a2f5-ed03f88b86f6',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'company',
    label: 'Company',
    defaultValue: null,
    description: 'Favorite company',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'companyId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '72415216-fed4-450b-aa00-691e37718b01',
    relationTargetObjectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    universalIdentifier: '20202020-cff5-4682-8bf9-069169e08279',
  }),
  favoriteFolder: getFlatFieldMetadataMock({
    id: 'fabbe669-b8fc-49fe-8010-f13d01eb61f1',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'favoriteFolder',
    label: 'Favorite Folder',
    defaultValue: null,
    description: 'The folder this favorite belongs to',
    icon: 'IconFolder',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'favoriteFolderId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '71b95076-6b8d-45c9-9a7c-ab981b81bd1b',
    relationTargetObjectMetadataId: '35763b74-1abe-4c4b-9eab-27693f0ee06d',
    universalIdentifier: '20202020-f658-4d12-8b4d-248356aa4bd9',
  }),
  opportunity: getFlatFieldMetadataMock({
    id: '6380cf8e-4327-4d1e-ad21-1826ce4ecf05',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'opportunity',
    label: 'Opportunity',
    defaultValue: null,
    description: 'Favorite opportunity',
    icon: 'IconTargetArrow',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'opportunityId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '87bb9924-a1cc-4357-9c8a-52141dabf266',
    relationTargetObjectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    universalIdentifier: '20202020-dabc-48e1-8318-2781a2b32aa2',
  }),
  workflow: getFlatFieldMetadataMock({
    id: '12c20527-9b1d-4922-9650-00cc31b26387',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'workflow',
    label: 'Workflow',
    defaultValue: null,
    description: 'Favorite workflow',
    icon: 'IconSettingsAutomation',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'workflowId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: 'b848abe8-276b-46c9-9eab-baf34d2a0583',
    relationTargetObjectMetadataId: '664c19a5-0693-45d4-a4e5-76c3717db83c',
    universalIdentifier: '20202020-b11b-4dc8-999a-6bd0a947b463',
  }),
  workflowVersion: getFlatFieldMetadataMock({
    id: '5cb92f25-c067-4e19-afb3-c7cc038ed1a4',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'workflowVersion',
    label: 'Workflow',
    defaultValue: null,
    description: 'Favorite workflow version',
    icon: 'IconSettingsAutomation',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'workflowVersionId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'ea6b6bda-6ba7-4549-b81a-1f3ced0d4b25',
    relationTargetObjectMetadataId: '99cf5f27-b41d-4f25-a23b-9e47d27dae9b',
    universalIdentifier: '20202020-e1b8-4caf-b55a-3ab4d4cbcd21',
  }),
  workflowRun: getFlatFieldMetadataMock({
    id: 'a4bdd0d8-c36f-4519-812b-be4800ab14b0',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'workflowRun',
    label: 'Workflow',
    defaultValue: null,
    description: 'Favorite workflow run',
    icon: 'IconSettingsAutomation',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'workflowRunId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '444a6e9e-443d-4f04-a60d-32f76f17049c',
    relationTargetObjectMetadataId: '06d95e96-b050-443f-946e-dd276d291a2f',
    universalIdentifier: '20202020-db5a-4fe4-9a13-9afa22b1e762',
  }),
  task: getFlatFieldMetadataMock({
    id: 'db16ab78-ea3f-4b67-93e3-6ad9ab1b7273',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'task',
    label: 'Task',
    defaultValue: null,
    description: 'Favorite task',
    icon: 'IconCheckbox',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'taskId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '33e4eff0-ff0f-4530-802a-cd630481ee84',
    relationTargetObjectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    universalIdentifier: '20202020-1b1b-4b3b-8b1b-7f8d6a1d7d5c',
  }),
  note: getFlatFieldMetadataMock({
    id: 'a61baf0f-2d43-4fda-9baf-efb000c17ecd',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'note',
    label: 'Note',
    defaultValue: null,
    description: 'Favorite note',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'noteId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '065a1ede-f773-48ca-84bf-70f61d838396',
    relationTargetObjectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    universalIdentifier: '20202020-1f25-43fe-8b00-af212fdde824',
  }),
  view: getFlatFieldMetadataMock({
    id: 'accd216c-790e-4bd2-83bb-0700e06d0e5c',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'view',
    label: 'View',
    defaultValue: null,
    description: 'Favorite view',
    icon: 'IconLayoutCollage',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'viewId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '90a103ec-7dce-4bd4-aed4-e2c9d46ecf32',
    relationTargetObjectMetadataId: '8377fc0d-ec1c-4fb5-b6ae-9381d9b22a95',
    universalIdentifier: '20202020-5a93-4fa9-acce-e73481a0bbdf',
  }),
  rocket: getFlatFieldMetadataMock({
    id: '9448627d-725d-499e-a071-90fd5cfcf0ea',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'rocket',
    label: 'Rocket',
    defaultValue: null,
    description: 'Favorites Rocket',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'rocketId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '14010360-f3c2-442e-b05f-43c30158f246',
    relationTargetObjectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    universalIdentifier: '20202020-78f7-4d7d-86e9-7562ced0b381',
  }),
  pet: getFlatFieldMetadataMock({
    id: 'd34b4048-bf0c-4c61-8ffe-59f1838a2cc4',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'pet',
    label: 'Pet',
    defaultValue: null,
    description: 'Favorites Pet',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'petId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '80bc4e7a-6bd1-4f2b-98b1-6333c631cc1a',
    relationTargetObjectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    universalIdentifier: '20202020-1bd7-4d10-80dc-968b9f5d1a8a',
  }),
  surveyResult: getFlatFieldMetadataMock({
    id: '9cdfb5a1-bb9c-4a59-811d-f5a1034a8f8b',
    objectMetadataId: 'f4749ffb-dde8-44ff-8b01-d3fc82df0ba2',
    type: FieldMetadataType.RELATION,
    name: 'surveyResult',
    label: 'Survey result',
    defaultValue: null,
    description: 'Favorites Survey result',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'surveyResultId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '8e11aced-3a20-4551-baa1-b38b98a74e1c',
    relationTargetObjectMetadataId: '713da753-0340-49b5-b1fa-add34d2dc9a8',
    universalIdentifier: '20202020-d049-4912-80ee-43b09fe3b0ac',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
