import {
  FieldMetadataType,
  DateDisplayFormat,
  RelationOnDeleteAction,
} from 'twenty-shared/types';

import { RelationType } from 'src/engine/metadata-modules/field-metadata/interfaces/relation-type.interface';

import { getFlatFieldMetadataMock } from 'src/engine/metadata-modules/flat-field-metadata/__mocks__/get-flat-field-metadata.mock';
import { type FlatFieldMetadata } from 'src/engine/metadata-modules/flat-field-metadata/types/flat-field-metadata.type';

export const ATTACHMENT_FLAT_FIELDS_MOCK = {
  name: getFlatFieldMetadataMock({
    id: 'f51cfa5d-7190-48a5-b548-3e542322c144',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.TEXT,
    name: 'name',
    label: 'Name',
    defaultValue: "''",
    description: 'Attachment name',
    icon: 'IconFileUpload',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-87a5-48f8-bbf7-ade388825a57',
  }),
  fullPath: getFlatFieldMetadataMock({
    id: '38207e43-a958-4058-bc32-36f838d102d3',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.TEXT,
    name: 'fullPath',
    label: 'Full path',
    defaultValue: "''",
    description: 'Attachment full path',
    icon: 'IconLink',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-0d19-453d-8e8d-fbcda8ca3747',
  }),
  type: getFlatFieldMetadataMock({
    id: '840360e7-efa6-4ca2-a0d6-113b79474b98',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.TEXT,
    name: 'type',
    label: 'Type',
    defaultValue: "''",
    description: 'Attachment type',
    icon: 'IconList',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-a417-49b8-a40b-f6a7874caa0d',
  }),
  id: getFlatFieldMetadataMock({
    id: '8662ced6-5e48-4576-993f-1be479dba176',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.UUID,
    name: 'id',
    label: 'Id',
    defaultValue: 'uuid',
    description: 'Id',
    icon: 'Icon123',
    standardOverrides: null,
    options: null,
    settings: null,
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-eda0-4cee-9577-3eb357e3c22b',
  }),
  createdAt: getFlatFieldMetadataMock({
    id: '367923d5-658b-4b7b-9381-6f8e6cf84c85',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.DATE_TIME,
    name: 'createdAt',
    label: 'Creation date',
    defaultValue: 'now',
    description: 'Creation date',
    icon: 'IconCalendar',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-66ac-4502-9975-e4d959c50311',
  }),
  updatedAt: getFlatFieldMetadataMock({
    id: 'b81f8f1b-4173-4176-bc3c-fe1b6a45a0dc',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.DATE_TIME,
    name: 'updatedAt',
    label: 'Last update',
    defaultValue: 'now',
    description: 'Last time the record was changed',
    icon: 'IconCalendarClock',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: false,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-d767-4622-bdcf-d8a084834d86',
  }),
  deletedAt: getFlatFieldMetadataMock({
    id: 'eab57da6-41ae-45e8-a5ee-014cfcab450f',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.DATE_TIME,
    name: 'deletedAt',
    label: 'Deleted at',
    defaultValue: null,
    description: 'Date when the record was deleted',
    icon: 'IconCalendarMinus',
    standardOverrides: null,
    options: null,
    settings: { displayFormat: DateDisplayFormat.RELATIVE },
    isCustom: false,
    isActive: true,
    isSystem: false,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: null,
    relationTargetObjectMetadataId: null,
    universalIdentifier: '20202020-b9a7-48d8-8387-b9a3090a50ec',
  }),
  author: getFlatFieldMetadataMock({
    id: '99724bb6-7a84-4b54-9b3f-dab730ab445a',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'author',
    label: 'Author',
    defaultValue: null,
    description: 'Attachment author',
    icon: 'IconCircleUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'authorId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '958b82d0-a290-4e10-898d-3d858fbf684f',
    relationTargetObjectMetadataId: '7d8264db-2b55-4b74-81ff-b7064ed43840',
    universalIdentifier: '20202020-6501-4ac5-a4ef-b2f8522ef6cd',
  }),
  task: getFlatFieldMetadataMock({
    id: 'bd823f17-f923-4f0d-8533-51d7bc062975',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'task',
    label: 'Task',
    defaultValue: null,
    description: 'Attachment task',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'taskId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '00fd339a-6431-465d-9524-09b5c804f497',
    relationTargetObjectMetadataId: '3186920d-2a15-4b5f-96c7-2bf6567024b0',
    universalIdentifier: '20202020-51e5-4621-9cf8-215487951c4b',
  }),
  note: getFlatFieldMetadataMock({
    id: '5a98eb2b-1120-42e3-afd3-09d7da642fba',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'note',
    label: 'Note',
    defaultValue: null,
    description: 'Attachment note',
    icon: 'IconNotes',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.SET_NULL,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'noteId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '4d4b3225-ddd2-4d76-a4d6-bcdd43a256e8',
    relationTargetObjectMetadataId: '1253e3e5-5b00-4a34-93b8-02f3dc6e2b7c',
    universalIdentifier: '20202020-4f4b-4503-a6fc-6b982f3dffb5',
  }),
  person: getFlatFieldMetadataMock({
    id: '6938c2ec-ebcc-4f30-8d38-2c9c40228c53',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'person',
    label: 'Person',
    defaultValue: null,
    description: 'Attachment person',
    icon: 'IconUser',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'personId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '367ad117-de09-466c-94f8-ce99d951b5ce',
    relationTargetObjectMetadataId: '843e0b67-9619-4628-91c4-2fa62256a611',
    universalIdentifier: '20202020-0158-4aa2-965c-5cdafe21ffa2',
  }),
  company: getFlatFieldMetadataMock({
    id: '0bacf73b-f45b-4683-85b4-3e812e6228bf',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'company',
    label: 'Company',
    defaultValue: null,
    description: 'Attachment company',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'companyId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '44a572c5-d620-47f5-943a-346ae967e99e',
    relationTargetObjectMetadataId: '7f5c2c7a-bb23-46fb-b59d-9b7a52a8d1cc',
    universalIdentifier: '20202020-ceab-4a28-b546-73b06b4c08d5',
  }),
  opportunity: getFlatFieldMetadataMock({
    id: 'da72fbe2-a5aa-42b5-b6bd-482a3919eb20',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'opportunity',
    label: 'Opportunity',
    defaultValue: null,
    description: 'Attachment opportunity',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'opportunityId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: true,
    relationTargetFieldMetadataId: '16515578-a6ce-48af-a303-2005bb8492f0',
    relationTargetObjectMetadataId: 'e6996bbf-dd41-423a-9324-8546f5b22fa7',
    universalIdentifier: '20202020-7374-499d-bea3-9354890755b5',
  }),
  rocket: getFlatFieldMetadataMock({
    id: 'ba23019c-7f25-42c3-8138-622e61c42968',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'rocket',
    label: 'Rocket',
    defaultValue: null,
    description: 'Attachments Rocket',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'rocketId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: 'f5984acf-5128-42ac-840f-9d2888423699',
    relationTargetObjectMetadataId: 'd78ec657-74a4-4652-a350-1f44ff62970a',
    universalIdentifier: '20202020-ca2d-47c0-8253-9d0b662fb01a',
  }),
  pet: getFlatFieldMetadataMock({
    id: '317a33ef-117e-4953-86d4-c4a9670a2ce3',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'pet',
    label: 'Pet',
    defaultValue: null,
    description: 'Attachments Pet',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'petId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '231903d0-3b14-47ed-9a88-fbf11031c451',
    relationTargetObjectMetadataId: 'd34e0f07-1b8c-4de0-938e-599cf05e1f7f',
    universalIdentifier: '20202020-b715-4658-8b6a-5359824dbddd',
  }),
  surveyResult: getFlatFieldMetadataMock({
    id: 'a09463e6-5e56-4965-bc8a-2faa23a64672',
    objectMetadataId: '819ed5ff-312f-4423-8e95-02a691cf5c27',
    type: FieldMetadataType.RELATION,
    name: 'surveyResult',
    label: 'Survey result',
    defaultValue: null,
    description: 'Attachments Survey result',
    icon: 'IconBuildingSkyscraper',
    standardOverrides: null,
    options: null,
    settings: {
      onDelete: RelationOnDeleteAction.CASCADE,
      relationType: RelationType.MANY_TO_ONE,
      joinColumnName: 'surveyResultId',
    },
    isCustom: false,
    isActive: true,
    isSystem: true,
    isNullable: true,
    isUnique: false,
    workspaceId: '20202020-1c25-4d02-bf25-6aeccf7ea419',
    isLabelSyncedWithName: false,
    relationTargetFieldMetadataId: '3347ffcc-43d0-4697-a9ce-6fb9b0e677e1',
    relationTargetObjectMetadataId: '713da753-0340-49b5-b1fa-add34d2dc9a8',
    universalIdentifier: '20202020-58b5-4f6c-8402-06b2bf3ea064',
  }),
} as const satisfies Record<string, FlatFieldMetadata>;
