import { type AgentDTO } from 'src/engine/metadata-modules/ai/ai-agent/dtos/agent.dto';
import { type FlatAgentWithRoleId } from 'src/engine/metadata-modules/flat-agent/types/flat-agent.type';

export const fromFlatAgentWithRoleIdToAgentDto = ({
  applicationId,
  createdAt,
  description,
  evaluationInputs,
  icon,
  id,
  isCustom,
  label,
  modelConfiguration,
  modelId,
  name,
  prompt,
  responseFormat,
  updatedAt,
  workspaceId,
  roleId,
}: FlatAgentWithRoleId): AgentDTO => ({
  createdAt: new Date(createdAt),
  description: description ?? undefined,
  evaluationInputs,
  id,
  isCustom,
  label,
  modelConfiguration: modelConfiguration ?? undefined,
  modelId,
  name,
  prompt,
  responseFormat,
  updatedAt: new Date(updatedAt),
  workspaceId,
  applicationId: applicationId ?? undefined,
  icon: icon ?? undefined,
  roleId: roleId ?? undefined,
});
