import {
  type BeforeCreateOneHook,
  type CreateOneInputType,
} from '@ptc-org/nestjs-query-graphql';
import { v4 as uuidv4 } from 'uuid';

import { type AppTokenEntity } from 'src/engine/core-modules/app-token/app-token.entity';

export class BeforeCreateOneAppToken<T extends AppTokenEntity>
  implements BeforeCreateOneHook<T>
{
  async run(
    instance: CreateOneInputType<T>,
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    context: any,
  ): Promise<CreateOneInputType<T>> {
    const userId = context?.req?.user?.id;

    instance.input.userId = userId;
    // FIXME: These fields should be autogenerated, we need to run a migration for this
    instance.input.id = uuidv4();
    instance.input.updatedAt = new Date();

    return instance;
  }
}
