import { FieldType } from '@/sdk';
import type { Manifest } from 'twenty-shared/application';
import { PermissionFlagType } from 'twenty-shared/constants';
import {
  FieldMetadataType,
  RelationOnDeleteAction,
  RelationType,
  ViewType,
} from 'twenty-shared/types';

export const EXPECTED_MANIFEST: Manifest = {
  pageLayouts: [],
  publicAssets: [
    {
      checksum: '99496069dcc2a1488e1cae9f826d2707',
      fileName: 'favicon.png',
      filePath: 'public/favicon.png',
      fileType: 'png',
    },
  ],
  application: {
    applicationVariables: {
      DEFAULT_RECIPIENT_NAME: {
        description: 'Default recipient name for postcards',
        isSecret: false,
        universalIdentifier: '19e94e59-d4fe-4251-8981-b96d0a9f74de',
        value: 'Alex Karp',
      },
    },
    description: 'A simple rich app',
    displayName: 'Rich App',
    defaultRoleUniversalIdentifier: 'b648f87b-1d26-4961-b974-0908fd991061',
    icon: 'IconWorld',
    universalIdentifier: '4ec0391d-18d5-411c-b2f3-266ddc1c3ef7',
    yarnLockChecksum: 'd41d8cd98f00b204e9800998ecf8427e',
    packageJsonChecksum: '2851d0e2c3621a57e1fd103a245b6fde',
    apiClientChecksum: null,
  },
  frontComponents: [
    {
      builtComponentPath: 'src/root.front-component.mjs',
      builtComponentChecksum: '[checksum]',
      componentName: 'RootComponent',
      description: 'A root-level front component',
      name: 'root-component',
      sourceComponentPath: 'src/root.front-component.tsx',
      universalIdentifier: 'a0a1a2a3-a4a5-4000-8000-000000000001',
    },
    {
      builtComponentPath: 'src/components/card.front-component.mjs',
      builtComponentChecksum: '[checksum]',
      componentName: 'CardDisplay',
      description: 'A component using an external component file',
      name: 'card-component',
      sourceComponentPath: 'src/components/card.front-component.tsx',
      universalIdentifier: '88c15ae2-5f87-4a6b-b48f-1974bbe62eb7',
    },
    {
      builtComponentPath: 'src/components/greeting.front-component.mjs',
      builtComponentChecksum: '[checksum]',
      componentName: 'GreetingComponent',
      description: 'A component that uses greeting utility',
      name: 'greeting-component',
      sourceComponentPath: 'src/components/greeting.front-component.tsx',
      universalIdentifier: '370ae182-743f-4ecb-b625-7ac48e21f0e5',
    },
    {
      builtComponentPath: 'src/components/test.front-component.mjs',
      builtComponentChecksum: '[checksum]',
      componentName: 'TestComponent',
      description: 'A test front component',
      name: 'test-component',
      sourceComponentPath: 'src/components/test.front-component.tsx',
      universalIdentifier: 'f1234567-abcd-4000-8000-000000000001',
    },
  ],

  fields: [
    {
      label: 'Post Card',
      name: 'postCard',
      objectUniversalIdentifier: 'e1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5e',
      relationTargetFieldMetadataUniversalIdentifier:
        'a1a2b3c4-0001-4a7b-8c9d-0e1f2a3b4c5d',
      relationTargetObjectMetadataUniversalIdentifier:
        '54b589ca-eeed-4950-a176-358418b85c05',
      type: FieldType.RELATION,
      universalIdentifier: 'a1a2b3c4-0002-4a7b-8c9d-0e1f2a3b4c5d',
      universalSettings: {
        joinColumnName: 'postCardId',
        onDelete: RelationOnDeleteAction.CASCADE,
        relationType: RelationType.MANY_TO_ONE,
      },
    },
    {
      label: 'Post Card Recipients',
      name: 'postCardRecipients',
      objectUniversalIdentifier: '54b589ca-eeed-4950-a176-358418b85c05',
      relationTargetFieldMetadataUniversalIdentifier:
        'a1a2b3c4-0002-4a7b-8c9d-0e1f2a3b4c5d',
      relationTargetObjectMetadataUniversalIdentifier:
        'e1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5e',
      type: FieldType.RELATION,
      universalIdentifier: 'a1a2b3c4-0001-4a7b-8c9d-0e1f2a3b4c5d',
      universalSettings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    {
      label: 'Post Card Recipients',
      name: 'postCardRecipients',
      objectUniversalIdentifier: 'd1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5d',
      relationTargetFieldMetadataUniversalIdentifier:
        'a1a2b3c4-0004-4a7b-8c9d-0e1f2a3b4c5d',
      relationTargetObjectMetadataUniversalIdentifier:
        'e1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5e',
      type: FieldType.RELATION,
      universalIdentifier: 'a1a2b3c4-0003-4a7b-8c9d-0e1f2a3b4c5d',
      universalSettings: {
        relationType: RelationType.ONE_TO_MANY,
      },
    },
    {
      objectUniversalIdentifier: '54b589ca-eeed-4950-a176-358418b85c05',
      description: 'Post card category',
      label: 'Category',
      name: 'category',
      options: [
        {
          color: 'blue',
          id: 'c1d2e3f4-0001-4000-8000-000000000001',
          label: 'Personal',
          position: 0,
          value: 'PERSONAL',
        },
        {
          color: 'green',
          id: 'c1d2e3f4-0002-4000-8000-000000000002',
          label: 'Business',
          position: 1,
          value: 'BUSINESS',
        },
        {
          color: 'orange',
          id: 'c1d2e3f4-0003-4000-8000-000000000003',
          label: 'Promotional',
          position: 2,
          value: 'PROMOTIONAL',
        },
      ],
      type: FieldType.SELECT,
      universalIdentifier: '8b9c0d1e-2f3a-4b5c-6d7e-8f9a0b1c2d3e',
    },
    {
      objectUniversalIdentifier: '54b589ca-eeed-4950-a176-358418b85c05',
      description: 'Priority level for the post card (1-10)',
      label: 'Priority',
      name: 'priority',
      type: FieldType.NUMBER,
      universalIdentifier: '7a8b9c0d-1e2f-3a4b-5c6d-7e8f9a0b1c2d',
    },
    {
      label: 'Recipient',
      name: 'recipient',
      objectUniversalIdentifier: 'e1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5e',
      relationTargetFieldMetadataUniversalIdentifier:
        'a1a2b3c4-0003-4a7b-8c9d-0e1f2a3b4c5d',
      relationTargetObjectMetadataUniversalIdentifier:
        'd1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5d',
      type: FieldType.RELATION,
      universalIdentifier: 'a1a2b3c4-0004-4a7b-8c9d-0e1f2a3b4c5d',
      universalSettings: {
        joinColumnName: 'recipientId',
        onDelete: RelationOnDeleteAction.CASCADE,
        relationType: RelationType.MANY_TO_ONE,
      },
    },
  ],
  objects: [
    {
      description: 'A simple root-level object',
      fields: [
        {
          label: 'Title',
          name: 'title',
          type: FieldType.TEXT,
          universalIdentifier: 'b0b1b2b3-b4b5-4000-8000-000000000002',
        },
        {
          label: 'Body',
          name: 'body',
          type: FieldType.TEXT,
          universalIdentifier: 'b0b1b2b3-b4b5-4000-8000-000000000003',
        },
        {
          defaultValue: 'uuid',
          description: 'Id',
          icon: 'Icon123',
          isNullable: false,
          label: 'Id',
          name: 'id',
          type: FieldMetadataType.UUID,
          universalIdentifier: 'b5830f92-1abe-5ae7-b689-7821dda00b15',
        },
        {
          defaultValue: null,
          description: 'Name',
          icon: 'IconAbc',
          isNullable: true,
          label: 'Name',
          name: 'name',
          type: FieldMetadataType.TEXT,
          universalIdentifier: 'ae2b2e5a-6c8b-5324-b639-8f17e3bc0420',
        },
        {
          defaultValue: 'now',
          description: 'Creation date',
          icon: 'IconCalendar',
          isNullable: false,
          label: 'Creation date',
          name: 'createdAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '7c84a501-41a6-531e-bc5e-8062843f6cba',
        },
        {
          defaultValue: 'now',
          description: 'Last time the record was changed',
          icon: 'IconCalendarClock',
          isNullable: false,
          label: 'Last update',
          name: 'updatedAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '72c2903a-91c9-5f36-8668-b53b083ae4cf',
        },
        {
          defaultValue: null,
          description: 'Deletion date',
          icon: 'IconCalendarClock',
          isNullable: true,
          label: 'Deleted at',
          name: 'deletedAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '007f5d8e-d376-519e-bd07-aea41a53f7d9',
        },
        {
          defaultValue: {
            name: "''",
            source: "'MANUAL'",
          },
          description: 'The creator of the record',
          icon: 'IconCreativeCommonsSa',
          isNullable: false,
          label: 'Created by',
          name: 'createdBy',
          type: FieldMetadataType.ACTOR,
          universalIdentifier: '44053354-0d8b-5d66-bfa8-7e7d221de3db',
        },
        {
          defaultValue: {
            name: "''",
            source: "'MANUAL'",
          },
          description: 'The workspace member who last updated the record',
          icon: 'IconUserCircle',
          isNullable: false,
          label: 'Updated by',
          name: 'updatedBy',
          type: FieldMetadataType.ACTOR,
          universalIdentifier: '38e2c671-cbf5-5773-a04a-e5a2d6c323c8',
        },
      ],
      icon: 'IconNote',
      labelIdentifierFieldMetadataUniversalIdentifier:
        'b0b1b2b3-b4b5-4000-8000-000000000002',
      labelPlural: 'Root notes',
      labelSingular: 'Root note',
      namePlural: 'rootNotes',
      nameSingular: 'rootNote',
      universalIdentifier: 'b0b1b2b3-b4b5-4000-8000-000000000001',
    },
    {
      description: 'Junction object linking post cards to their recipients',
      fields: [
        {
          defaultValue: null,
          icon: 'IconClock',
          isNullable: true,
          label: 'Sent at',
          name: 'sentAt',
          type: FieldType.DATE_TIME,
          universalIdentifier: 'e2a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5e',
        },
        {
          defaultValue: 'uuid',
          description: 'Id',
          icon: 'Icon123',
          isNullable: false,
          label: 'Id',
          name: 'id',
          type: FieldMetadataType.UUID,
          universalIdentifier: '2809d745-deb3-5ac0-8328-ea6256ec22b3',
        },
        {
          defaultValue: null,
          description: 'Name',
          icon: 'IconAbc',
          isNullable: true,
          label: 'Name',
          name: 'name',
          type: FieldMetadataType.TEXT,
          universalIdentifier: 'a6ee6cc8-b9a0-5e23-a39e-bc3fee2aa3d3',
        },
        {
          defaultValue: 'now',
          description: 'Creation date',
          icon: 'IconCalendar',
          isNullable: false,
          label: 'Creation date',
          name: 'createdAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '87ad23b6-b04e-5dc1-9907-c1eca54ea6d6',
        },
        {
          defaultValue: 'now',
          description: 'Last time the record was changed',
          icon: 'IconCalendarClock',
          isNullable: false,
          label: 'Last update',
          name: 'updatedAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '6d7523dc-c097-5b75-96eb-37502d09cc19',
        },
        {
          defaultValue: null,
          description: 'Deletion date',
          icon: 'IconCalendarClock',
          isNullable: true,
          label: 'Deleted at',
          name: 'deletedAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: 'bd4fe2fa-373a-5fdd-ba09-cb5435781e4c',
        },
        {
          defaultValue: {
            name: "''",
            source: "'MANUAL'",
          },
          description: 'The creator of the record',
          icon: 'IconCreativeCommonsSa',
          isNullable: false,
          label: 'Created by',
          name: 'createdBy',
          type: FieldMetadataType.ACTOR,
          universalIdentifier: 'c5026f20-ab7a-54e0-900e-37a2d5381aee',
        },
        {
          defaultValue: {
            name: "''",
            source: "'MANUAL'",
          },
          description: 'The workspace member who last updated the record',
          icon: 'IconUserCircle',
          isNullable: false,
          label: 'Updated by',
          name: 'updatedBy',
          type: FieldMetadataType.ACTOR,
          universalIdentifier: '1dd75ff5-5fd0-51df-b3a3-a12e3aff30df',
        },
      ],
      icon: 'IconLink',
      labelIdentifierFieldMetadataUniversalIdentifier:
        'a6ee6cc8-b9a0-5e23-a39e-bc3fee2aa3d3',
      labelPlural: 'Post Card Recipients',
      labelSingular: 'Post Card Recipient',
      namePlural: 'postCardRecipients',
      nameSingular: 'postCardRecipient',
      universalIdentifier: 'e1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5e',
    },
    {
      description: 'A post card object',
      fields: [
        {
          description: "Postcard's content",
          icon: 'IconAbc',
          label: 'Content',
          name: 'content',
          type: FieldType.TEXT,
          universalIdentifier: '58a0a314-d7ea-4865-9850-7fb84e72f30b',
        },
        {
          icon: 'IconUser',
          label: 'Recipient name',
          name: 'recipientName',
          type: FieldType.FULL_NAME,
          universalIdentifier: 'c6aa31f3-da76-4ac6-889f-475e226009ac',
        },
        {
          icon: 'IconHome',
          label: 'Recipient address',
          name: 'recipientAddress',
          type: FieldType.ADDRESS,
          universalIdentifier: '95045777-a0ad-49ec-98f9-22f9fc0c8266',
        },
        {
          defaultValue: "'DRAFT'",
          icon: 'IconSend',
          label: 'Status',
          name: 'status',
          options: [
            {
              color: 'gray',
              id: 'a1b2c3d4-0001-4000-8000-000000000001',
              label: 'Draft',
              position: 0,
              value: 'DRAFT',
            },
            {
              color: 'orange',
              id: 'a1b2c3d4-0002-4000-8000-000000000002',
              label: 'Sent',
              position: 1,
              value: 'SENT',
            },
            {
              color: 'green',
              id: 'a1b2c3d4-0003-4000-8000-000000000003',
              label: 'Delivered',
              position: 2,
              value: 'DELIVERED',
            },
            {
              color: 'orange',
              id: 'a1b2c3d4-0004-4000-8000-000000000004',
              label: 'Returned',
              position: 3,
              value: 'RETURNED',
            },
          ],
          type: FieldType.SELECT,
          universalIdentifier: '87b675b8-dd8c-4448-b4ca-20e5a2234a1e',
        },
        {
          defaultValue: null,
          icon: 'IconCheck',
          isNullable: true,
          label: 'Delivered at',
          name: 'deliveredAt',
          type: FieldType.DATE_TIME,
          universalIdentifier: 'e06abe72-5b44-4e7f-93be-afc185a3c433',
        },
        {
          defaultValue: 'uuid',
          description: 'Id',
          icon: 'Icon123',
          isNullable: false,
          label: 'Id',
          name: 'id',
          type: FieldMetadataType.UUID,
          universalIdentifier: '56e652a3-fac2-54fd-a379-f01b72758268',
        },
        {
          defaultValue: null,
          description: 'Name',
          icon: 'IconAbc',
          isNullable: true,
          label: 'Name',
          name: 'name',
          type: FieldMetadataType.TEXT,
          universalIdentifier: 'c59a149f-5861-51a3-a924-2bd2fa31daaa',
        },
        {
          defaultValue: 'now',
          description: 'Creation date',
          icon: 'IconCalendar',
          isNullable: false,
          label: 'Creation date',
          name: 'createdAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '236e2ec5-3636-5b97-b19d-f7799cb88d99',
        },
        {
          defaultValue: 'now',
          description: 'Last time the record was changed',
          icon: 'IconCalendarClock',
          isNullable: false,
          label: 'Last update',
          name: 'updatedAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '2cf640eb-09a7-52f2-820b-419071c5ec24',
        },
        {
          defaultValue: null,
          description: 'Deletion date',
          icon: 'IconCalendarClock',
          isNullable: true,
          label: 'Deleted at',
          name: 'deletedAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '2eb62b4a-6888-58ab-9887-a879321fff31',
        },
        {
          defaultValue: {
            name: "''",
            source: "'MANUAL'",
          },
          description: 'The creator of the record',
          icon: 'IconCreativeCommonsSa',
          isNullable: false,
          label: 'Created by',
          name: 'createdBy',
          type: FieldMetadataType.ACTOR,
          universalIdentifier: '36e95d21-9c86-5b6f-8133-a66d09fc8952',
        },
        {
          defaultValue: {
            name: "''",
            source: "'MANUAL'",
          },
          description: 'The workspace member who last updated the record',
          icon: 'IconUserCircle',
          isNullable: false,
          label: 'Updated by',
          name: 'updatedBy',
          type: FieldMetadataType.ACTOR,
          universalIdentifier: 'dc5231a4-e128-57b0-ac9d-723678d9b239',
        },
      ],
      icon: 'IconMail',
      labelIdentifierFieldMetadataUniversalIdentifier:
        '58a0a314-d7ea-4865-9850-7fb84e72f30b',
      labelPlural: 'Post cards',
      labelSingular: 'Post card',
      namePlural: 'postCards',
      nameSingular: 'postCard',
      universalIdentifier: '54b589ca-eeed-4950-a176-358418b85c05',
    },
    {
      description: 'A person or organization that receives post cards',
      fields: [
        {
          icon: 'IconMail',
          label: 'Email',
          name: 'email',
          type: FieldType.EMAILS,
          universalIdentifier: 'd2a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5d',
        },
        {
          icon: 'IconHome',
          label: 'Address',
          name: 'address',
          type: FieldType.ADDRESS,
          universalIdentifier: 'd3a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5d',
        },
        {
          defaultValue: 'uuid',
          description: 'Id',
          icon: 'Icon123',
          isNullable: false,
          label: 'Id',
          name: 'id',
          type: FieldMetadataType.UUID,
          universalIdentifier: '71aa41d7-54d0-5447-bf98-f37435b62bc4',
        },
        {
          defaultValue: null,
          description: 'Name',
          icon: 'IconAbc',
          isNullable: true,
          label: 'Name',
          name: 'name',
          type: FieldMetadataType.TEXT,
          universalIdentifier: 'ff07c707-df79-58fa-91a4-c60c31f90e6e',
        },
        {
          defaultValue: 'now',
          description: 'Creation date',
          icon: 'IconCalendar',
          isNullable: false,
          label: 'Creation date',
          name: 'createdAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '8dd42a57-7aca-5e60-89c1-6e0e430dad43',
        },
        {
          defaultValue: 'now',
          description: 'Last time the record was changed',
          icon: 'IconCalendarClock',
          isNullable: false,
          label: 'Last update',
          name: 'updatedAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: 'a81e915c-f21d-5163-a547-f04029655bf0',
        },
        {
          defaultValue: null,
          description: 'Deletion date',
          icon: 'IconCalendarClock',
          isNullable: true,
          label: 'Deleted at',
          name: 'deletedAt',
          type: FieldMetadataType.DATE_TIME,
          universalIdentifier: '33ba5fa8-dbc3-5a08-b0e0-d85b18ff15e0',
        },
        {
          defaultValue: {
            name: "''",
            source: "'MANUAL'",
          },
          description: 'The creator of the record',
          icon: 'IconCreativeCommonsSa',
          isNullable: false,
          label: 'Created by',
          name: 'createdBy',
          type: FieldMetadataType.ACTOR,
          universalIdentifier: '7c377262-63b7-5a79-ba54-f7b8acd804dc',
        },
        {
          defaultValue: {
            name: "''",
            source: "'MANUAL'",
          },
          description: 'The workspace member who last updated the record',
          icon: 'IconUserCircle',
          isNullable: false,
          label: 'Updated by',
          name: 'updatedBy',
          type: FieldMetadataType.ACTOR,
          universalIdentifier: '8da8e149-b60e-52e2-878d-73d05c8312b2',
        },
      ],
      icon: 'IconUser',
      labelIdentifierFieldMetadataUniversalIdentifier:
        'ff07c707-df79-58fa-91a4-c60c31f90e6e',
      labelPlural: 'Recipients',
      labelSingular: 'Recipient',
      namePlural: 'recipients',
      nameSingular: 'recipient',
      universalIdentifier: 'd1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5d',
    },
  ],
  roles: [
    {
      canBeAssignedToAgents: false,
      canBeAssignedToApiKeys: false,
      canBeAssignedToUsers: true,
      canDestroyAllObjectRecords: false,
      canReadAllObjectRecords: true,
      canSoftDeleteAllObjectRecords: false,
      canUpdateAllObjectRecords: false,
      canUpdateAllSettings: false,
      description: 'A simple root-level role',
      label: 'Root role',
      universalIdentifier: 'c0c1c2c3-c4c5-4000-8000-000000000001',
    },
    {
      canBeAssignedToAgents: false,
      canBeAssignedToApiKeys: false,
      canBeAssignedToUsers: false,
      canDestroyAllObjectRecords: false,
      canReadAllObjectRecords: false,
      canSoftDeleteAllObjectRecords: false,
      canUpdateAllObjectRecords: false,
      canUpdateAllSettings: false,
      description: 'Default role for function Twenty client',
      fieldPermissions: [
        {
          canReadFieldValue: false,
          canUpdateFieldValue: false,
          fieldUniversalIdentifier: '58a0a314-d7ea-4865-9850-7fb84e72f30b',
          objectUniversalIdentifier: '54b589ca-eeed-4950-a176-358418b85c05',
        },
      ],
      label: 'Default function role',
      objectPermissions: [
        {
          canDestroyObjectRecords: false,
          canReadObjectRecords: true,
          canSoftDeleteObjectRecords: false,
          canUpdateObjectRecords: true,
          objectUniversalIdentifier: '54b589ca-eeed-4950-a176-358418b85c05',
        },
      ],
      permissionFlags: [PermissionFlagType.APPLICATIONS],
      universalIdentifier: 'b648f87b-1d26-4961-b974-0908fd991061',
    },
  ],
  views: [
    {
      fields: [
        {
          fieldMetadataUniversalIdentifier:
            'e2a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5e',
          isVisible: true,
          position: 0,
          size: 200,
          universalIdentifier: 'bf1a2b3c-0004-4a7b-8c9d-0e1f2a3b4c5d',
        },
      ],
      icon: 'IconLink',
      name: 'All Post Card Recipients',
      objectUniversalIdentifier: 'e1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5e',
      position: 2,
      type: ViewType.TABLE,
      universalIdentifier: 'b1a2b3c4-0003-4a7b-8c9d-0e1f2a3b4c5d',
    },
    {
      fields: [
        {
          fieldMetadataUniversalIdentifier:
            '58a0a314-d7ea-4865-9850-7fb84e72f30b',
          isVisible: true,
          position: 0,
          size: 200,
          universalIdentifier: 'bf1a2b3c-0001-4a7b-8c9d-0e1f2a3b4c5d',
        },
        {
          fieldMetadataUniversalIdentifier:
            '87b675b8-dd8c-4448-b4ca-20e5a2234a1e',
          isVisible: true,
          position: 1,
          size: 150,
          universalIdentifier: 'bf1a2b3c-0002-4a7b-8c9d-0e1f2a3b4c5d',
        },
      ],
      icon: 'IconMail',
      name: 'All Post Cards',
      objectUniversalIdentifier: '54b589ca-eeed-4950-a176-358418b85c05',
      position: 0,
      type: ViewType.TABLE,
      universalIdentifier: 'b1a2b3c4-0001-4a7b-8c9d-0e1f2a3b4c5d',
    },
    {
      fields: [
        {
          fieldMetadataUniversalIdentifier:
            'd2a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5d',
          isVisible: true,
          position: 0,
          size: 200,
          universalIdentifier: 'bf1a2b3c-0003-4a7b-8c9d-0e1f2a3b4c5d',
        },
      ],
      icon: 'IconUser',
      name: 'All Recipients',
      objectUniversalIdentifier: 'd1a2b3c4-5e6f-4a7b-8c9d-0e1f2a3b4c5d',
      position: 1,
      type: ViewType.TABLE,
      universalIdentifier: 'b1a2b3c4-0002-4a7b-8c9d-0e1f2a3b4c5d',
    },
  ],
  navigationMenuItems: [
    {
      position: 2,
      universalIdentifier: 'c1a2b3c4-0003-4a7b-8c9d-0e1f2a3b4c5d',
      viewUniversalIdentifier: 'b1a2b3c4-0003-4a7b-8c9d-0e1f2a3b4c5d',
    },
    {
      position: 0,
      universalIdentifier: 'c1a2b3c4-0001-4a7b-8c9d-0e1f2a3b4c5d',
      viewUniversalIdentifier: 'b1a2b3c4-0001-4a7b-8c9d-0e1f2a3b4c5d',
    },
    {
      position: 1,
      universalIdentifier: 'c1a2b3c4-0002-4a7b-8c9d-0e1f2a3b4c5d',
      viewUniversalIdentifier: 'b1a2b3c4-0002-4a7b-8c9d-0e1f2a3b4c5d',
    },
  ],
  logicFunctions: [
    {
      builtHandlerChecksum: '[checksum]',
      builtHandlerPath: 'src/root.function.mjs',
      handlerName: 'default.config.handler',
      name: 'root-function',
      sourceHandlerPath: 'src/root.function.ts',
      toolInputSchema: { type: 'object', properties: {} },
      timeoutSeconds: 5,
      httpRouteTriggerSettings: {
        httpMethod: 'GET',
        isAuthRequired: false,
        path: '/root',
      },
      universalIdentifier: 'f0f1f2f3-f4f5-4000-8000-000000000001',
    },
    {
      builtHandlerChecksum: '[checksum]',
      builtHandlerPath: 'src/logic-functions/greeting.function.mjs',
      handlerName: 'default.config.handler',
      name: 'greeting-function',
      sourceHandlerPath: 'src/logic-functions/greeting.function.ts',
      toolInputSchema: { type: 'object', properties: {} },
      timeoutSeconds: 5,
      httpRouteTriggerSettings: {
        httpMethod: 'GET',
        isAuthRequired: false,
        path: '/greet',
      },
      universalIdentifier: '9d412d9e-2caf-487c-8b66-d1585883dd4e',
    },
    {
      builtHandlerChecksum: '[checksum]',
      builtHandlerPath: 'src/logic-functions/lookup-recipient.function.mjs',
      description: 'Look up a recipient by name to find their details',
      handlerName: 'default.config.handler',
      isTool: true,
      name: 'lookup-recipient',
      sourceHandlerPath: 'src/logic-functions/lookup-recipient.function.ts',
      timeoutSeconds: 5,
      toolInputSchema: {
        type: 'object',
        properties: {
          recipientName: {
            type: 'string',
          },
        },
      },
      universalIdentifier: 'a1b2c3d4-1001-4a7b-8c9d-0e1f2a3b4c5d',
    },
    {
      builtHandlerChecksum: '[checksum]',
      builtHandlerPath: 'src/logic-functions/on-post-card-created.function.mjs',
      databaseEventTriggerSettings: {
        eventName: 'postCard.created',
      },
      description: 'Triggered when a new post card is created',
      handlerName: 'default.config.handler',
      name: 'on-post-card-created',
      sourceHandlerPath: 'src/logic-functions/on-post-card-created.function.ts',
      timeoutSeconds: 5,
      toolInputSchema: { type: 'object', properties: {} },
      universalIdentifier: 'a1b2c3d4-db01-4a7b-8c9d-0e1f2a3b4c5d',
    },
    {
      builtHandlerChecksum: '[checksum]',
      builtHandlerPath: 'src/logic-functions/test-function-2.function.mjs',
      handlerName: 'default.config.handler',
      name: 'test-function-2',
      sourceHandlerPath: 'src/logic-functions/test-function-2.function.ts',
      toolInputSchema: { type: 'object', properties: {} },
      timeoutSeconds: 2,
      cronTriggerSettings: {
        pattern: '0 0 1 1 *',
      },
      universalIdentifier: 'eb3ffc98-88ec-45d4-9b4a-56833b219ccb',
    },
    {
      builtHandlerChecksum: '[checksum]',
      builtHandlerPath: 'src/logic-functions/test-function.function.mjs',
      handlerName: 'default.config.handler',
      name: 'test-function',
      sourceHandlerPath: 'src/logic-functions/test-function.function.ts',
      toolInputSchema: { type: 'object', properties: {} },
      timeoutSeconds: 2,
      httpRouteTriggerSettings: {
        forwardedRequestHeaders: ['signature'],
        httpMethod: 'GET',
        isAuthRequired: false,
        path: '/post-card/create',
      },
      universalIdentifier: 'e56d363b-0bdc-4d8a-a393-6f0d1c75bdcf',
    },
  ],
};
