import { type RecordGqlConnection } from '@/object-record/graphql/types/RecordGqlConnection';

export const getWorkflowMock = () => {
  return workflowQueryResult.workflows.edges[0].node;
};

export const getWorkflowVersionsMock = () => {
  return {
    ...getWorkflowMock().versions,
    __typename: 'WorkflowVersionConnection',
    totalCount: 1,
    pageInfo: {
      __typename: 'PageInfo',
      hasNextPage: false,
      hasPreviousPage: false,
      startCursor:
        'eyJjcmVhdGVkQXQiOiIyMDI0LTA5LTE5VDEwOjEwOjA0LjcyNVoiLCJpZCI6ImY2MTg4NDNhLTI2YmUtNGE1NC1hNjBmLWY0Y2U4OGE1OTRmMCJ9',
      endCursor:
        'eyJjcmVhdGVkQXQiOiIyMDI0LTA5LTE5VDEwOjEwOjA0LjcyNVoiLCJpZCI6ImY2MTg4NDNhLTI2YmUtNGE1NC1hNjBmLWY0Y2U4OGE1OTRmMCJ9',
    },
  };
};

export const getWorkflowNodeIdMock = () => {
  return getWorkflowMock().versions.edges[0].node.steps[0].id;
};

export const MOCKED_STEP_ID = '04d5f3bf-9714-400d-ba27-644006a5fb1b';

export const workflowQueryResult = {
  workflows: {
    __typename: 'WorkflowConnection',
    totalCount: 1,
    pageInfo: {
      __typename: 'PageInfo',
      hasNextPage: false,
      hasPreviousPage: false,
      startCursor:
        'eyJwb3NpdGlvbiI6MCwiaWQiOiIyMWQ0NzcyOC0wMmE3LTQzMjEtOWVhNC00NDk3N2MzOTU3OTMifQ==',
      endCursor:
        'eyJwb3NpdGlvbiI6MCwiaWQiOiIyMWQ0NzcyOC0wMmE3LTQzMjEtOWVhNC00NDk3N2MzOTU3OTMifQ==',
    },
    edges: [
      {
        __typename: 'WorkflowEdge',
        cursor:
          'eyJwb3NpdGlvbiI6MCwiaWQiOiIyMWQ0NzcyOC0wMmE3LTQzMjEtOWVhNC00NDk3N2MzOTU3OTMifQ==',
        node: {
          __typename: 'Workflow',
          deletedAt: null,
          id: '21d47728-02a7-4321-9ea4-44977c395793',
          name: 'Test',
          position: 0,
          statuses: ['DRAFT'],
          updatedAt: '2025-01-30T09:54:36.006Z',
          createdBy: {
            __typename: 'Actor',
            source: 'MANUAL',
            workspaceMemberId: '20202020-0687-4c41-b707-ed1bfca972a7',
            name: 'Tim Apple',
          },
          runs: {
            __typename: 'WorkflowRunConnection',
            edges: [],
          },
          versions: {
            __typename: 'WorkflowVersionConnection',
            edges: [
              {
                __typename: 'WorkflowVersionEdge',
                node: {
                  __typename: 'WorkflowVersion',
                  createdAt: '2025-01-30T09:54:34.583Z',
                  deletedAt: null,
                  id: 'e7ee024c-ea25-4558-84b8-6c3533f0c9a5',
                  name: 'v1',
                  position: -1,
                  status: 'DRAFT',
                  steps: [
                    {
                      id: MOCKED_STEP_ID,
                      name: 'Create Record',
                      type: 'CREATE_RECORD',
                      valid: false,
                      settings: {
                        input: {
                          objectName: 'opportunity',
                          objectRecord: {
                            name: 'Opportunity – {{trigger.properties.after.name}}',
                            amount: {
                              amountMicros: 1000000000,
                              currencyCode: 'EUR',
                            },
                          },
                        },
                        outputSchema: {
                          fields: {
                            id: {
                              icon: 'Icon123',
                              type: 'UUID',
                              label: 'Id',
                              value: '123e4567-e89b-12d3-a456-426614174000',
                              isLeaf: true,
                            },
                            name: {
                              icon: 'IconTargetArrow',
                              type: 'TEXT',
                              label: 'Name',
                              value: 'My text',
                              isLeaf: true,
                            },
                            fullName: {
                              icon: 'IconTargetArrow',
                              type: 'TEXT',
                              label: 'Full Name',
                              isLeaf: false,
                              value: {
                                firstName: {
                                  icon: 'IconTargetArrow',
                                  type: 'TEXT',
                                  label: 'Full Name First Name',
                                  value: 'John',
                                  isLeaf: true,
                                },
                                lastName: {
                                  icon: 'IconTargetArrow',
                                  type: 'TEXT',
                                  label: 'Full Name Last Name',
                                  value: 'Doe',
                                  isLeaf: true,
                                },
                              },
                            },
                            stage: {
                              icon: 'IconProgressCheck',
                              type: 'SELECT',
                              label: 'Stage',
                              value: null,
                              isLeaf: true,
                            },
                            amount: {
                              icon: 'IconCurrencyDollar',
                              label: 'Amount',
                              value: {
                                amountMicros: {
                                  type: 'NUMERIC',
                                  label: 'My Amount',
                                  value: null,
                                  isLeaf: true,
                                },
                                currencyCode: {
                                  type: 'TEXT',
                                  label: 'My Currency',
                                  value: 'My text',
                                  isLeaf: true,
                                },
                              },
                              isLeaf: false,
                            },
                            closeDate: {
                              icon: 'IconCalendarEvent',
                              type: 'DATE_TIME',
                              label: 'Close date',
                              value: '01/23/2025 15:16',
                              isLeaf: true,
                            },
                            createdAt: {
                              icon: 'IconCalendar',
                              type: 'DATE_TIME',
                              label: 'Creation date',
                              value: '01/23/2025 15:16',
                              isLeaf: true,
                            },
                            createdBy: {
                              icon: 'IconCreativeCommonsSa',
                              label: 'Created by',
                              value: {
                                name: {
                                  type: 'TEXT',
                                  label: ' Name',
                                  value: 'My text',
                                  isLeaf: true,
                                },
                                source: {
                                  type: 'SELECT',
                                  label: ' Source',
                                  value: null,
                                  isLeaf: true,
                                },
                                workspaceMemberId: {
                                  type: 'UUID',
                                  label: ' Workspace Member Id',
                                  value: '123e4567-e89b-12d3-a456-426614174000',
                                  isLeaf: true,
                                },
                              },
                              isLeaf: false,
                            },
                            deletedAt: {
                              icon: 'IconCalendarMinus',
                              type: 'DATE_TIME',
                              label: 'Deleted at',
                              value: '01/23/2025 15:16',
                              isLeaf: true,
                            },
                            updatedAt: {
                              icon: 'IconCalendarClock',
                              type: 'DATE_TIME',
                              label: 'Last update',
                              value: '01/23/2025 15:16',
                              isLeaf: true,
                            },
                            salary: {
                              icon: 'IconMoneybag',
                              type: 'NUMBER',
                              label: 'Salary',
                              value: 1000000000,
                              isLeaf: true,
                            },
                            address: {
                              isLeaf: false,
                              value: {
                                street1: {
                                  isLeaf: true,
                                  label: 'Street 1',
                                  value: '123 Main St',
                                },
                                street2: {
                                  isLeaf: true,
                                  label: 'Street 2',
                                  value: 'Apt 1',
                                },
                                city: {
                                  isLeaf: true,
                                  label: 'My City',
                                  value: 'San Francisco',
                                },
                                state: {
                                  isLeaf: true,
                                  label: 'My State',
                                  value: 'CA',
                                },
                                country: {
                                  isLeaf: true,
                                  label: 'My Country',
                                  value: 'United States',
                                },
                                postcode: {
                                  isLeaf: true,
                                  label: 'My Postcode',
                                  value: '94101',
                                },
                                lat: {
                                  isLeaf: true,
                                  label: 'My Lat',
                                  value: 37.774929,
                                },
                                lng: {
                                  isLeaf: true,
                                  label: 'My Lng',
                                  value: -122.419418,
                                },
                              },
                            },
                            phone: {
                              isLeaf: false,
                              label: 'Phone',
                              value: {
                                countryCode: {
                                  isLeaf: true,
                                  label: 'My Country Code',
                                  value: '+1',
                                },
                                number: {
                                  isLeaf: true,
                                  label: 'My Number',
                                  value: '1234567890',
                                },
                              },
                            },
                          },
                          object: {
                            icon: 'IconTargetArrow',
                            label: 'Opportunity',
                            value: 'An opportunity',
                            isLeaf: true,
                            fieldIdName: 'id',
                            nameSingular: 'opportunity',
                          },
                          _outputSchemaType: 'RECORD',
                        },
                        errorHandlingOptions: {
                          retryOnFailure: {
                            value: false,
                          },
                          continueOnFailure: {
                            value: false,
                          },
                        },
                      },
                      __typename: 'WorkflowAction',
                    },
                  ],
                  trigger: {
                    type: 'DATABASE_EVENT',
                    settings: {
                      eventName: 'company.created',
                      outputSchema: {
                        userId: {
                          type: 'string',
                          label: 'User ID',
                          value: '372d0342-f9d2-4e7f-b497-0e6d0b720188',
                          isLeaf: true,
                        },
                        recordId: {
                          type: 'string',
                          label: 'Record ID',
                          value: '03368795-6d12-402c-809d-7a1b2a5cd0e3',
                          isLeaf: true,
                        },
                        properties: {
                          label: 'Record Fields',
                          value: {
                            after: {
                              label: 'After Creation',
                              value: {
                                fields: {
                                  id: {
                                    icon: 'Icon123',
                                    type: 'UUID',
                                    label: 'Id',
                                    value:
                                      '123e4567-e89b-12d3-a456-426614174000',
                                    isLeaf: true,
                                  },
                                  name: {
                                    icon: 'IconBuildingSkyscraper',
                                    type: 'TEXT',
                                    label: 'Name',
                                    value: 'My text',
                                    isLeaf: true,
                                  },
                                  xLink: {
                                    icon: 'IconBrandX',
                                    label: 'X',
                                    value: {
                                      primaryLinkUrl: {
                                        type: 'TEXT',
                                        label: ' Primary Link Url',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      secondaryLinks: {
                                        type: 'RAW_JSON',
                                        label: ' Secondary Links',
                                        value: null,
                                        isLeaf: true,
                                      },
                                      primaryLinkLabel: {
                                        type: 'TEXT',
                                        label: ' Primary Link Label',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                    },
                                    isLeaf: false,
                                  },
                                  address: {
                                    icon: 'IconMap',
                                    label: 'Address',
                                    value: {
                                      addressLat: {
                                        type: 'NUMERIC',
                                        label: ' Address Lat',
                                        value: null,
                                        isLeaf: true,
                                      },
                                      addressLng: {
                                        type: 'NUMERIC',
                                        label: ' Address Lng',
                                        value: null,
                                        isLeaf: true,
                                      },
                                      addressCity: {
                                        type: 'TEXT',
                                        label: ' Address City',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      addressState: {
                                        type: 'TEXT',
                                        label: ' Address State',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      addressCountry: {
                                        type: 'TEXT',
                                        label: ' Address Country',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      addressStreet1: {
                                        type: 'TEXT',
                                        label: ' Address Street1',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      addressStreet2: {
                                        type: 'TEXT',
                                        label: ' Address Street2',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      addressPostcode: {
                                        type: 'TEXT',
                                        label: ' Address Postcode',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                    },
                                    isLeaf: false,
                                  },
                                  tagline: {
                                    icon: 'IconAdCircle',
                                    type: 'TEXT',
                                    label: 'Tagline',
                                    value: 'My text',
                                    isLeaf: true,
                                  },
                                  createdAt: {
                                    icon: 'IconCalendar',
                                    type: 'DATE_TIME',
                                    label: 'Creation date',
                                    value: '01/23/2025 15:16',
                                    isLeaf: true,
                                  },
                                  createdBy: {
                                    icon: 'IconCreativeCommonsSa',
                                    label: 'Created by',
                                    value: {
                                      name: {
                                        type: 'TEXT',
                                        label: ' Name',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      source: {
                                        type: 'SELECT',
                                        label: ' Source',
                                        value: null,
                                        isLeaf: true,
                                      },
                                      workspaceMemberId: {
                                        type: 'UUID',
                                        label: ' Workspace Member Id',
                                        value:
                                          '123e4567-e89b-12d3-a456-426614174000',
                                        isLeaf: true,
                                      },
                                    },
                                    isLeaf: false,
                                  },
                                  deletedAt: {
                                    icon: 'IconCalendarMinus',
                                    type: 'DATE_TIME',
                                    label: 'Deleted at',
                                    value: '01/23/2025 15:16',
                                    isLeaf: true,
                                  },
                                  employees: {
                                    icon: 'IconUsers',
                                    type: 'NUMBER',
                                    label: 'Employees',
                                    value: 20,
                                    isLeaf: true,
                                  },
                                  updatedAt: {
                                    icon: 'IconCalendarClock',
                                    type: 'DATE_TIME',
                                    label: 'Last update',
                                    value: '01/23/2025 15:16',
                                    isLeaf: true,
                                  },
                                  domainName: {
                                    icon: 'IconLink',
                                    label: 'Domain Name',
                                    value: {
                                      primaryLinkUrl: {
                                        type: 'TEXT',
                                        label: ' Primary Link Url',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      secondaryLinks: {
                                        type: 'RAW_JSON',
                                        label: ' Secondary Links',
                                        value: null,
                                        isLeaf: true,
                                      },
                                      primaryLinkLabel: {
                                        type: 'TEXT',
                                        label: ' Primary Link Label',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                    },
                                    isLeaf: false,
                                  },
                                  introVideo: {
                                    icon: 'IconVideo',
                                    label: 'Intro Video',
                                    value: {
                                      primaryLinkUrl: {
                                        type: 'TEXT',
                                        label: ' Primary Link Url',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      secondaryLinks: {
                                        type: 'RAW_JSON',
                                        label: ' Secondary Links',
                                        value: null,
                                        isLeaf: true,
                                      },
                                      primaryLinkLabel: {
                                        type: 'TEXT',
                                        label: ' Primary Link Label',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                    },
                                    isLeaf: false,
                                  },
                                  workPolicy: {
                                    icon: 'IconHome',
                                    type: 'MULTI_SELECT',
                                    label: 'Work Policy',
                                    value: null,
                                    isLeaf: true,
                                  },
                                  linkedinLink: {
                                    icon: 'IconBrandLinkedin',
                                    label: 'Linkedin',
                                    value: {
                                      primaryLinkUrl: {
                                        type: 'TEXT',
                                        label: ' Primary Link Url',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                      secondaryLinks: {
                                        type: 'RAW_JSON',
                                        label: ' Secondary Links',
                                        value: null,
                                        isLeaf: true,
                                      },
                                      primaryLinkLabel: {
                                        type: 'TEXT',
                                        label: ' Primary Link Label',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                    },
                                    isLeaf: false,
                                  },
                                  visaSponsorship: {
                                    icon: 'IconBrandVisa',
                                    type: 'BOOLEAN',
                                    label: 'Visa Sponsorship',
                                    value: true,
                                    isLeaf: true,
                                  },
                                  idealCustomerProfile: {
                                    icon: 'IconTarget',
                                    type: 'BOOLEAN',
                                    label: 'ICP',
                                    value: true,
                                    isLeaf: true,
                                  },
                                  annualRecurringRevenue: {
                                    icon: 'IconMoneybag',
                                    label: 'ARR',
                                    value: {
                                      amountMicros: {
                                        type: 'NUMERIC',
                                        label: ' Amount Micros',
                                        value: null,
                                        isLeaf: true,
                                      },
                                      currencyCode: {
                                        type: 'TEXT',
                                        label: ' Currency Code',
                                        value: 'My text',
                                        isLeaf: true,
                                      },
                                    },
                                    isLeaf: false,
                                  },
                                },
                                object: {
                                  icon: 'IconBuildingSkyscraper',
                                  label: 'Company',
                                  value: 'A company',
                                  isLeaf: true,
                                  fieldIdName: 'id',
                                  nameSingular: 'company',
                                },
                                _outputSchemaType: 'RECORD',
                              },
                              isLeaf: false,
                            },
                          },
                          isLeaf: false,
                        },
                        objectMetadata: {
                          label: 'Object Metadata',
                          value: {
                            id: {
                              value: '54c2039b-217a-43de-937e-af801e553c52',
                              isLeaf: true,
                            },
                            icon: {
                              value: 'IconBuildingSkyscraper',
                              isLeaf: true,
                            },
                            fields: {
                              value: [
                                {
                                  id: 'bd5cab87-e880-453d-9064-be3c1524485c',
                                  icon: 'IconBuildingSkyscraper',
                                  name: 'name',
                                  type: 'TEXT',
                                  label: 'Name',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: false,
                                  standardId:
                                    '20202020-4d99-4e2e-a84c-4a27837b1ece',
                                  description: 'The company name',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: "''",
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'e142ecbd-b374-42a0-a5d0-48bb67b8ffd5',
                                  icon: 'IconLink',
                                  name: 'domainName',
                                  type: 'LINKS',
                                  label: 'Domain Name',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: true,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: false,
                                  standardId:
                                    '20202020-0c28-43d8-8ba5-3659924d3489',
                                  description:
                                    'The company website URL. We use this url to fetch the company icon',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: {
                                    primaryLinkUrl: "''",
                                    secondaryLinks: "'[]'",
                                    primaryLinkLabel: "''",
                                  },
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'fe4ff2ee-1f58-458f-b880-e2b8ad4a2b7b',
                                  icon: 'IconUsers',
                                  name: 'employees',
                                  type: 'NUMBER',
                                  label: 'Employees',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-8965-464a-8a75-74bafc152a0b',
                                  description:
                                    'Number of employees in the company',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'd2088726-8c87-4a13-92f9-ad4e97f0a32c',
                                  icon: 'IconBrandLinkedin',
                                  name: 'linkedinLink',
                                  type: 'LINKS',
                                  label: 'Linkedin',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-ebeb-4beb-b9ad-6848036fb451',
                                  description: 'The company Linkedin account',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: {
                                    primaryLinkUrl: "''",
                                    secondaryLinks: "'[]'",
                                    primaryLinkLabel: "''",
                                  },
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '02f4c961-cd08-4573-a1a0-f0188caf58c1',
                                  icon: 'IconBrandX',
                                  name: 'xLink',
                                  type: 'LINKS',
                                  label: 'X',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-6f64-4fd9-9580-9c1991c7d8c3',
                                  description: 'The company Twitter/X account',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: {
                                    primaryLinkUrl: "''",
                                    secondaryLinks: "'[]'",
                                    primaryLinkLabel: "''",
                                  },
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '1d691f1b-a196-41c5-b8cb-8656f1966c44',
                                  icon: 'IconMoneybag',
                                  name: 'annualRecurringRevenue',
                                  type: 'CURRENCY',
                                  label: 'ARR',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-602a-495c-9776-f5d5b11d227b',
                                  description:
                                    'Annual Recurring Revenue: The actual or estimated annual revenue of the company',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: {
                                    amountMicros: null,
                                    currencyCode: "''",
                                  },
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '841895d3-b50f-47a0-903c-3b3c0f068359',
                                  icon: 'IconMap',
                                  name: 'address',
                                  type: 'ADDRESS',
                                  label: 'Address',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-c5ce-4adc-b7b6-9c0979fc55e7',
                                  description: 'Address of the company',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: {
                                    addressLat: null,
                                    addressLng: null,
                                    addressCity: "''",
                                    addressState: "''",
                                    addressCountry: "''",
                                    addressStreet1: "''",
                                    addressStreet2: "''",
                                    addressPostcode: "''",
                                  },
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '821426fa-c357-41b7-a484-2923a691a217',
                                  icon: 'IconTarget',
                                  name: 'idealCustomerProfile',
                                  type: 'BOOLEAN',
                                  label: 'ICP',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: false,
                                  standardId:
                                    '20202020-ba6b-438a-8213-2c5ba28d76a2',
                                  description:
                                    'Ideal Customer Profile:  Indicates whether the company is the most suitable and valuable customer for you',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: false,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'd125f27e-5f9a-49d0-bbb3-42875eaa13a4',
                                  icon: 'IconHierarchy2',
                                  name: 'position',
                                  type: 'POSITION',
                                  label: 'Position',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: true,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: false,
                                  standardId:
                                    '20202020-9b4e-462b-991d-a0ee33326454',
                                  description: 'Company record position',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: 0,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'bab1bdca-4ba4-41d6-a125-d9d77dd158a5',
                                  icon: 'IconCreativeCommonsSa',
                                  name: 'createdBy',
                                  type: 'ACTOR',
                                  label: 'Created by',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: false,
                                  standardId:
                                    '20202020-fabc-451d-ab7d-412170916baa',
                                  description: 'The creator of the record',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: {
                                    name: "''",
                                    source: "'MANUAL'",
                                  },
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '16862c9a-affa-4266-b3ac-898868976f07',
                                  icon: 'IconUser',
                                  name: 'searchVector',
                                  type: 'TS_VECTOR',
                                  label: 'Search vector',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: true,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '85c71601-72f9-4b7b-b343-d46100b2c74d',
                                  description:
                                    'Field used for full-text search',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'a97456c7-d9b4-4ae5-9ce5-c9344f566bea',
                                  icon: 'Icon123',
                                  name: 'id',
                                  type: 'UUID',
                                  label: 'Id',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: true,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: false,
                                  standardId:
                                    '20202020-eda0-4cee-9577-3eb357e3c22b',
                                  description: 'Id',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: 'uuid',
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '3b2fa0b4-eba0-4d21-8e89-6e8718fef5ea',
                                  icon: 'IconCalendar',
                                  name: 'createdAt',
                                  type: 'DATE_TIME',
                                  label: 'Creation date',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: {
                                    displayFormat: 'RELATIVE',
                                  },
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: false,
                                  standardId:
                                    '20202020-66ac-4502-9975-e4d959c50311',
                                  description: 'Creation date',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: 'now',
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '49347ab4-7c53-4275-91ec-556522722845',
                                  icon: 'IconCalendarClock',
                                  name: 'updatedAt',
                                  type: 'DATE_TIME',
                                  label: 'Last update',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: {
                                    displayFormat: 'RELATIVE',
                                  },
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: false,
                                  standardId:
                                    '20202020-d767-4622-bdcf-d8a084834d86',
                                  description:
                                    'Last time the record was changed',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: 'now',
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '4727d3c3-4c05-400a-92d0-f371c21887fe',
                                  icon: 'IconCalendarMinus',
                                  name: 'deletedAt',
                                  type: 'DATE_TIME',
                                  label: 'Deleted at',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: {
                                    displayFormat: 'RELATIVE',
                                  },
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-b9a7-48d8-8387-b9a3090a50ec',
                                  description:
                                    'Date when the record was deleted',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'af45f003-5432-45bd-86cf-2aebf3a0489c',
                                  icon: 'IconUsers',
                                  name: 'people',
                                  type: 'RELATION',
                                  label: 'People',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-3213-4ddf-9494-6422bcff8d7c',
                                  description: 'People linked to the company.',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'cba9e1df-1122-45d2-8932-17cc755c0e2f',
                                  icon: 'IconUserCircle',
                                  name: 'accountOwnerId',
                                  type: 'UUID',
                                  label: 'Account Owner id (foreign key)',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: true,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-cce0-424e-8028-91f50eb9c768',
                                  description:
                                    'Your team member responsible for managing the company account id foreign key',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '929e94d6-5a22-4c35-bb63-b6db11182213',
                                  icon: 'IconUserCircle',
                                  name: 'accountOwner',
                                  type: 'RELATION',
                                  label: 'Account Owner',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-95b8-4e10-9881-edb5d4765f9d',
                                  description:
                                    'Your team member responsible for managing the company account',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'afaa09a3-9c32-486b-80a6-e5513b31a92e',
                                  icon: 'IconCheckbox',
                                  name: 'taskTargets',
                                  type: 'RELATION',
                                  label: 'Tasks',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-cb17-4a61-8f8f-3be6730480de',
                                  description: 'Tasks tied to the company',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '1143bd63-a522-4902-bfef-e097dc675ef9',
                                  icon: 'IconNotes',
                                  name: 'noteTargets',
                                  type: 'RELATION',
                                  label: 'Notes',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-bae0-4556-a74a-a9c686f77a88',
                                  description: 'Notes tied to the company',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '9af1d970-34a0-482d-bb35-394911bfad6f',
                                  icon: 'IconTargetArrow',
                                  name: 'opportunities',
                                  type: 'RELATION',
                                  label: 'Opportunities',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-add3-4658-8e23-d70dccb6d0ec',
                                  description:
                                    'Opportunities linked to the company.',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '045b6740-2a29-4b3a-a0a8-c722dec34d5f',
                                  icon: 'IconHeart',
                                  name: 'favorites',
                                  type: 'RELATION',
                                  label: 'Favorites',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: true,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-4d1d-41ac-b13b-621631298d55',
                                  description:
                                    'Favorites linked to the company',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '2288f29b-4d6f-40bd-86af-586858147293',
                                  icon: 'IconFileImport',
                                  name: 'attachments',
                                  type: 'RELATION',
                                  label: 'Attachments',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-c1b5-4120-b0f0-987ca401ed53',
                                  description:
                                    'Attachments linked to the company',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '701fc8d5-17cc-45d1-b445-b4903ea4ec45',
                                  icon: 'IconIconTimelineEvent',
                                  name: 'timelineActivities',
                                  type: 'RELATION',
                                  label: 'Timeline Activities',
                                  options: null,
                                  isActive: true,
                                  isCustom: false,
                                  isSystem: true,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:10.256Z',
                                  updatedAt: '2025-01-30T09:40:10.256Z',
                                  isNullable: true,
                                  standardId:
                                    '20202020-0414-4daf-9c0d-64fe7b27f89f',
                                  description:
                                    'Timeline Activities linked to the company',
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: 'da73a2d3-45f5-4b5d-8271-fc90f9c01e95',
                                  icon: 'IconAdCircle',
                                  name: 'tagline',
                                  type: 'TEXT',
                                  label: 'Tagline',
                                  options: null,
                                  isActive: true,
                                  isCustom: true,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:15.729Z',
                                  updatedAt: '2025-01-30T09:40:15.729Z',
                                  isNullable: false,
                                  standardId: null,
                                  description: "Company's Tagline",
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: "''",
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '99f04aff-43a8-4d53-969e-8dcbe3623cb1',
                                  icon: 'IconVideo',
                                  name: 'introVideo',
                                  type: 'LINKS',
                                  label: 'Intro Video',
                                  options: null,
                                  isActive: true,
                                  isCustom: true,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:15.828Z',
                                  updatedAt: '2025-01-30T09:40:15.828Z',
                                  isNullable: true,
                                  standardId: null,
                                  description: "Company's Intro Video",
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: {
                                    primaryLinkUrl: "''",
                                    secondaryLinks: "'[]'",
                                    primaryLinkLabel: "''",
                                  },
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '145ad214-3e8a-4d9d-a458-a42d74767e80',
                                  icon: 'IconHome',
                                  name: 'workPolicy',
                                  type: 'MULTI_SELECT',
                                  label: 'Work Policy',
                                  options: [
                                    {
                                      id: '41f67468-d763-4d5d-9884-dac704d0338f',
                                      color: 'green',
                                      label: 'On-Site',
                                      value: 'ON_SITE',
                                      position: 0,
                                    },
                                    {
                                      id: '8946f5cb-4894-4247-82fb-86b641f19949',
                                      color: 'turquoise',
                                      label: 'Hybrid',
                                      value: 'HYBRID',
                                      position: 1,
                                    },
                                    {
                                      id: '450f8fc8-d91e-46fc-8d09-c9ee57d5ddde',
                                      color: 'sky',
                                      label: 'Remote Work',
                                      value: 'REMOTE_WORK',
                                      position: 2,
                                    },
                                  ],
                                  isActive: true,
                                  isCustom: true,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:15.935Z',
                                  updatedAt: '2025-01-30T09:40:15.935Z',
                                  isNullable: true,
                                  standardId: null,
                                  description: "Company's Work Policy",
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: null,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                                {
                                  id: '7f60dc30-8797-474f-abd5-303b97ffdd68',
                                  icon: 'IconBrandVisa',
                                  name: 'visaSponsorship',
                                  type: 'BOOLEAN',
                                  label: 'Visa Sponsorship',
                                  options: null,
                                  isActive: true,
                                  isCustom: true,
                                  isSystem: false,
                                  isUnique: false,
                                  settings: null,
                                  createdAt: '2025-01-30T09:40:16.034Z',
                                  updatedAt: '2025-01-30T09:40:16.034Z',
                                  isNullable: true,
                                  standardId: null,
                                  description:
                                    "Company's Visa Sponsorship Policy",
                                  workspaceId:
                                    '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                                  defaultValue: false,
                                  objectMetadataId:
                                    '54c2039b-217a-43de-937e-af801e553c52',
                                  isLabelSyncedWithName: false,
                                  relationTargetFieldMetadataId: null,
                                  relationTargetObjectMetadataId: null,
                                },
                              ],
                              isLeaf: true,
                            },
                            isActive: {
                              value: true,
                              isLeaf: true,
                            },
                            isCustom: {
                              value: false,
                              isLeaf: true,
                            },
                            isRemote: {
                              value: false,
                              isLeaf: true,
                            },
                            isSystem: {
                              value: false,
                              isLeaf: true,
                            },
                            shortcut: {
                              value: 'C',
                              isLeaf: true,
                            },
                            createdAt: {
                              value: '2025-01-30T09:40:10.256Z',
                              isLeaf: true,
                            },
                            updatedAt: {
                              value: '2025-01-30T09:40:10.256Z',
                              isLeaf: true,
                            },
                            namePlural: {
                              value: 'companies',
                              isLeaf: true,
                            },
                            standardId: {
                              value: '20202020-b374-4779-a561-80086cb2e17f',
                              isLeaf: true,
                            },
                            description: {
                              value: 'A company',
                              isLeaf: true,
                            },
                            labelPlural: {
                              value: 'Companies',
                              isLeaf: true,
                            },
                            workspaceId: {
                              value: '3b8e6458-5fc1-4e63-8563-008ccddaa6db',
                              isLeaf: true,
                            },
                            nameSingular: {
                              value: 'company',
                              isLeaf: true,
                            },
                            isAuditLogged: {
                              value: true,
                              isLeaf: true,
                            },
                            labelSingular: {
                              value: 'Company',
                              isLeaf: true,
                            },
                            targetTableName: {
                              value: 'DEPRECATED',
                              isLeaf: true,
                            },
                            isLabelSyncedWithName: {
                              value: false,
                              isLeaf: true,
                            },
                            imageIdentifierFieldMetadataId: {
                              value: null,
                              isLeaf: true,
                            },
                            labelIdentifierFieldMetadataId: {
                              value: 'bd5cab87-e880-453d-9064-be3c1524485c',
                              isLeaf: true,
                            },
                          },
                          isLeaf: false,
                        },
                        workspaceMemberId: {
                          type: 'string',
                          label: 'Workspace Member ID',
                          value: '1628e305-0b91-49f5-a1d5-39cffb5cdb6b',
                          isLeaf: true,
                        },
                      },
                    },
                  },
                  updatedAt: '2025-01-30T14:08:04.703Z',
                  workflowId: '21d47728-02a7-4321-9ea4-44977c395793',
                },
              },
            ],
          },
        },
      },
    ],
  },
} satisfies { workflows: RecordGqlConnection };
