import { type ObjectMetadataItem } from '@/object-metadata/types/ObjectMetadataItem';
import { SettingsRolePermissionsObjectLevelOverrideCellContainer } from '@/settings/roles/role-permissions/object-level-permissions/components/SettingsRolePermissionsObjectLevelOverrideCellContainer';
import { SettingsRolePermissionsObjectLevelSeeFieldsValueForObject } from '@/settings/roles/role-permissions/object-level-permissions/components/SettingsRolePermissionsObjectLevelSeeFieldsValueForObject';
import { SettingsRolePermissionsObjectLevelTableRowOptionsDropdown } from '@/settings/roles/role-permissions/object-level-permissions/components/SettingsRolePermissionsObjectLevelTableRowOptionsDropdown';
import { SettingsRolePermissionsObjectLevelUpdateFieldsValueForObject } from '@/settings/roles/role-permissions/object-level-permissions/components/SettingsRolePermissionsObjectLevelUpdateFieldsValueForObject';
import { OBJECT_LEVEL_PERMISSION_TABLE_GRID_AUTO_COLUMNS } from '@/settings/roles/role-permissions/object-level-permissions/constants/ObjectLevelPermissionTableGridAutoColumns';
import { TableCell } from '@/ui/layout/table/components/TableCell';
import { TableRow } from '@/ui/layout/table/components/TableRow';
import { useTheme } from '@emotion/react';
import styled from '@emotion/styled';
import { SettingsPath } from 'twenty-shared/types';
import { getSettingsPath } from 'twenty-shared/utils';
import { OverflowingTextWithTooltip, useIcons } from 'twenty-ui/display';

const StyledNameTableCell = styled(TableCell)`
  color: ${({ theme }) => theme.font.color.primary};
  gap: ${({ theme }) => theme.spacing(1)};
`;

const StyledNameLabel = styled.div`
  white-space: nowrap;
  text-overflow: ellipsis;
  overflow: hidden;
`;

const StyledOptionsTableCell = styled(TableCell)`
  justify-content: flex-end;
  padding-right: ${({ theme }) => theme.spacing(1)};
`;

type SettingsRolePermissionsObjectLevelTableRowProps = {
  objectMetadataItem: ObjectMetadataItem;
  roleId: string;
  isEditable?: boolean;
  fromAgentId?: string;
};

export const SettingsRolePermissionsObjectLevelTableRow = ({
  objectMetadataItem,
  roleId,
  isEditable = true,
  fromAgentId,
}: SettingsRolePermissionsObjectLevelTableRowProps) => {
  const { getIcon } = useIcons();
  const theme = useTheme();

  const Icon = getIcon(objectMetadataItem.icon);

  const objectLabelPlural = objectMetadataItem.labelPlural;
  const navigationPath = getSettingsPath(SettingsPath.RoleObjectLevel, {
    roleId: roleId,
    objectMetadataId: objectMetadataItem.id,
  });

  const navigationUrl = fromAgentId
    ? `${navigationPath}?fromAgent=${fromAgentId}`
    : navigationPath;

  return (
    <TableRow
      to={isEditable ? navigationUrl : undefined}
      gridAutoColumns={OBJECT_LEVEL_PERMISSION_TABLE_GRID_AUTO_COLUMNS}
    >
      <StyledNameTableCell>
        {!!Icon && (
          <Icon
            style={{ minWidth: theme.icon.size.md }}
            size={theme.icon.size.md}
            stroke={theme.icon.stroke.sm}
          />
        )}
        <StyledNameLabel title={objectLabelPlural}>
          <OverflowingTextWithTooltip text={objectLabelPlural} />
        </StyledNameLabel>
      </StyledNameTableCell>
      <TableCell>
        <SettingsRolePermissionsObjectLevelOverrideCellContainer
          objectMetadataItem={objectMetadataItem}
          roleId={roleId}
          objectLabel={objectLabelPlural}
        />
      </TableCell>
      <TableCell>
        <SettingsRolePermissionsObjectLevelSeeFieldsValueForObject
          roleId={roleId}
          objectMetadataItem={objectMetadataItem}
        />
      </TableCell>
      <TableCell>
        <SettingsRolePermissionsObjectLevelUpdateFieldsValueForObject
          roleId={roleId}
          objectMetadataItem={objectMetadataItem}
        />
      </TableCell>
      <TableCell></TableCell>
      <StyledOptionsTableCell>
        <SettingsRolePermissionsObjectLevelTableRowOptionsDropdown
          roleId={roleId}
          objectMetadataId={objectMetadataItem.id}
          objectPermissionDetailUrl={navigationUrl}
          isEditable={isEditable}
        />
      </StyledOptionsTableCell>
    </TableRow>
  );
};
