import {
  CURRENCY_CODE_LABELS,
  type CurrencyCode,
} from 'twenty-shared/constants';
import {
  IconCoins,
  IconCurrencyAfghani,
  IconCurrencyBahraini,
  IconCurrencyBaht,
  IconCurrencyDinar,
  IconCurrencyDirham,
  IconCurrencyDollar,
  IconCurrencyDollarAustralian,
  IconCurrencyDollarBrunei,
  IconCurrencyDollarCanadian,
  IconCurrencyDollarGuyanese,
  IconCurrencyDollarSingapore,
  IconCurrencyDong,
  IconCurrencyDram,
  IconCurrencyEuro,
  IconCurrencyFlorin,
  IconCurrencyForint,
  IconCurrencyFrank,
  IconCurrencyGuarani,
  IconCurrencyHryvnia,
  IconCurrencyIranianRial,
  IconCurrencyKip,
  IconCurrencyKroneCzech,
  IconCurrencyKroneDanish,
  IconCurrencyKroneSwedish,
  IconCurrencyLari,
  IconCurrencyLeu,
  IconCurrencyLira,
  IconCurrencyLyd,
  IconCurrencyManat,
  IconCurrencyNaira,
  IconCurrencyPaanga,
  IconCurrencyPeso,
  IconCurrencyPound,
  IconCurrencyQuetzal,
  IconCurrencyReal,
  IconCurrencyRenminbi,
  IconCurrencyRiyal,
  IconCurrencyRubel,
  IconCurrencyRufiyaa,
  IconCurrencyRupee,
  IconCurrencyRupeeNepalese,
  IconCurrencyShekel,
  IconCurrencySom,
  IconCurrencyTaka,
  IconCurrencyTenge,
  IconCurrencyTugrik,
  IconCurrencyWon,
  IconCurrencyYen,
  IconCurrencyYuan,
  IconCurrencyZloty,
  type IconComponent,
} from 'twenty-ui/display';
export const SETTINGS_FIELD_CURRENCY_CODES: Record<
  CurrencyCode,
  { label: string; Icon: IconComponent }
> = {
  AED: { label: CURRENCY_CODE_LABELS.AED.label, Icon: IconCurrencyDirham },
  AFN: { label: CURRENCY_CODE_LABELS.AFN.label, Icon: IconCurrencyAfghani },
  ALL: { label: CURRENCY_CODE_LABELS.ALL.label, Icon: IconCurrencyLeu },
  AMD: { label: CURRENCY_CODE_LABELS.AMD.label, Icon: IconCurrencyDram },
  ANG: { label: CURRENCY_CODE_LABELS.ANG.label, Icon: IconCurrencyFlorin },
  AOA: { label: CURRENCY_CODE_LABELS.AOA.label, Icon: IconCoins },
  ARS: { label: CURRENCY_CODE_LABELS.ARS.label, Icon: IconCoins },
  AUD: {
    label: CURRENCY_CODE_LABELS.AUD.label,
    Icon: IconCurrencyDollarAustralian,
  },
  AWG: { label: CURRENCY_CODE_LABELS.AWG.label, Icon: IconCurrencyFlorin },
  AZN: { label: CURRENCY_CODE_LABELS.AZN.label, Icon: IconCurrencyManat },
  BAM: { label: CURRENCY_CODE_LABELS.BAM.label, Icon: IconCoins },
  BBD: { label: CURRENCY_CODE_LABELS.BBD.label, Icon: IconCurrencyDollar },
  BDT: { label: CURRENCY_CODE_LABELS.BDT.label, Icon: IconCurrencyTaka },
  BGN: { label: CURRENCY_CODE_LABELS.BGN.label, Icon: IconCoins },
  BHD: { label: CURRENCY_CODE_LABELS.BHD.label, Icon: IconCurrencyBahraini },
  BIF: { label: CURRENCY_CODE_LABELS.BIF.label, Icon: IconCoins },
  BMD: { label: CURRENCY_CODE_LABELS.BMD.label, Icon: IconCurrencyDollar },
  BND: {
    label: CURRENCY_CODE_LABELS.BND.label,
    Icon: IconCurrencyDollarBrunei,
  },
  BOB: { label: CURRENCY_CODE_LABELS.BOB.label, Icon: IconCoins },
  BRL: { label: CURRENCY_CODE_LABELS.BRL.label, Icon: IconCurrencyReal },
  BSD: { label: CURRENCY_CODE_LABELS.BSD.label, Icon: IconCurrencyDollar },
  BTN: { label: CURRENCY_CODE_LABELS.BTN.label, Icon: IconCurrencyDollar },
  BWP: { label: CURRENCY_CODE_LABELS.BWP.label, Icon: IconCoins },
  BYN: { label: CURRENCY_CODE_LABELS.BYN.label, Icon: IconCoins },
  BZD: { label: CURRENCY_CODE_LABELS.BZD.label, Icon: IconCurrencyDollar },
  CAD: {
    label: CURRENCY_CODE_LABELS.CAD.label,
    Icon: IconCurrencyDollarCanadian,
  },
  CDF: { label: CURRENCY_CODE_LABELS.CDF.label, Icon: IconCoins },
  CHF: { label: CURRENCY_CODE_LABELS.CHF.label, Icon: IconCurrencyFrank },
  CLP: { label: CURRENCY_CODE_LABELS.CLP.label, Icon: IconCoins },
  CNY: { label: CURRENCY_CODE_LABELS.CNY.label, Icon: IconCurrencyYuan },
  COP: { label: CURRENCY_CODE_LABELS.COP.label, Icon: IconCoins },
  CRC: { label: CURRENCY_CODE_LABELS.CRC.label, Icon: IconCoins },
  CUP: { label: CURRENCY_CODE_LABELS.CUP.label, Icon: IconCoins },
  CVE: { label: CURRENCY_CODE_LABELS.CVE.label, Icon: IconCoins },
  CZK: { label: CURRENCY_CODE_LABELS.CZK.label, Icon: IconCurrencyKroneCzech },
  DJF: { label: CURRENCY_CODE_LABELS.DJF.label, Icon: IconCoins },
  DKK: { label: CURRENCY_CODE_LABELS.DKK.label, Icon: IconCurrencyKroneDanish },
  DOP: { label: CURRENCY_CODE_LABELS.DOP.label, Icon: IconCoins },
  DZD: { label: CURRENCY_CODE_LABELS.DZD.label, Icon: IconCoins },
  EGP: { label: CURRENCY_CODE_LABELS.EGP.label, Icon: IconCoins },
  ERN: { label: CURRENCY_CODE_LABELS.ERN.label, Icon: IconCoins },
  ETB: { label: CURRENCY_CODE_LABELS.ETB.label, Icon: IconCoins },
  EUR: { label: CURRENCY_CODE_LABELS.EUR.label, Icon: IconCurrencyEuro },
  FJD: { label: CURRENCY_CODE_LABELS.FJD.label, Icon: IconCurrencyDollar },
  FKP: { label: CURRENCY_CODE_LABELS.FKP.label, Icon: IconCoins },
  GBP: { label: CURRENCY_CODE_LABELS.GBP.label, Icon: IconCurrencyPound },
  GEL: { label: CURRENCY_CODE_LABELS.GEL.label, Icon: IconCurrencyLari },
  GHS: { label: CURRENCY_CODE_LABELS.GHS.label, Icon: IconCoins },
  GIP: { label: CURRENCY_CODE_LABELS.GIP.label, Icon: IconCoins },
  GMD: { label: CURRENCY_CODE_LABELS.GMD.label, Icon: IconCoins },
  GNF: { label: CURRENCY_CODE_LABELS.GNF.label, Icon: IconCoins },
  GTQ: { label: CURRENCY_CODE_LABELS.GTQ.label, Icon: IconCurrencyQuetzal },
  GYD: {
    label: CURRENCY_CODE_LABELS.GYD.label,
    Icon: IconCurrencyDollarGuyanese,
  },
  HKD: { label: CURRENCY_CODE_LABELS.HKD.label, Icon: IconCurrencyRenminbi },
  HNL: { label: CURRENCY_CODE_LABELS.HNL.label, Icon: IconCurrencyLeu },
  HTG: { label: CURRENCY_CODE_LABELS.HTG.label, Icon: IconCoins },
  HUF: { label: CURRENCY_CODE_LABELS.HUF.label, Icon: IconCurrencyForint },
  IDR: { label: CURRENCY_CODE_LABELS.IDR.label, Icon: IconCoins },
  ILS: { label: CURRENCY_CODE_LABELS.ILS.label, Icon: IconCurrencyShekel },
  INR: { label: CURRENCY_CODE_LABELS.INR.label, Icon: IconCurrencyRupee },
  IQD: { label: CURRENCY_CODE_LABELS.IQD.label, Icon: IconCoins },
  IRR: { label: CURRENCY_CODE_LABELS.IRR.label, Icon: IconCurrencyIranianRial },
  ISK: { label: CURRENCY_CODE_LABELS.ISK.label, Icon: IconCoins },
  JMD: { label: CURRENCY_CODE_LABELS.JMD.label, Icon: IconCurrencyDollar },
  JOD: { label: CURRENCY_CODE_LABELS.JOD.label, Icon: IconCoins },
  JPY: { label: CURRENCY_CODE_LABELS.JPY.label, Icon: IconCurrencyYen },
  KES: { label: CURRENCY_CODE_LABELS.KES.label, Icon: IconCoins },
  KGS: { label: CURRENCY_CODE_LABELS.KGS.label, Icon: IconCurrencySom },
  KHR: { label: CURRENCY_CODE_LABELS.KHR.label, Icon: IconCoins },
  KMF: { label: CURRENCY_CODE_LABELS.KMF.label, Icon: IconCoins },
  KPW: { label: CURRENCY_CODE_LABELS.KPW.label, Icon: IconCurrencyWon },
  KRW: { label: CURRENCY_CODE_LABELS.KRW.label, Icon: IconCurrencyWon },
  KWD: { label: CURRENCY_CODE_LABELS.KWD.label, Icon: IconCurrencyDinar },
  KYD: { label: CURRENCY_CODE_LABELS.KYD.label, Icon: IconCurrencyDollar },
  KZT: { label: CURRENCY_CODE_LABELS.KZT.label, Icon: IconCurrencyTenge },
  LAK: { label: CURRENCY_CODE_LABELS.LAK.label, Icon: IconCurrencyKip },
  LBP: { label: CURRENCY_CODE_LABELS.LBP.label, Icon: IconCoins },
  LKR: { label: CURRENCY_CODE_LABELS.LKR.label, Icon: IconCoins },
  LRD: { label: CURRENCY_CODE_LABELS.LRD.label, Icon: IconCurrencyDollar },
  LSL: { label: CURRENCY_CODE_LABELS.LSL.label, Icon: IconCurrencyLeu },
  LYD: { label: CURRENCY_CODE_LABELS.LYD.label, Icon: IconCurrencyLyd },
  MAD: { label: CURRENCY_CODE_LABELS.MAD.label, Icon: IconCurrencyDirham },
  MDL: { label: CURRENCY_CODE_LABELS.MDL.label, Icon: IconCurrencyLeu },
  MGA: { label: CURRENCY_CODE_LABELS.MGA.label, Icon: IconCoins },
  MKD: { label: CURRENCY_CODE_LABELS.MKD.label, Icon: IconCoins },
  MMK: { label: CURRENCY_CODE_LABELS.MMK.label, Icon: IconCoins },
  MNT: { label: CURRENCY_CODE_LABELS.MNT.label, Icon: IconCurrencyTugrik },
  MOP: { label: CURRENCY_CODE_LABELS.MOP.label, Icon: IconCurrencyRenminbi },
  MRU: { label: CURRENCY_CODE_LABELS.MRU.label, Icon: IconCoins },
  MUR: { label: CURRENCY_CODE_LABELS.MUR.label, Icon: IconCoins },
  MVR: { label: CURRENCY_CODE_LABELS.MVR.label, Icon: IconCurrencyRufiyaa },
  MWK: { label: CURRENCY_CODE_LABELS.MWK.label, Icon: IconCoins },
  MXN: { label: CURRENCY_CODE_LABELS.MXN.label, Icon: IconCoins },
  MYR: { label: CURRENCY_CODE_LABELS.MYR.label, Icon: IconCoins },
  MZN: { label: CURRENCY_CODE_LABELS.MZN.label, Icon: IconCoins },
  NAD: { label: CURRENCY_CODE_LABELS.NAD.label, Icon: IconCurrencyDollar },
  NGN: { label: CURRENCY_CODE_LABELS.NGN.label, Icon: IconCurrencyNaira },
  NIO: { label: CURRENCY_CODE_LABELS.NIO.label, Icon: IconCoins },
  NOK: {
    label: CURRENCY_CODE_LABELS.NOK.label,
    Icon: IconCurrencyKroneSwedish,
  },
  NPR: {
    label: CURRENCY_CODE_LABELS.NPR.label,
    Icon: IconCurrencyRupeeNepalese,
  },
  NZD: { label: CURRENCY_CODE_LABELS.NZD.label, Icon: IconCurrencyDollar },
  OMR: { label: CURRENCY_CODE_LABELS.OMR.label, Icon: IconCoins },
  PAB: { label: CURRENCY_CODE_LABELS.PAB.label, Icon: IconCoins },
  PEN: { label: CURRENCY_CODE_LABELS.PEN.label, Icon: IconCoins },
  PGK: { label: CURRENCY_CODE_LABELS.PGK.label, Icon: IconCoins },
  PHP: { label: CURRENCY_CODE_LABELS.PHP.label, Icon: IconCurrencyPeso },
  PKR: { label: CURRENCY_CODE_LABELS.PKR.label, Icon: IconCoins },
  PLN: { label: CURRENCY_CODE_LABELS.PLN.label, Icon: IconCurrencyZloty },
  PYG: { label: CURRENCY_CODE_LABELS.PYG.label, Icon: IconCurrencyGuarani },
  QAR: { label: CURRENCY_CODE_LABELS.QAR.label, Icon: IconCurrencyRiyal },
  RON: { label: CURRENCY_CODE_LABELS.RON.label, Icon: IconCurrencyLeu },
  RSD: { label: CURRENCY_CODE_LABELS.RSD.label, Icon: IconCoins },
  RUB: { label: CURRENCY_CODE_LABELS.RUB.label, Icon: IconCurrencyRubel },
  RWF: { label: CURRENCY_CODE_LABELS.RWF.label, Icon: IconCoins },
  SAR: { label: CURRENCY_CODE_LABELS.SAR.label, Icon: IconCoins },
  SBD: { label: CURRENCY_CODE_LABELS.SBD.label, Icon: IconCurrencyDollar },
  SCR: { label: CURRENCY_CODE_LABELS.SCR.label, Icon: IconCoins },
  SDG: { label: CURRENCY_CODE_LABELS.SDG.label, Icon: IconCoins },
  SEK: {
    label: CURRENCY_CODE_LABELS.SEK.label,
    Icon: IconCurrencyKroneSwedish,
  },
  SGD: {
    label: CURRENCY_CODE_LABELS.SGD.label,
    Icon: IconCurrencyDollarSingapore,
  },
  SHP: { label: CURRENCY_CODE_LABELS.SHP.label, Icon: IconCoins },
  SLE: { label: CURRENCY_CODE_LABELS.SLE.label, Icon: IconCoins },
  SOS: { label: CURRENCY_CODE_LABELS.SOS.label, Icon: IconCoins },
  SRD: { label: CURRENCY_CODE_LABELS.SRD.label, Icon: IconCurrencyDollar },
  SSP: { label: CURRENCY_CODE_LABELS.SSP.label, Icon: IconCoins },
  STN: { label: CURRENCY_CODE_LABELS.STN.label, Icon: IconCoins },
  SVC: { label: CURRENCY_CODE_LABELS.SVC.label, Icon: IconCoins },
  SYP: { label: CURRENCY_CODE_LABELS.SYP.label, Icon: IconCoins },
  SZL: { label: CURRENCY_CODE_LABELS.SZL.label, Icon: IconCurrencyLeu },
  THB: { label: CURRENCY_CODE_LABELS.THB.label, Icon: IconCurrencyBaht },
  TJS: { label: CURRENCY_CODE_LABELS.TJS.label, Icon: IconCoins },
  TMT: { label: CURRENCY_CODE_LABELS.TMT.label, Icon: IconCurrencyManat },
  TND: { label: CURRENCY_CODE_LABELS.TND.label, Icon: IconCoins },
  TOP: { label: CURRENCY_CODE_LABELS.TOP.label, Icon: IconCurrencyPaanga },
  TRY: { label: CURRENCY_CODE_LABELS.TRY.label, Icon: IconCurrencyLira },
  TTD: { label: CURRENCY_CODE_LABELS.TTD.label, Icon: IconCurrencyDollar },
  TWD: { label: CURRENCY_CODE_LABELS.TWD.label, Icon: IconCurrencyRenminbi },
  TZS: { label: CURRENCY_CODE_LABELS.TZS.label, Icon: IconCoins },
  UAH: { label: CURRENCY_CODE_LABELS.UAH.label, Icon: IconCurrencyHryvnia },
  UGX: { label: CURRENCY_CODE_LABELS.UGX.label, Icon: IconCoins },
  USD: { label: CURRENCY_CODE_LABELS.USD.label, Icon: IconCurrencyDollar },
  UYU: { label: CURRENCY_CODE_LABELS.UYU.label, Icon: IconCoins },
  UZS: { label: CURRENCY_CODE_LABELS.UZS.label, Icon: IconCoins },
  VES: { label: CURRENCY_CODE_LABELS.VES.label, Icon: IconCoins },
  VND: { label: CURRENCY_CODE_LABELS.VND.label, Icon: IconCurrencyDong },
  VUV: { label: CURRENCY_CODE_LABELS.VUV.label, Icon: IconCoins },
  WST: { label: CURRENCY_CODE_LABELS.WST.label, Icon: IconCoins },
  XOF: { label: CURRENCY_CODE_LABELS.XOF.label, Icon: IconCoins },
  XCD: { label: CURRENCY_CODE_LABELS.XCD.label, Icon: IconCurrencyDollar },
  YER: { label: CURRENCY_CODE_LABELS.YER.label, Icon: IconCoins },
  ZAR: { label: CURRENCY_CODE_LABELS.ZAR.label, Icon: IconCoins },
  ZMW: { label: CURRENCY_CODE_LABELS.ZMW.label, Icon: IconCoins },
  ZWG: { label: CURRENCY_CODE_LABELS.ZWG.label, Icon: IconCoins },
};
