import { DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID } from '@/page-layout/constants/DefaultCompanyRecordPageLayoutId';
import { type PageLayout } from '@/page-layout/types/PageLayout';
import {
  PageLayoutTabLayoutMode,
  PageLayoutType,
  WidgetConfigurationType,
  WidgetType,
} from '~/generated-metadata/graphql';

export const DEFAULT_COMPANY_RECORD_PAGE_LAYOUT: PageLayout = {
  __typename: 'PageLayout',
  id: DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID,
  name: 'Default Company Layout',
  type: PageLayoutType.RECORD_PAGE,
  objectMetadataId: null,
  createdAt: new Date().toISOString(),
  updatedAt: new Date().toISOString(),
  deletedAt: null,
  tabs: [
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'company-tab-fields',
      title: 'Home',
      icon: 'IconHome',
      position: 100,
      layoutMode: PageLayoutTabLayoutMode.VERTICAL_LIST,
      pageLayoutId: DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'company-widget-fields',
          pageLayoutTabId: 'company-tab-fields',
          title: 'Fields',
          type: WidgetType.FIELDS,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 12,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: WidgetConfigurationType.FIELDS,
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'company-tab-timeline',
      title: 'Timeline',
      icon: 'IconTimelineEvent',
      position: 200,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'company-widget-timeline',
          pageLayoutTabId: 'company-tab-timeline',
          title: 'Timeline',
          type: WidgetType.TIMELINE,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: WidgetConfigurationType.FIELDS,
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'company-tab-tasks',
      title: 'Tasks',
      icon: 'IconCheckbox',
      position: 300,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'company-widget-tasks',
          pageLayoutTabId: 'company-tab-tasks',
          title: 'Tasks',
          type: WidgetType.TASKS,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: WidgetConfigurationType.FIELDS,
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'company-tab-notes',
      title: 'Notes',
      icon: 'IconNotes',
      position: 400,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'company-widget-notes',
          pageLayoutTabId: 'company-tab-notes',
          title: 'Notes',
          type: WidgetType.NOTES,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: WidgetConfigurationType.FIELDS,
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'company-tab-files',
      title: 'Files',
      icon: 'IconPaperclip',
      position: 500,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'company-widget-files',
          pageLayoutTabId: 'company-tab-files',
          title: 'Files',
          type: WidgetType.FILES,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: WidgetConfigurationType.FIELDS,
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'company-tab-emails',
      title: 'Emails',
      icon: 'IconMail',
      position: 600,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'company-widget-emails',
          pageLayoutTabId: 'company-tab-emails',
          title: 'Emails',
          type: WidgetType.EMAILS,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: WidgetConfigurationType.FIELDS,
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
    {
      __typename: 'PageLayoutTab',
      applicationId: '',
      id: 'company-tab-calendar',
      title: 'Calendar',
      icon: 'IconCalendarEvent',
      position: 700,
      layoutMode: PageLayoutTabLayoutMode.CANVAS,
      pageLayoutId: DEFAULT_COMPANY_RECORD_PAGE_LAYOUT_ID,
      createdAt: new Date().toISOString(),
      updatedAt: new Date().toISOString(),
      deletedAt: null,
      widgets: [
        {
          __typename: 'PageLayoutWidget',
          id: 'company-widget-calendar',
          pageLayoutTabId: 'company-tab-calendar',
          title: 'Calendar',
          type: WidgetType.CALENDAR,
          objectMetadataId: null,
          gridPosition: {
            __typename: 'GridPosition',
            row: 0,
            column: 0,
            rowSpan: 6,
            columnSpan: 12,
          },
          configuration: {
            __typename: 'FieldsConfiguration',
            configurationType: WidgetConfigurationType.FIELDS,
            sections: [],
          },
          createdAt: new Date().toISOString(),
          updatedAt: new Date().toISOString(),
          deletedAt: null,
        },
      ],
    },
  ],
};
