import { FieldMetadataType } from 'twenty-shared/types';

export const mockPerformance = {
  objectMetadataItem: {
    __typename: 'object',
    id: '4916628e-8570-4242-8970-f58c509e5a93',
    nameSingular: 'person',
    namePlural: 'people',
    primaryLinkLabelSingular: 'Person',
    primaryLinkLabelPlural: 'People',
    description: 'A person',
    icon: 'IconUser',
    isCustom: false,
    isRemote: false,
    isActive: true,
    isSystem: false,
    createdAt: '2024-05-16T10:54:27.788Z',
    updatedAt: '2024-05-16T10:54:27.788Z',
    primaryLinkLabelIdentifierFieldMetadataId: null,
    imageIdentifierFieldMetadataId: null,
    fields: [
      {
        __typename: 'field',
        id: '9058056e-36b3-4a3f-9037-f0bca9744296',
        type: 'RELATION',
        name: 'company',
        primaryLinkLabel: 'Company',
        description: 'Contact’s company',
        icon: 'IconBuildingSkyscraper',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: {
          __typename: 'Relation',
          relationId: '0cf72416-3d94-4d94-abf3-7dc9d734435b',
          direction: 'MANY_TO_ONE',
          sourceObjectMetadata: {
            __typename: 'object',
            id: '4916628e-8570-4242-8970-f58c509e5a93',
            nameSingular: 'person',
            namePlural: 'people',
          },
          sourceFieldMetadata: {
            __typename: 'field',
            id: '9058056e-36b3-4a3f-9037-f0bca9744296',
            name: 'company',
          },
          targetObjectMetadata: {
            __typename: 'object',
            id: '79c2d29c-76f6-432f-91c9-df1259b73d95',
            nameSingular: 'company',
            namePlural: 'companies',
          },
          targetFieldMetadata: {
            __typename: 'field',
            id: '7b281010-5f47-4771-b3f5-f4bcd24ed1b5',
            name: 'people',
          },
        },
      },
      {
        __typename: 'field',
        id: 'bd504d22-ecae-4228-8729-5c770a174336',
        type: 'TEXT',
        name: 'avatarUrl',
        primaryLinkLabel: 'Avatar',
        description: 'Contact’s avatar',
        icon: 'IconFileUpload',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: "''",
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: '21238919-5d92-402e-8124-367948ef86e6',
        type: 'TEXT',
        name: 'city',
        primaryLinkLabel: 'City',
        description: 'Contact’s city',
        icon: 'IconMap',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: false,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: "''",
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: '78edf4bb-c6a6-449e-b9db-20a575b97d5e',
        type: 'RELATION',
        name: 'activityTargets',
        primaryLinkLabel: 'Activities',
        description: 'Activities tied to the contact',
        icon: 'IconCheckbox',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: {
          __typename: 'Relation',
          relationId: 'd76f949d-023d-4b45-a71e-f39e3b1562ba',
          direction: 'ONE_TO_MANY',
          sourceObjectMetadata: {
            __typename: 'object',
            id: '4916628e-8570-4242-8970-f58c509e5a93',
            nameSingular: 'person',
            namePlural: 'people',
          },
          sourceFieldMetadata: {
            __typename: 'field',
            id: '78edf4bb-c6a6-449e-b9db-20a575b97d5e',
            name: 'activityTargets',
          },
          targetObjectMetadata: {
            __typename: 'object',
            id: '82222ca2-dd40-44ec-b8c5-eb0eca9ec625',
            nameSingular: 'activityTarget',
            namePlural: 'activityTargets',
          },
          targetFieldMetadata: {
            __typename: 'field',
            id: 'f5f515cc-6d8a-44c3-b2d4-f04b9868a9c5',
            name: 'person',
          },
        },
      },
      {
        __typename: 'field',
        id: '4128b168-1439-441e-bb6a-223fa1276642',
        type: 'RELATION',
        name: 'pointOfContactForOpportunities',
        primaryLinkLabel: 'POC for Opportunities',
        description: 'Point of Contact for Opportunities',
        icon: 'IconTargetArrow',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: {
          __typename: 'Relation',
          relationId: 'a5a61d23-8ac9-4014-9441-ec3a1781a661',
          direction: 'ONE_TO_MANY',
          sourceObjectMetadata: {
            __typename: 'object',
            id: '4916628e-8570-4242-8970-f58c509e5a93',
            nameSingular: 'person',
            namePlural: 'people',
          },
          sourceFieldMetadata: {
            __typename: 'field',
            id: '4128b168-1439-441e-bb6a-223fa1276642',
            name: 'pointOfContactForOpportunities',
          },
          targetObjectMetadata: {
            __typename: 'object',
            id: '494b9b7c-a44e-4d52-b274-cdfb0e322165',
            nameSingular: 'opportunity',
            namePlural: 'opportunities',
          },
          targetFieldMetadata: {
            __typename: 'field',
            id: '86559a6f-6afc-4d5c-9bed-fc74d063791b',
            name: 'pointOfContact',
          },
        },
      },
      {
        __typename: 'field',
        id: '3db3a6ac-a960-42bd-8375-59ab6c4837d6',
        type: 'RELATION',
        name: 'calendarEventParticipants',
        primaryLinkLabel: 'Calendar Event Participants',
        description: 'Calendar Event Participants',
        icon: 'IconCalendar',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: {
          __typename: 'Relation',
          relationId: '456f7875-b48c-4795-a0c7-a69d7339afee',
          direction: 'ONE_TO_MANY',
          sourceObjectMetadata: {
            __typename: 'object',
            id: '4916628e-8570-4242-8970-f58c509e5a93',
            nameSingular: 'person',
            namePlural: 'people',
          },
          sourceFieldMetadata: {
            __typename: 'field',
            id: '3db3a6ac-a960-42bd-8375-59ab6c4837d6',
            name: 'calendarEventParticipants',
          },
          targetObjectMetadata: {
            __typename: 'object',
            id: 'eba13fca-57b7-470c-8c23-a0e640e04ffb',
            nameSingular: 'calendarEventParticipant',
            namePlural: 'calendarEventParticipants',
          },
          targetFieldMetadata: {
            __typename: 'field',
            id: 'c1cdebda-b514-4487-9b9c-aa59d8fca8eb',
            name: 'person',
          },
        },
      },
      {
        __typename: 'field',
        id: 'f0a290ac-fa74-48da-a77f-db221cb0206a',
        type: 'DATE_TIME',
        name: 'createdAt',
        primaryLinkLabel: 'Creation date',
        description: 'Creation date',
        icon: 'IconCalendar',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: false,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: 'now',
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: 'b96e0e45-278c-44b6-a601-30ba24592dd6',
        type: 'RELATION',
        name: 'favorites',
        primaryLinkLabel: 'Favorites',
        description: 'Favorites linked to the contact',
        icon: 'IconHeart',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: {
          __typename: 'Relation',
          relationId: '31542774-fb15-4d01-b00b-8fc94887f458',
          direction: 'ONE_TO_MANY',
          sourceObjectMetadata: {
            __typename: 'object',
            id: '4916628e-8570-4242-8970-f58c509e5a93',
            nameSingular: 'person',
            namePlural: 'people',
          },
          sourceFieldMetadata: {
            __typename: 'field',
            id: 'b96e0e45-278c-44b6-a601-30ba24592dd6',
            name: 'favorites',
          },
          targetObjectMetadata: {
            __typename: 'object',
            id: 'f08422e2-14cd-4966-9cd3-bce0302cc56f',
            nameSingular: 'favorite',
            namePlural: 'favorites',
          },
          targetFieldMetadata: {
            __typename: 'field',
            id: '67d28b17-ff3c-49b4-a6da-1354be9634b0',
            name: 'person',
          },
        },
      },
      {
        __typename: 'field',
        id: '430af81e-2a8c-4ce2-9969-c0f0e91818bb',
        type: 'LINK',
        name: 'linkedinLink',
        primaryLinkLabel: 'Linkedin',
        description: 'Contact’s Linkedin account',
        icon: 'IconBrandLinkedin',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: {
          primaryLinkUrl: "''",
          primaryLinkLabel: "''",
        },
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: 'c885c3d9-63e2-4c0d-b7d6-ee9e867eb1f6',
        type: 'RELATION',
        name: 'attachments',
        primaryLinkLabel: 'Attachments',
        description: 'Attachments linked to the contact.',
        icon: 'IconFileImport',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: {
          __typename: 'Relation',
          relationId: 'c0cc3456-afa4-46e0-820d-2db0b63a8273',
          direction: 'ONE_TO_MANY',
          sourceObjectMetadata: {
            __typename: 'object',
            id: '4916628e-8570-4242-8970-f58c509e5a93',
            nameSingular: 'person',
            namePlural: 'people',
          },
          sourceFieldMetadata: {
            __typename: 'field',
            id: 'c885c3d9-63e2-4c0d-b7d6-ee9e867eb1f6',
            name: 'attachments',
          },
          targetObjectMetadata: {
            __typename: 'object',
            id: '0e3c9a9d-8a60-4671-a466-7b840a422da2',
            nameSingular: 'attachment',
            namePlural: 'attachments',
          },
          targetFieldMetadata: {
            __typename: 'field',
            id: 'a920a0d6-8e71-4ab8-90b9-ab540e04732a',
            name: 'person',
          },
        },
      },
      {
        __typename: 'field',
        id: 'cc63e38f-56d6-495e-a545-edf101e400cf',
        type: 'TEXT',
        name: 'phone',
        primaryLinkLabel: 'Phone',
        description: 'Contact’s phone number',
        icon: 'IconPhone',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: false,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: "''",
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: '0084a5f7-cb57-4cd5-8b14-93ab51c21f45',
        type: 'POSITION',
        name: 'position',
        primaryLinkLabel: 'Position',
        description: 'Person record Position',
        icon: 'IconHierarchy2',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: 'ca54aa1d-1ecb-486c-99ea-b8240871a0da',
        type: 'EMAIL',
        name: 'email',
        primaryLinkLabel: 'Email',
        description: 'Contact’s Email',
        icon: 'IconMail',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: false,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: "''",
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: '54561a8e-b918-471b-a363-5a77f49cd348',
        type: 'TEXT',
        name: 'jobTitle',
        primaryLinkLabel: 'Job Title',
        description: 'Contact’s job title',
        icon: 'IconBriefcase',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: false,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: "''",
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: '4e844d31-f117-443c-8754-8cb63e963ecc',
        type: 'DATE_TIME',
        name: 'updatedAt',
        primaryLinkLabel: 'Update date',
        description: 'Update date',
        icon: 'IconCalendar',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: 'now',
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: '4ddd38df-d9a3-4889-a39f-1e336cd8113c',
        type: 'UUID',
        name: 'companyId',
        primaryLinkLabel: 'Company id (foreign key)',
        description: 'Contact’s company id foreign key',
        icon: 'IconBuildingSkyscraper',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: 'e6922ecb-7a3a-4520-b001-bbf95fc33197',
        type: 'RELATION',
        name: 'timelineActivities',
        primaryLinkLabel: 'Events',
        description: 'Events linked to the company',
        icon: 'IconTimelineEvent',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: {
          __typename: 'Relation',
          relationId: '25150feb-fcd7-407e-b5fa-ffe58a0450ac',
          direction: 'ONE_TO_MANY',
          sourceObjectMetadata: {
            __typename: 'object',
            id: '4916628e-8570-4242-8970-f58c509e5a93',
            nameSingular: 'person',
            namePlural: 'people',
          },
          sourceFieldMetadata: {
            __typename: 'field',
            id: 'e6922ecb-7a3a-4520-b001-bbf95fc33197',
            name: 'timelineActivities',
          },
          targetObjectMetadata: {
            __typename: 'object',
            id: '83b5ff3e-975e-4dc9-ba4d-c645a0d8afb2',
            nameSingular: 'timelineActivity',
            namePlural: 'timelineActivities',
          },
          targetFieldMetadata: {
            __typename: 'field',
            id: '556a12d4-ef0a-4232-963f-0f317f4c5ef5',
            name: 'person',
          },
        },
      },
      {
        __typename: 'field',
        id: '07a8a574-ed28-4015-b456-c01ff3050e2b',
        type: 'FULL_NAME',
        name: 'name',
        primaryLinkLabel: 'Name',
        description: 'Contact’s name',
        icon: 'IconUser',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: {
          lastName: "''",
          firstName: "''",
        },
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: 'c470144b-6692-47cb-a28f-04610d9d641c',
        type: 'LINK',
        name: 'xLink',
        primaryLinkLabel: 'X',
        description: 'Contact’s X/Twitter account',
        icon: 'IconBrandX',
        isCustom: false,
        isActive: true,
        isSystem: false,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: {
          primaryLinkUrl: "''",
          primaryLinkLabel: "''",
        },
        options: null,
        relation: null,
      },
      {
        __typename: 'field',
        id: 'c692aa2c-e88e-4aff-b77e-b9ebf26509e3',
        type: 'RELATION',
        name: 'messageParticipants',
        primaryLinkLabel: 'Message Participants',
        description: 'Message Participants',
        icon: 'IconUserCircle',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: true,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: null,
        options: null,
        relation: {
          __typename: 'Relation',
          relationId: 'e2eb7156-6e65-4bf8-922b-670179744f27',
          direction: 'ONE_TO_MANY',
          sourceObjectMetadata: {
            __typename: 'object',
            id: '4916628e-8570-4242-8970-f58c509e5a93',
            nameSingular: 'person',
            namePlural: 'people',
          },
          sourceFieldMetadata: {
            __typename: 'field',
            id: 'c692aa2c-e88e-4aff-b77e-b9ebf26509e3',
            name: 'messageParticipants',
          },
          targetObjectMetadata: {
            __typename: 'object',
            id: 'ffd8e640-84b7-4ed6-99e9-14def0f9d82b',
            nameSingular: 'messageParticipant',
            namePlural: 'messageParticipants',
          },
          targetFieldMetadata: {
            __typename: 'field',
            id: '8c4593a1-ad40-4681-92fe-43ad4fe60205',
            name: 'person',
          },
        },
      },
      {
        __typename: 'field',
        id: '66d33eae-71be-49fa-ad7a-3e10ac53dfba',
        type: 'UUID',
        name: 'id',
        primaryLinkLabel: 'Id',
        description: 'Id',
        icon: 'Icon123',
        isCustom: false,
        isActive: true,
        isSystem: true,
        isNullable: false,
        createdAt: '2024-05-16T10:54:27.788Z',
        updatedAt: '2024-05-16T10:54:27.788Z',
        defaultValue: 'uuid',
        options: null,
        relation: null,
      },
    ],
  },
  recordId: '20202020-2d40-4e49-8df4-9c6a049191df',
  relationRecordId: '20202020-c21e-4ec2-873b-de4264d89025',
  entityValue: {
    __typename: 'Person',
    asd: '',
    city: 'Seattle',
    jobTitle: '',
    name: {
      __typename: 'FullName',
      firstName: 'Lorie',
      lastName: 'Vladim',
    },
    createdAt: '2024-05-01T13:16:29.046Z',
    company: {
      __typename: 'Company',
      domainName: 'google.com',
      xLink: {
        __typename: 'Link',
        primaryLinkLabel: '',
        primaryLinkUrl: '',
      },
      name: 'Google',
      annualRecurringRevenue: {
        __typename: 'Currency',
        amountMicros: null,
        currencyCode: '',
      },
      employees: null,
      accountOwnerId: null,
      address: {
        addressCity: 'San Francisco',
      },
      idealCustomerProfile: false,
      createdAt: '2024-05-01T13:16:29.046Z',
      id: '20202020-c21e-4ec2-873b-de4264d89025',
      position: 6,
      updatedAt: '2024-05-01T13:16:29.046Z',
      linkedinLink: {
        __typename: 'Link',
        primaryLinkLabel: '',
        primaryLinkUrl: '',
      },
    },
    id: '20202020-2d40-4e49-8df4-9c6a049191df',
    email: 'lorie.vladim@google.com',
    phones: {
      primaryPhoneCountryCode: 'FR',
      primaryPhoneCallingCode: '+33',
      primaryPhoneNumber: '788901235',
    },
    linkedinLink: {
      __typename: 'Link',
      primaryLinkLabel: '',
      primaryLinkUrl: '',
    },
    xLink: {
      __typename: 'Link',
      primaryLinkLabel: '',
      primaryLinkUrl: '',
    },
    tEst: '',
    position: 15,
  },
  relationFieldValue: {
    __typename: 'Company',
    domainName: 'microsoft.com',
    xLink: {
      __typename: 'Link',
      primaryLinkLabel: '',
      primaryLinkUrl: '',
    },
    name: 'Microsoft',
    annualRecurringRevenue: {
      __typename: 'Currency',
      amountMicros: null,
      currencyCode: '',
    },
    employees: null,
    accountOwnerId: null,
    address: { addressCity: 'San Francisco' },
    idealCustomerProfile: false,
    createdAt: '2024-05-01T13:16:29.046Z',
    id: '20202020-ed89-413a-b31a-962986e67bb4',
    position: 4,
    updatedAt: '2024-05-01T13:16:29.046Z',
    linkedinLink: {
      __typename: 'Link',
      primaryLinkLabel: '',
      primaryLinkUrl: '',
    },
  },
  fieldDefinition: {
    fieldMetadataId: '9058056e-36b3-4a3f-9037-f0bca9744296',
    primaryLinkLabel: 'Company',
    metadata: {
      fieldName: 'company',
      placeHolder: 'Company',
      relationType: 'TO_ONE_OBJECT',
      relationFieldMetadataId: '7b281010-5f47-4771-b3f5-f4bcd24ed1b5',
      relationObjectMetadataNameSingular: 'company',
      relationObjectMetadataNamePlural: 'companies',
      objectMetadataNameSingular: 'person',
      options: null,
    },
    label: 'Company',
    iconName: 'IconBuildingSkyscraper',
    type: FieldMetadataType.RELATION,
    position: 2,
    size: 150,
    isLabelIdentifier: false,
    isVisible: true,
    viewFieldId: '9a479a97-deaa-4ddb-9d59-96f05875ac09',
    isSortable: false,
    isFilterable: true,
    defaultValue: null,
  },
  visibleTableColumns: [
    {
      fieldMetadataId: '07a8a574-ed28-4015-b456-c01ff3050e2b',
      primaryLinkLabel: 'Name',
      metadata: {
        fieldName: 'name',
        placeHolder: 'Name',
        relationObjectMetadataNameSingular: '',
        relationObjectMetadataNamePlural: '',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconUser',
      type: 'FULL_NAME',
      position: 0,
      size: 210,
      isLabelIdentifier: true,
      isVisible: true,
      viewFieldId: '2953bf2a-4da3-4aab-871b-489acc5cf433',
      isSortable: false,
      isFilterable: true,
      defaultValue: {
        lastName: "''",
        firstName: "''",
      },
    },
    {
      fieldMetadataId: 'ca54aa1d-1ecb-486c-99ea-b8240871a0da',
      primaryLinkLabel: 'Email',
      metadata: {
        fieldName: 'email',
        placeHolder: 'Email',
        relationObjectMetadataNameSingular: '',
        relationObjectMetadataNamePlural: '',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconMail',
      type: 'EMAIL',
      position: 1,
      size: 150,
      isLabelIdentifier: false,
      isVisible: true,
      viewFieldId: '356e102f-e561-43fe-9a99-f79a8dff591e',
      isSortable: false,
      isFilterable: true,
      defaultValue: "''",
    },
    {
      fieldMetadataId: '9058056e-36b3-4a3f-9037-f0bca9744296',
      primaryLinkLabel: 'Company',
      metadata: {
        fieldName: 'company',
        placeHolder: 'Company',
        relationType: 'TO_ONE_OBJECT',
        relationFieldMetadataId: '7b281010-5f47-4771-b3f5-f4bcd24ed1b5',
        relationObjectMetadataNameSingular: 'company',
        relationObjectMetadataNamePlural: 'companies',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconBuildingSkyscraper',
      type: 'RELATION',
      position: 2,
      size: 150,
      isLabelIdentifier: false,
      isVisible: true,
      viewFieldId: '9a479a97-deaa-4ddb-9d59-96f05875ac09',
      isSortable: false,
      isFilterable: true,
      defaultValue: null,
    },
    {
      fieldMetadataId: 'cc63e38f-56d6-495e-a545-edf101e400cf',
      primaryLinkLabel: 'Phone',
      metadata: {
        fieldName: 'phone',
        placeHolder: 'Phone',
        relationObjectMetadataNameSingular: '',
        relationObjectMetadataNamePlural: '',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconPhone',
      type: 'TEXT',
      position: 3,
      size: 150,
      isLabelIdentifier: false,
      isVisible: true,
      viewFieldId: '45fdb554-aaca-4f0a-8c8c-af0a7b3dc69b',
      isSortable: true,
      isFilterable: true,
      defaultValue: "''",
    },
    {
      fieldMetadataId: 'f0a290ac-fa74-48da-a77f-db221cb0206a',
      primaryLinkLabel: 'Creation date',
      metadata: {
        fieldName: 'createdAt',
        placeHolder: 'Creation date',
        relationObjectMetadataNameSingular: '',
        relationObjectMetadataNamePlural: '',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconCalendar',
      type: 'DATE_TIME',
      position: 4,
      size: 150,
      isLabelIdentifier: false,
      isVisible: true,
      viewFieldId: 'bba977df-5a14-4023-a966-3a6ca4c04985',
      isSortable: true,
      isFilterable: true,
      defaultValue: 'now',
    },
    {
      fieldMetadataId: '21238919-5d92-402e-8124-367948ef86e6',
      primaryLinkLabel: 'City',
      metadata: {
        fieldName: 'city',
        placeHolder: 'City',
        relationObjectMetadataNameSingular: '',
        relationObjectMetadataNamePlural: '',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconMap',
      type: 'TEXT',
      position: 5,
      size: 150,
      isLabelIdentifier: false,
      isVisible: true,
      viewFieldId: '3c8c9615-b645-46a0-9dc9-5a9f5cb8016f',
      isSortable: true,
      isFilterable: true,
      defaultValue: "''",
    },
    {
      fieldMetadataId: '54561a8e-b918-471b-a363-5a77f49cd348',
      primaryLinkLabel: 'Job Title',
      metadata: {
        fieldName: 'jobTitle',
        placeHolder: 'Job Title',
        relationObjectMetadataNameSingular: '',
        relationObjectMetadataNamePlural: '',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconBriefcase',
      type: 'TEXT',
      position: 6,
      size: 150,
      isLabelIdentifier: false,
      isVisible: true,
      viewFieldId: '26ef3a6d-1a26-4a56-baf7-ba863d29d9fb',
      isSortable: true,
      isFilterable: true,
      defaultValue: "''",
    },
    {
      fieldMetadataId: '430af81e-2a8c-4ce2-9969-c0f0e91818bb',
      primaryLinkLabel: 'Linkedin',
      metadata: {
        fieldName: 'linkedinLink',
        placeHolder: 'Linkedin',
        relationObjectMetadataNameSingular: '',
        relationObjectMetadataNamePlural: '',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconBrandLinkedin',
      type: 'LINK',
      position: 7,
      size: 150,
      isLabelIdentifier: false,
      isVisible: true,
      viewFieldId: '45496857-28ed-49fe-91d6-03aa369a4c03',
      isSortable: false,
      isFilterable: true,
      defaultValue: {
        primaryLinkUrl: "''",
        primaryLinkLabel: "''",
      },
    },
    {
      fieldMetadataId: 'c470144b-6692-47cb-a28f-04610d9d641c',
      primaryLinkLabel: 'X',
      metadata: {
        fieldName: 'xLink',
        placeHolder: 'X',
        relationObjectMetadataNameSingular: '',
        relationObjectMetadataNamePlural: '',
        objectMetadataNameSingular: 'person',
        options: null,
      },
      iconName: 'IconBrandX',
      type: 'LINK',
      position: 8,
      size: 150,
      isLabelIdentifier: false,
      isVisible: true,
      viewFieldId: '37344257-17f0-48f4-a523-1211948cbe99',
      isSortable: false,
      isFilterable: true,
      defaultValue: {
        primaryLinkUrl: "''",
        primaryLinkLabel: "''",
      },
    },
  ],
};
